/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefProcessor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefSQLOps;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.util.regex.GlobPattern;

public class MultiComponentTypeRefQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final ComponentTypeRefSQLOps TABLE = new ComponentTypeRefSQLOps("ctrT");
    VersionRange mComponentRefVersionFilter;
    GlobPattern mComponentRefFullNameFilter;
    GlobPattern mNameFilter;
    GlobPattern mDescrptionFilter;
    GlobPattern mOrderFilter;
    GlobPattern mGroupFilter;
    private String[] mNotInGroupsFilter;

    public static MultiComponentTypeRefQuery all() {
        MultiComponentTypeRefQuery result = new MultiComponentTypeRefQuery((ConditionalExpression)null);
        result.setObjectOrder(ComponentTypeRefOrder.BY_ORDER_ASC);
        return result;
    }

    public static MultiComponentTypeRefQuery byPlatform(HostSetID platform) throws PersistenceManagerException, RPCException {
        MultiComponentTypeRefQuery result = new MultiComponentTypeRefQuery(TABLE.matchesPlatform(platform));
        result.setObjectOrder(ComponentTypeRefOrder.BY_ORDER_ASC);
        return result;
    }

    static MultiComponentTypeRefQuery byComponent(ComponentID comp) {
        MultiComponentTypeRefQuery result = new MultiComponentTypeRefQuery(TABLE.refsComponent(comp));
        return result;
    }

    static MultiComponentTypeRefQuery byIDs(ComponentTypeRefID[] ids) {
        MultiComponentTypeRefQuery result = new MultiComponentTypeRefQuery(ids);
        return result;
    }

    private MultiComponentTypeRefQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, ComponentTypeRefOrder.FACTORY);
    }

    private MultiComponentTypeRefQuery(ComponentTypeRefID[] IDs) {
        super((Table)TABLE, IDs, ComponentTypeRefOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((ComponentTypeRefOrder)order);
    }

    public GlobPattern getNameFilter() {
        return this.mNameFilter;
    }

    public void setNameFilter(GlobPattern nameFilter) {
        this.mNameFilter = nameFilter;
    }

    public GlobPattern getDescriptionFilter() {
        return this.mDescrptionFilter;
    }

    public void setDescriptionFilter(GlobPattern descFilter) {
        this.mDescrptionFilter = descFilter;
    }

    public GlobPattern getGroupFilter() {
        return this.mGroupFilter;
    }

    public void setGroupFilter(GlobPattern groupFilter) {
        this.mGroupFilter = groupFilter;
    }

    public GlobPattern getOrderFilter() {
        return this.mOrderFilter;
    }

    public void setOrderFilter(GlobPattern orderFilter) {
        this.mOrderFilter = orderFilter;
    }

    public GlobPattern getComponentRefFullNameFilter() {
        return this.mComponentRefFullNameFilter;
    }

    public void setComponentRefFullNameFilter(GlobPattern componentRefFullNameFilter) {
        this.mComponentRefFullNameFilter = componentRefFullNameFilter;
    }

    public VersionRange getComponentRefVersionFilter() {
        return this.mComponentRefVersionFilter;
    }

    public void setComponentRefVersionFilter(VersionRange versionFilter) {
        this.mComponentRefVersionFilter = versionFilter;
    }

    public String[] getNotInGroupsFilter() {
        return this.mNotInGroupsFilter;
    }

    public void setNotInGroupsFilter(String[] notInGroupsFilter) {
        this.mNotInGroupsFilter = notInGroupsFilter;
    }

    public ComponentTypeRef[] select() throws RPCException, PersistenceManagerException {
        return (ComponentTypeRef[])this.select(new ComponentTypeRefProcessor(this.getTable(), false, false), ComponentTypeRef.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        ComponentTypeRefSQLOps t = (ComponentTypeRefSQLOps)this.getTable();
        if (this.getNameFilter() != null) {
            ctx.addAndWhereCondition(t.matchesName(this.getNameFilter()));
        }
        if (this.getDescriptionFilter() != null) {
            ctx.addAndWhereCondition(t.matchesDescription(this.getDescriptionFilter()));
        }
        if (this.getOrderFilter() != null) {
            ctx.addAndWhereCondition(t.matchesOrder(this.getOrderFilter()));
        }
        if (this.getGroupFilter() != null) {
            ctx.addAndWhereCondition(t.matchesGroup(this.getGroupFilter()));
        }
        if (this.getNotInGroupsFilter() != null) {
            ctx.addAndWhereCondition(t.notInGroups(this.getNotInGroupsFilter()));
        }
        if (this.getComponentRefFullNameFilter() != null) {
            ctx.addAndWhereCondition(t.matchesComponentRefFullName(this.getComponentRefFullNameFilter(), ctx));
        }
        if (this.getComponentRefVersionFilter() != null) {
            ctx.addAndWhereCondition(t.matchesComponentRefVersion(this.getComponentRefVersionFilter()));
        }
    }
}

