/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireWriteLockRPCTransaction;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompleteComponentProcessor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponentProcessor;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.util.regex.GlobPattern;
import java.security.AccessControlException;
import java.util.HashSet;

public class MultiComponentQuery
extends MultiStandardObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final ComponentSQLOps TABLE = new ComponentSQLOps("compT");
    private VersionRange mVersionFilter;
    private GlobPattern mLabelFilter;
    private CategoryID mCategoryFilter;
    private FullPathFilter mFullPathFilter;
    public static final FolderID EMPTY_FOLDER = new FolderID("/$empty$/");
    private FolderID mAccessibilityFilter;
    Modifier mModifierFilter;
    public static final String ROOT_TYPE_NAME = "$root$";
    private String mExtendsTypeFilter;
    private String mInstanceOfTypeFilter;
    private String mInstanceOfTypeGroupFilter;
    private boolean mExcludeSentinelComp = true;

    public static MultiComponentQuery all() {
        MultiComponentQuery result = new MultiComponentQuery((ConditionalExpression)null);
        result.setObjectOrder(ComponentOrder.BY_NAME_ASC);
        result.setVisibilityFilter(Visibility.VISIBLE);
        return result;
    }

    static MultiComponentQuery allVersionsOf(ComponentID compID) {
        MultiComponentQuery result = new MultiComponentQuery(TABLE.isVersionOf(compID));
        result.setObjectOrder(ComponentOrder.BY_VERSION_DESC);
        return result;
    }

    static MultiComponentQuery byIDs(ComponentIDSet idSet) {
        MultiComponentQuery result = new MultiComponentQuery(idSet);
        return result;
    }

    static MultiComponentQuery byRefs(ComponentRef[] refs) {
        MultiComponentQuery result = new MultiComponentQuery(TABLE.matchesRefs(refs));
        result.setObjectOrder(ComponentOrder.BY_NAME_ASC);
        return result;
    }

    private MultiComponentQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, ComponentOrder.FACTORY);
    }

    private MultiComponentQuery(ComponentIDSet idSet) {
        super((Table)TABLE, idSet.toIDArray(), ComponentOrder.FACTORY);
        this.setExcludeSentinelComp(idSet.contains(ComponentID.COMPONENT_SENTINEL_ID));
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((ComponentOrder)order);
    }

    public VersionRange getVersionFilter() {
        return this.mVersionFilter;
    }

    public void setVersionFilter(VersionRange versionFilter) {
        this.mVersionFilter = versionFilter;
    }

    public void setLabelFilter(GlobPattern filter) {
        this.mLabelFilter = filter;
    }

    public GlobPattern getLabelFilter() {
        return this.mLabelFilter;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID filter) {
        this.mCategoryFilter = filter;
    }

    public FullPathFilter getFullPathFilter() {
        return this.mFullPathFilter;
    }

    public void setFullPathFilter(FullPathFilter pathFilter) {
        this.mFullPathFilter = pathFilter;
    }

    public FolderID getAccessibilityFilter() {
        return this.mAccessibilityFilter;
    }

    public void setAccessibilityFilter(FolderID path) {
        this.mAccessibilityFilter = path;
    }

    public Modifier getNotModifierFilter() {
        return this.mModifierFilter;
    }

    public void setNotModifierFilter(Modifier mod) {
        this.mModifierFilter = mod;
    }

    public String getExtendsTypeFilter() {
        return this.mExtendsTypeFilter;
    }

    public void setExtendsTypeFilter(String typeName) {
        this.mExtendsTypeFilter = typeName;
    }

    public String getInstanceOfTypeFilter() {
        return this.mInstanceOfTypeFilter;
    }

    public void setInstanceOfTypeFilter(String typeName) {
        this.mInstanceOfTypeFilter = typeName;
    }

    public String getInstanceOfTypeGroupFilter() {
        return this.mInstanceOfTypeGroupFilter;
    }

    public void setInstanceOfTypeGroupFilter(String typeGroup) {
        this.mInstanceOfTypeGroupFilter = typeGroup;
    }

    private boolean getExcludeSentinelComp() {
        return this.mExcludeSentinelComp;
    }

    private void setExcludeSentinelComp(boolean exclude) {
        this.mExcludeSentinelComp = exclude;
    }

    public StandardObject[] selectStandardObjectView() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    public Component[] select() throws RPCException, PersistenceManagerException {
        CompleteComponentProcessor processor = new CompleteComponentProcessor(this.getTable(), false, false);
        return (Component[])this.select(processor, Component.class);
    }

    public SummaryComponent[] selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryComponentProcessor processor = new SummaryComponentProcessor(this.getTable(), false);
        return (SummaryComponent[])this.select(processor, SummaryComponent.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        String typeName;
        super.addFilterCondition(ctx);
        ComponentSQLOps t = (ComponentSQLOps)this.getTable();
        if (this.getVersionFilter() != null) {
            ctx.addAndWhereCondition(t.matchesVersion(this.getVersionFilter()));
        }
        if (this.getLabelFilter() != null) {
            ctx.addAndWhereCondition(t.matchesLabel(this.getLabelFilter()));
        }
        if (this.getCategoryFilter() != null) {
            ctx.addAndWhereCondition(t.matchesCat(this.getCategoryFilter()));
        }
        if (this.getFullPathFilter() != null) {
            this.getFullPathFilter().addFilterCondition(ctx, t);
        }
        if (this.getAccessibilityFilter() != null) {
            ctx.addAndWhereCondition(t.isAccessibleTo(this.getAccessibilityFilter()));
        }
        if (this.getNotModifierFilter() != null) {
            Modifier modifierFilter = this.getNotModifierFilter();
            ctx.addAndWhereCondition(ComponentSQLOps.not(t.hasModifier(modifierFilter)));
        }
        if (this.getExtendsTypeFilter() != null) {
            typeName = this.getExtendsTypeFilter();
            if (ROOT_TYPE_NAME.equals(typeName)) {
                typeName = null;
            }
            ctx.addAndWhereCondition(t.extendsType(typeName));
        }
        if (this.getInstanceOfTypeFilter() != null && !ROOT_TYPE_NAME.equals(typeName = this.getInstanceOfTypeFilter())) {
            ctx.addAndWhereCondition(t.isInstanceOfType(typeName));
        }
        if (this.getInstanceOfTypeGroupFilter() != null) {
            String typeGroup = this.getInstanceOfTypeGroupFilter();
            ctx.addAndWhereCondition(t.isInstanceOfTypeGroup(typeGroup));
        }
        if (this.getExcludeSentinelComp()) {
            ctx.addAndWhereCondition(ComponentSQLOps.not(ComponentSQLOps.equals(t.ID, ComponentID.COMPONENT_SENTINEL_ID)));
        }
    }

    protected TableList getTableList() {
        TableList theResult = super.getTableList();
        if (this.getFullPathFilter() != null) {
            theResult = this.getFullPathFilter().getTableList(theResult);
        }
        return theResult;
    }

    public CategoryIDSet selectSharedCategories() throws RPCException, PersistenceManagerException {
        return ComponentToCategoryLinkTable.DEFAULT.getSharedCategories(this.selectIDs());
    }

    public int updateCategories(CategoryUpdateContext ctx) throws RPCException, PersistenceManagerException {
        return ComponentToCategoryLinkTable.DEFAULT.updateCategories(this.selectIDs(), ctx);
    }

    public int updateVisibility(Visibility vis) throws RPCException, PersistenceManagerException {
        return super.updateVisibility(vis);
    }

    public void move(FolderID path) throws PersistenceManagerException, RPCException, AccessControlException {
        if (path == null) {
            return;
        }
        MultiComponentQuery.move(this.selectSummaryView(), path);
    }

    static void move(final SummaryComponent[] comps, final FolderID path) throws RPCException, PersistenceManagerException {
        if (path == null) {
            return;
        }
        MultiComponentQuery.transactRPC(new AcquireWriteLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    SummaryFolder f = path == null ? null : path.getByIDQuery().selectSummaryView();
                    MultiComponentQuery.trMoveMS(comps, f);
                    return null;
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("cdb.MOVING_COMPONENTS");
            }
        });
    }

    private static void trMoveMS(SummaryComponent[] comps, SummaryFolder path) throws PersistenceManagerException {
        HashSet<ComponentID> roots = new HashSet<ComponentID>();
        for (int i = 0; i < comps.length; ++i) {
            if (!roots.add(comps[i].getRootID())) continue;
            ComponentID.trMoveMS(comps[i].getRootID(), null, path);
        }
    }

    public static void trMoveMS(SummaryFolder path) throws PersistenceManagerException, AccessControlException {
        if (path == null) {
            return;
        }
        MultiComponentQuery mcq = MultiComponentQuery.all();
        mcq.setVisibilityFilter(null);
        mcq.setObjectOrder(null);
        mcq.setFullPathFilter(new FullPathFilter(path.getID(), null, false));
        try {
            SummaryComponent[] comps = mcq.selectSummaryView();
            MultiComponentQuery.trMoveMS(comps, path);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }
}

