/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;

public class InstalledComponentRef
extends ComponentRef {
    private String mInstallPath;
    private Comparator mComparator = Comparator.GREATER_THAN_EQUAL;
    private boolean mIsUniversal = false;
    private boolean mOnlyCallCompatible;

    private InstalledComponentRef() {
    }

    public InstalledComponentRef(String componentName) {
        this(FolderID.ROOT_FOLDER_ID, componentName, null, null, false, null, true);
    }

    public InstalledComponentRef(String componentName, String componentVersion, String installPath) {
        this(FolderID.ROOT_FOLDER_ID, componentName, componentVersion, Comparator.EQUAL, false, installPath, false);
    }

    public InstalledComponentRef(String unresPath, String componentName, String componentVersion, Comparator versionComparator, boolean onlyCallCompatible, String installPath, boolean isUniversal) {
        super(unresPath, componentName, componentVersion);
        this.setVersionComparator(versionComparator);
        this.setOnlyCallCompatible(onlyCallCompatible);
        this.setIsUniversal(isUniversal);
        this.setInstallPath(installPath);
    }

    public InstalledComponentRef(FolderID path, String componentName, String componentVersion, Comparator versionComparator, boolean onlyCallCompatible, String installPath, boolean isUniversal) {
        super(path, componentName, componentVersion);
        this.setVersionComparator(versionComparator);
        this.setOnlyCallCompatible(onlyCallCompatible);
        this.setIsUniversal(isUniversal);
        this.setInstallPath(installPath);
    }

    public String getInstallPath() {
        return this.mInstallPath;
    }

    private void setInstallPath(String installPath) {
        if ("".equals(installPath)) {
            installPath = null;
        }
        if (installPath == null) {
            this.setIsUniversal(true);
        }
        this.mInstallPath = installPath;
    }

    public Comparator getVersionComparator() {
        return this.mComparator;
    }

    private void setVersionComparator(Comparator comp) {
        if (comp == null) {
            comp = Comparator.GREATER_THAN_EQUAL;
        }
        this.mComparator = comp;
    }

    public boolean isUniversal() {
        return this.mIsUniversal;
    }

    private void setIsUniversal(boolean isUniversal) {
        this.mIsUniversal = isUniversal;
    }

    public InstalledComponentRef toUniversal() {
        if (this.isUniversal()) {
            return this;
        }
        InstalledComponentRef result = (InstalledComponentRef)this.clone();
        result.setInstallPath(InstalledComponentRef.toUniversalPath(result.getInstallPath()));
        result.setIsUniversal(true);
        return result;
    }

    public boolean getOnlyCallCompatible() {
        return this.mOnlyCallCompatible;
    }

    private void setOnlyCallCompatible(boolean onlyCallCompatible) {
        this.mOnlyCallCompatible = onlyCallCompatible;
    }

    public InstalledComponentRef generate(ConfigGenerator generator) throws ConfigGenException {
        String installPath = this.getInstallPath();
        if (installPath == null) {
            return this;
        }
        InstalledComponentRef result = (InstalledComponentRef)this.clone();
        installPath = generator.generate(installPath);
        installPath = InstalledComponentRef.toUniversalPath(installPath);
        result.setInstallPath(installPath);
        result.setIsUniversal(true);
        return result;
    }

    public static String toUniversalPath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = FileSpec.convertPathSeparatorToUniversal(path)).endsWith(FileSpec.UNIVERSAL_FILE_SEPARATOR) && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof InstalledComponentRef)) {
            return false;
        }
        InstalledComponentRef otherComp = (InstalledComponentRef)other;
        if (!this.equals(otherComp.getInstallPath(), this.getInstallPath())) {
            return false;
        }
        if (otherComp.isUniversal() != this.isUniversal()) {
            return false;
        }
        if (!this.equals(this.getVersionComparator(), otherComp.getVersionComparator())) {
            return false;
        }
        return this.getOnlyCallCompatible() == otherComp.getOnlyCallCompatible();
    }

    public int hashCode() {
        String installPath = this.getInstallPath();
        return super.hashCode() + (installPath == null ? 0 : installPath.hashCode()) + this.getVersionComparator().hashCode() + (this.getOnlyCallCompatible() ? 7 : 11);
    }

    public String toString() {
        return "component{name=" + this.getComponentFullName() + ",version=" + this.getComponentVersion() + ",versionOp=" + this.getVersionComparator() + ",onlyCompat=" + this.getOnlyCallCompatible() + ",installPath=" + this.getInstallPath() + "}";
    }

    void accept(CompDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getInstallPath());
    }

    ComponentRef accept(CompDBTransformer t) throws Exception {
        InstalledComponentRef cr = (InstalledComponentRef)super.accept(t);
        cr.setInstallPath(t.transformToken(this.getInstallPath()));
        return cr;
    }
}

