/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsImplTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

class ComponentVariableSettingsSQLOps
extends ComponentVariableSettingsImplTable {
    public static final ComponentVariableSettingsSQLOps DEFAULT = new ComponentVariableSettingsSQLOps();

    public ComponentVariableSettingsSQLOps(String alias) {
        super(alias);
    }

    private ComponentVariableSettingsSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new ComponentVariableSettingsSQLOps(alias);
    }

    public ConditionalExpression isInComp(ComponentID compID) {
        return ComponentVariableSettingsSQLOps.equals(this.ComponentID, compID);
    }

    public ConditionalExpression isInComps(ComponentID[] compIDs) {
        return ComponentVariableSettingsSQLOps.emptyIn(this.ComponentID, ComponentVariableSettingsSQLOps.rList(compIDs));
    }

    public ConditionalExpression isNameAndComp(String name, ComponentID compID) {
        return ComponentVariableSettingsSQLOps.and(ComponentVariableSettingsSQLOps.equals(this.Name, name), this.isInComp(compID));
    }

    public OrderByList orderByCompAsc(QueryContext ctx) {
        return ComponentVariableSettingsSQLOps.oList(ComponentVariableSettingsSQLOps.orderByAsc(this.ComponentID)).add(this.orderByNameAsc(ctx));
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return ComponentVariableSettingsSQLOps.dictOrderAsc(this.Name);
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        return ComponentVariableSettingsSQLOps.dictOrderDesc(this.Name);
    }

    public HashSet getNamesByComp(ComponentID compID) throws PersistenceManagerException {
        StringProcessor sp = new StringProcessor();
        ComponentVariableSettingsSQLOps.execute(this.select(ComponentVariableSettingsSQLOps.sList(this.Name), ComponentVariableSettingsSQLOps.where(this.isInComp(compID))), sp);
        return sp.getResults();
    }

    private static class StringProcessor
    extends ResultSetProcessor {
        private HashSet mResults = new HashSet();

        private StringProcessor() {
        }

        public void processResultSet(ResultSet inResultSet) throws SQLException {
            while (inResultSet.next()) {
                this.mResults.add(StringColumn.getValue(inResultSet, 1));
            }
        }

        public HashSet getResults() {
            return this.mResults;
        }
    }
}

