/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireReadLockTransaction;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompVarSettingsToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsID;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import java.util.Hashtable;

class ComponentVariableSettingsImpl
extends PersistentBean
implements Cloneable,
ComponentObserver {
    private VariableSettingsHolder mOverrides = new VariableSettingsHolder();
    private String mName;
    private ComponentID mComponentID;
    private SummaryComponent mComponent;
    private VariableSettingsSource mComponentVars;
    private Hashtable mFinalVarMap = new Hashtable();

    private ComponentVariableSettingsImpl() {
    }

    static ComponentVariableSettingsImpl create(ComponentID compID) throws PersistenceManagerException, RPCException {
        ComponentVariableSettingsImpl result = new ComponentVariableSettingsImpl(compID);
        result.setComponent(compID.getByIDQuery().select());
        return result;
    }

    static ComponentVariableSettingsImpl create(Component comp) {
        ComponentVariableSettingsImpl result = new ComponentVariableSettingsImpl(comp.getID());
        result.setComponent(comp);
        return result;
    }

    private ComponentVariableSettingsImpl(ComponentID compID) {
        this.setComponentID(compID);
    }

    ComponentVariableSettingsID getID() {
        return (ComponentVariableSettingsID)this.getObjectID();
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int count) {
        super.setUpdateCount(count);
    }

    String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    private ComponentID getComponentID() {
        return this.mComponentID;
    }

    private void setComponentID(ComponentID componentID) {
        if (componentID == null) {
            throw new NullPointerException();
        }
        this.mComponentID = componentID;
    }

    String getOverrideVarValue(String varName) {
        return this.mOverrides.getVarValue(varName);
    }

    String[] getOverrideVarNames() {
        return this.mOverrides.getVarNames();
    }

    void setOverrideVarValue(String varName, String value) {
        this.mOverrides.setVarValue(varName, value);
    }

    void removeOverrideVarValue(String varName) {
        this.mOverrides.removeVarValue(varName);
    }

    boolean containsOverrideVarValue(String varName) {
        return this.mOverrides.containsVarValue(varName);
    }

    private String[] getOverrideSettings() {
        return this.mOverrides.getVarSettings();
    }

    private void setOverrideSettings(String[] settings) {
        this.mOverrides.setVarSettings(settings);
    }

    ComponentVariableSettings getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new ComponentVariableSettings(this);
    }

    SummaryComponent getComponent() {
        return this.mComponent;
    }

    VariableSettingsSource getComponentVars() {
        return this.mComponentVars;
    }

    private void setComponent(Component component) {
        this.mComponent = component.toReadOnlyView();
        VarDecl[] vars = component.getVarList(CallSpec.PUBLIC);
        this.mComponentVars = VarDecl.toVariableSettings(vars);
        for (int i = 0; i < vars.length; ++i) {
            if (!Modifier.FINAL.equals(vars[i].getModifier())) continue;
            this.mFinalVarMap.put(vars[i].getName(), vars[i].getName());
        }
    }

    boolean isReadOnlyVar(String varName) {
        return this.mFinalVarMap.containsKey(varName);
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.mComponent != null) {
            return;
        }
        try {
            this.setComponent(this.getComponentID().getByIDQuery().select());
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    protected Object clone() {
        try {
            ComponentVariableSettingsImpl result = (ComponentVariableSettingsImpl)super.clone();
            result.mOverrides = (VariableSettingsHolder)result.mOverrides.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            return super.getObjectDataClone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save(ComponentVariableSettings vars) throws PersistenceManagerException, RPCException {
        this.validate(vars);
        this.saveRPC(null);
    }

    protected void saveMS(final PersistContext ctx) throws PersistenceManagerException {
        ComponentVariableSettingsImpl.transactMS(new AcquireReadLockTransaction(){

            public Object execute() throws PersistenceManagerException {
                ComponentVariableSettingsImpl.this.executeSaveMS(ctx);
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("cdb.SAVING_COMPVARSETTINGS", ComponentVariableSettingsImpl.this.getName());
            }
        });
    }

    private void executeSaveMS(PersistContext ctx) throws PersistenceManagerException {
        this.getComponentID().lockForUpdateMS();
        ComponentVariableSettingsID.verifyPerms(this.getComponent());
        super.saveMS(ctx);
        CompVarSettingsToComponentNameRefTable cvst = CompVarSettingsToComponentNameRefTable.DEFAULT;
        cvst.removeByParentID(this.getID());
        NameRefSet set = new NameRefSet();
        this.addComponentRefsMS(set);
        cvst.addReferences(this.getID(), set);
    }

    private void saveOnlyMS() throws PersistenceManagerException {
        super.saveMS(null);
    }

    void validate(ComponentVariableSettings vars) throws PersistenceManagerException, RPCException {
        Component comp = this.getComponentID().getByIDQuery().select();
        ComponentVariableSettings.validateComponent(comp);
        ComponentVariableSettings.validateName(this.getName());
        String[] names = this.getOverrideVarNames();
        VariableSettingsSource compVars = this.getComponentVars();
        for (int i = 0; i < names.length; ++i) {
            if (!compVars.containsVarValue(names[i])) {
                throw ComponentDBException.invalidVarsVarName(names[i]);
            }
            if (!this.isReadOnlyVar(names[i])) continue;
            throw ComponentDBException.readOnlyVarsVar(names[i]);
        }
        try {
            VariableSettingsSource overrideVars = vars.getOverrideVariableSettingsSource();
            ComponentConfigManager.validate(overrideVars, vars, new Caller(null, comp));
        }
        catch (ConfigGenException e) {
            throw ComponentDBException.invalidVarsVars(e);
        }
    }

    public void renameComponent(SummaryComponent sc, String name, SummaryFolder path) throws PersistenceManagerException, RPCException {
        this.updateComponentRefsMS(sc, name, path).saveOnlyMS();
    }

    void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        ComponentNameRefAdder adder = new ComponentNameRefAdder(set, this.getCallerMS());
        try {
            adder.visit(this);
        }
        catch (Exception e) {
            throw adder.mapException(e);
        }
    }

    ComponentVariableSettingsImpl updateComponentRefsMS(SummaryComponent sc, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ComponentNameRefUpdater updater = new ComponentNameRefUpdater(sc, this.getCallerMS(), newName, newPath);
        try {
            return updater.transform(this);
        }
        catch (Exception e) {
            throw updater.mapException(e);
        }
    }

    void accept(CompDBVisitor v) throws Exception {
        String[] varNames = this.getOverrideVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            v.visitToken(this.getOverrideVarValue(varNames[i]));
        }
    }

    ComponentVariableSettingsImpl accept(CompDBTransformer t) throws Exception {
        ComponentVariableSettingsImpl cvs = t.clone(this);
        String[] varNames = cvs.getOverrideVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            String varValue = cvs.getOverrideVarValue(varNames[i]);
            String ovrValue = t.transformToken(varValue);
            if (ovrValue == null) continue;
            cvs.setOverrideVarValue(varNames[i], ovrValue);
        }
        return cvs;
    }

    ComponentVariableSettingsImpl cloneForTransform() {
        return (ComponentVariableSettingsImpl)this.clone();
    }

    private Caller getCallerMS() throws PersistenceManagerException {
        try {
            return new Caller(null, this.getComponentID().getByIDQuery().select());
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }
}

