/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentReferrer;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.util.Validate;

public class ComponentVariableSettings
implements RPCSerializable,
VariableSettingsSource,
Cloneable,
ComponentReferrer {
    private ComponentVariableSettingsImpl mVars;
    private boolean mVarsIsCopy;

    private ComponentVariableSettings() {
    }

    ComponentVariableSettings(ComponentVariableSettingsImpl vars) {
        this.setVars(vars);
        this.mVarsIsCopy = false;
    }

    public ComponentVariableSettings(ComponentID compID) throws PersistenceManagerException, RPCException {
        this.setVars(ComponentVariableSettingsImpl.create(compID));
        this.mVarsIsCopy = true;
    }

    ComponentVariableSettings(Component comp, ComponentVariableSettings varSets) {
        this.setVars(ComponentVariableSettingsImpl.create(comp));
        this.mVarsIsCopy = true;
        this.setName(varSets.getName());
        String[] names = varSets.getOverrideVarNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (!this.containsVarValue(name) || this.isReadOnlyVar(name)) continue;
            this.setOverrideVarValue(name, varSets.getOverrideVarValue(name));
        }
    }

    ComponentVariableSettingsImpl getVars() {
        return this.mVars;
    }

    private void setVars(ComponentVariableSettingsImpl vars) {
        this.mVars = vars;
    }

    private ComponentVariableSettingsImpl getMutableVars() {
        if (!this.mVarsIsCopy) {
            this.setVars((ComponentVariableSettingsImpl)this.getVars().clone());
            this.mVarsIsCopy = true;
        }
        return this.getVars();
    }

    public SummaryComponent getComponent() {
        return this.getVars().getComponent();
    }

    private VariableSettingsSource getComponentVars() {
        return this.getVars().getComponentVars();
    }

    public ComponentVariableSettingsID getID() {
        return this.getVars().getID();
    }

    public String getName() {
        return this.getVars().getName();
    }

    public void setName(String name) {
        this.getMutableVars().setName(name);
    }

    public String getOverrideVarValue(String varName) {
        return this.getVars().getOverrideVarValue(varName);
    }

    public void setOverrideVarValue(String varName, String value) {
        this.getMutableVars().setOverrideVarValue(varName, value);
    }

    public void removeOverrideVarValue(String varName) {
        this.getMutableVars().removeOverrideVarValue(varName);
    }

    public String[] getOverrideVarNames() {
        return this.getVars().getOverrideVarNames();
    }

    public boolean containsOverrideVarValue(String varName) {
        return this.getVars().containsOverrideVarValue(varName);
    }

    public VariableSettingsSource getOverrideVariableSettingsSource() {
        return new VariableSettingsSource(){

            public String getVarValue(String varName) {
                return ComponentVariableSettings.this.getOverrideVarValue(varName);
            }

            public String[] getVarNames() {
                return ComponentVariableSettings.this.getOverrideVarNames();
            }

            public boolean containsVarValue(String varName) {
                return ComponentVariableSettings.this.containsOverrideVarValue(varName);
            }
        };
    }

    public String getVarValue(String varName) {
        String result = this.getOverrideVarValue(varName);
        if (result == null) {
            result = this.getComponentVars().getVarValue(varName);
        }
        return result;
    }

    public String[] getVarNames() {
        return this.getComponentVars().getVarNames();
    }

    public boolean containsVarValue(String varName) {
        return this.getComponentVars().containsVarValue(varName);
    }

    public boolean isReadOnlyVar(String varName) {
        return this.getVars().isReadOnlyVar(varName);
    }

    public int getUpdateCount() {
        return this.getVars().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableVars().setUpdateCount(updateCount);
    }

    public ComponentVariableSettings getDataClone() {
        ComponentVariableSettingsImpl vars = (ComponentVariableSettingsImpl)this.getVars().getObjectDataClone();
        return new ComponentVariableSettings(vars);
    }

    public Object clone() {
        ComponentVariableSettingsImpl vars = this.mVarsIsCopy ? (ComponentVariableSettingsImpl)this.getVars().clone() : this.getVars();
        return new ComponentVariableSettings(vars);
    }

    public void save() throws PersistenceManagerException, RPCException {
        this.getMutableVars().save(this);
    }

    void saveMS() throws PersistenceManagerException, RPCException {
        this.validate();
        this.getMutableVars().saveMS(null);
    }

    public void validate() throws PersistenceManagerException, RPCException {
        this.getVars().validate(this);
    }

    public static void validateName(String name) throws ComponentDBException {
        if (name == null) {
            throw ComponentDBException.invalidVarsName(name);
        }
        int len = name.length();
        if (len == 0 || len > 32) {
            throw ComponentDBException.invalidVarsName(name);
        }
        if (!Validate.isValidFirstCharForName(name.charAt(0))) {
            throw ComponentDBException.invalidVarsName(name);
        }
        for (int i = 0; i < len; ++i) {
            if (ComponentVariableSettings.isValidNameChar(name.charAt(i))) continue;
            throw ComponentDBException.invalidVarsName(name);
        }
    }

    private static boolean isValidNameChar(char ch) {
        return Validate.isValidNameChar(ch) || ch == '(' || ch == ')';
    }

    public static void validateComponent(SummaryComponent comp) throws ComponentDBException {
        if (Modifier.ABSTRACT.equals(comp.getModifier())) {
            throw ComponentDBException.invalidVarsComp(comp);
        }
        if (!AccessMode.PUBLIC.equals(comp.getAccessMode())) {
            throw ComponentDBException.invalidVarsComp(comp);
        }
    }

    public void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        this.getVars().addComponentRefsMS(set);
    }
}

