/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Comparison;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToCompTypeRefLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImplTable;
import com.raplix.util.regex.GlobPattern;

class ComponentTypeRefSQLOps
extends ComponentTypeRefImplTable {
    public static final ComponentTypeRefSQLOps DEFAULT = new ComponentTypeRefSQLOps();

    public ComponentTypeRefSQLOps(String alias) {
        super(alias);
    }

    private ComponentTypeRefSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new ComponentTypeRefSQLOps(alias);
    }

    public ConditionalExpression isName(String name) {
        return ComponentTypeRefSQLOps.equals(this.Name, name);
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return ComponentTypeRefSQLOps.dictOrderAsc(this.Name);
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        return ComponentTypeRefSQLOps.dictOrderDesc(this.Name);
    }

    public OrderByList orderByOrderAsc(QueryContext ctx) {
        return ComponentTypeRefSQLOps.dictOrderAsc(this.Order).add(this.orderByNameAsc(ctx));
    }

    public OrderByList orderByOrderDesc(QueryContext ctx) {
        return ComponentTypeRefSQLOps.dictOrderDesc(this.Order).add(this.orderByNameDesc(ctx));
    }

    public OrderByList orderByPluginOrderAsc(QueryContext ctx) {
        PluginImplTable pT = new PluginImplTable("htT");
        Comparison containerPlugin = ComponentTypeRefSQLOps.equals((ColumnNode)pT.ID, this.PluginID);
        Select pluginOrder = pT.select(ComponentTypeRefSQLOps.sList(pT.MenuOrder), ComponentTypeRefSQLOps.where(containerPlugin));
        Select pluginName = pT.select(ComponentTypeRefSQLOps.sList(pT.Name), ComponentTypeRefSQLOps.where(containerPlugin));
        return ComponentTypeRefSQLOps.dictOrderAsc(ComponentTypeRefSQLOps.scalar(pluginOrder)).add(ComponentTypeRefSQLOps.dictOrderAsc(ComponentTypeRefSQLOps.scalar(pluginName))).add(this.orderByOrderAsc(ctx));
    }

    public OrderByList orderByPluginOrderDesc(QueryContext ctx) {
        PluginImplTable pT = new PluginImplTable("htT");
        Comparison containerPlugin = ComponentTypeRefSQLOps.equals((ColumnNode)pT.ID, this.PluginID);
        Select pluginOrder = pT.select(ComponentTypeRefSQLOps.sList(pT.MenuOrder), ComponentTypeRefSQLOps.where(containerPlugin));
        Select pluginName = pT.select(ComponentTypeRefSQLOps.sList(pT.Name), ComponentTypeRefSQLOps.where(containerPlugin));
        return ComponentTypeRefSQLOps.dictOrderDesc(ComponentTypeRefSQLOps.scalar(pluginOrder)).add(ComponentTypeRefSQLOps.dictOrderDesc(ComponentTypeRefSQLOps.scalar(pluginName))).add(this.orderByOrderDesc(ctx));
    }

    public OrderByList orderByGroupAsc(QueryContext ctx) {
        return ComponentTypeRefSQLOps.dictOrderAsc(this.Group).add(this.orderByOrderAsc(ctx));
    }

    public OrderByList orderByGroupDesc(QueryContext ctx) {
        return ComponentTypeRefSQLOps.dictOrderDesc(this.Group).add(this.orderByOrderDesc(ctx));
    }

    public OrderByList orderByComponentRefFullNameAsc(QueryContext ctx) {
        FolderImplTable fT = new FolderImplTable("fT");
        ctx.addTable(fT);
        ctx.addAndWhereCondition(ComponentTypeRefSQLOps.equals((ColumnNode)fT.ID, this.CompPathID));
        return ComponentTypeRefSQLOps.dictOrderAsc(fT.FullPathString).add(ComponentTypeRefSQLOps.dictOrderAsc(this.CompName));
    }

    public OrderByList orderByComponentRefFullNameDesc(QueryContext ctx) {
        FolderImplTable fT = new FolderImplTable("fT");
        ctx.addTable(fT);
        ctx.addAndWhereCondition(ComponentTypeRefSQLOps.equals((ColumnNode)fT.ID, this.CompPathID));
        return ComponentTypeRefSQLOps.dictOrderDesc(fT.FullPathString).add(ComponentTypeRefSQLOps.dictOrderDesc(this.CompName));
    }

    public OrderByList orderByComponentRefVersionAsc(QueryContext ctx) {
        OrderByList result = ComponentTypeRefSQLOps.oList();
        result.add(ComponentTypeRefSQLOps.orderByAsc(this.CompVersion));
        result.add(this.orderByComponentRefFullNameAsc(ctx));
        return result;
    }

    public OrderByList orderByComponentRefVersionDesc(QueryContext ctx) {
        OrderByList result = ComponentTypeRefSQLOps.oList();
        result.add(ComponentTypeRefSQLOps.orderByDesc(this.CompVersion));
        result.add(this.orderByComponentRefFullNameDesc(ctx));
        return result;
    }

    public ConditionalExpression matchesName(GlobPattern name) {
        return ComponentTypeRefSQLOps.likeLower(this.Name, name);
    }

    public ConditionalExpression matchesOrder(GlobPattern order) {
        return ComponentTypeRefSQLOps.likeLower(this.Order, order);
    }

    public ConditionalExpression matchesGroup(GlobPattern group) {
        return ComponentTypeRefSQLOps.likeLower(this.Group, group);
    }

    public ConditionalExpression notInGroups(String[] groups) {
        return ComponentTypeRefSQLOps.not(ComponentTypeRefSQLOps.emptyIn(this.Group, ComponentTypeRefSQLOps.rList(groups)));
    }

    public ConditionalExpression matchesDescription(GlobPattern desc) {
        return ComponentTypeRefSQLOps.likeLower(this.Description, desc);
    }

    public ConditionalExpression matchesComponentRefFullName(GlobPattern componentRefName, QueryContext ctx) {
        FolderImplTable fT = new FolderImplTable("fT");
        ctx.addTable(fT);
        ctx.addAndWhereCondition(ComponentTypeRefSQLOps.equals((ColumnNode)fT.ID, this.CompPathID));
        return ComponentTypeRefSQLOps.like((ScalarExp)ComponentTypeRefSQLOps.lower(ComponentTypeRefSQLOps.concat(fT.FullPathString, this.CompName)), ComponentTypeRefSQLOps.v(componentRefName.toSQLPattern()));
    }

    public ConditionalExpression matchesComponentRefVersion(VersionRange componentRefVersion) {
        return componentRefVersion.getConditional(this.CompVersion);
    }

    public ConditionalExpression refsComponent(ComponentID cID) {
        ComponentSQLOps ct = ComponentSQLOps.DEFAULT;
        return this.refsComp(ct, ComponentTypeRefSQLOps.equals(ct.ID, cID));
    }

    public ConditionalExpression matchesPlatform(HostSetID hostSet) throws PersistenceManagerException, RPCException {
        ComponentSQLOps ct = new ComponentSQLOps("icT");
        return this.refsComp(ct, ct.matchesPlatform(hostSet));
    }

    public Select selectCompByRef(ComponentTypeRefID ref) {
        return this.select(ComponentTypeRefSQLOps.sList(this.CompPathID, this.CompName, this.CompVersion), ComponentTypeRefSQLOps.where(ComponentTypeRefSQLOps.equals(this.ID, ref)));
    }

    ConditionalExpression refsComp(ComponentSQLOps ct, ConditionalExpression cond) {
        return ComponentTypeRefSQLOps.in(ComponentTypeRefSQLOps.cList(this.CompPathID, this.CompName, this.CompVersion), ct.select(ComponentTypeRefSQLOps.sList(ct.PathID, ct.Name, ct.Version), ComponentTypeRefSQLOps.where(cond)));
    }

    Select selectNamesOfInstancesOfType(String typeName) {
        ComponentTypeRefSQLOps ictr = new ComponentTypeRefSQLOps("ictr");
        Select typeID = ictr.selectIDsWhere(ComponentTypeRefSQLOps.equals(ictr.Name, typeName));
        return this.selectNamesWhere(this.isInstanceOf(typeID));
    }

    Select selectNamesOfInstancesOfGroup(String typeGroup) {
        ComponentTypeRefSQLOps ictr = new ComponentTypeRefSQLOps("ictr");
        Select typeIDsInGroup = ictr.selectIDsWhere(ComponentTypeRefSQLOps.equals(ictr.Group, typeGroup));
        return this.selectNamesWhere(this.isInstanceOf(typeIDsInGroup));
    }

    ConditionalExpression isInstanceOf(Select rootTypeIDs) {
        Select derivedTypeIDs = CompTypeRefToCompTypeRefLinkTable.DEFAULT.selectChildIDs(rootTypeIDs);
        return ComponentTypeRefSQLOps.or(ComponentTypeRefSQLOps.in((ColumnNode)this.ID, rootTypeIDs), ComponentTypeRefSQLOps.in((ColumnNode)this.ID, derivedTypeIDs));
    }

    private Select selectIDsWhere(ConditionalExpression condition) {
        return this.select(ComponentTypeRefSQLOps.sList(this.ID), ComponentTypeRefSQLOps.where(condition));
    }

    private Select selectNamesWhere(ConditionalExpression condition) {
        return this.select(ComponentTypeRefSQLOps.sList(this.Name), ComponentTypeRefSQLOps.where(condition));
    }
}

