/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireWriteLockTransaction;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToCompTypeRefLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallCompatibilityValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;

class ComponentTypeRefImpl
extends PersistentBean
implements Cloneable {
    private String mSimpleName;
    private String mPluginName;
    private String mDescription = "";
    private String mOrder = "ANY-00000-SYSTEM";
    private String mGroup = "";
    private int mIndentLevel = 0;
    private ComponentRef mComponentRef;
    private String mCompName;
    private FolderID mCompPathID;
    private int mCompVersion;
    private PluginID mPluginID;

    private ComponentTypeRefImpl() {
    }

    static ComponentTypeRefImpl create() {
        ComponentTypeRefImpl result = new ComponentTypeRefImpl();
        return result;
    }

    static ComponentTypeRefImpl create(PluginID plugin) throws PersistenceManagerException, RPCException {
        ComponentTypeRefImpl result = ComponentTypeRefImpl.create();
        result.setPluginID(plugin);
        String pluginName = plugin.getByIDQuery().selectSummaryView().getName();
        result.setPluginName(pluginName + Plugin.NAME_SEPARATOR);
        return result;
    }

    ComponentTypeRefID getID() {
        return (ComponentTypeRefID)super.getObjectID();
    }

    String getName() {
        if (this.getPluginID() != null) {
            return this.getPluginName() + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    private void setName(String name) {
        int separatorIndex = name.indexOf(Plugin.NAME_SEPARATOR);
        if (separatorIndex != -1) {
            this.setPluginName(name.substring(0, separatorIndex + 1));
            this.setSimpleName(name.substring(separatorIndex + 1));
        } else {
            this.setSimpleName(name);
        }
    }

    String getSimpleName() {
        return this.mSimpleName;
    }

    void setSimpleName(String simpleName) {
        if (simpleName == null) {
            throw new NullPointerException();
        }
        this.mSimpleName = simpleName;
    }

    private void setPluginName(String pluginName) {
        if (!pluginName.endsWith(Plugin.NAME_SEPARATOR)) {
            throw new IllegalArgumentException("missing separator: " + pluginName);
        }
        this.mPluginName = pluginName;
    }

    private String getPluginName() {
        return this.mPluginName;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.mDescription = desc;
    }

    String getOrder() {
        return this.mOrder;
    }

    void setOrder(String order) {
        if (order == null) {
            throw new NullPointerException();
        }
        this.mOrder = order;
    }

    String getGroup() {
        return this.mGroup;
    }

    void setGroup(String inMenuGroup) {
        if (inMenuGroup == null) {
            throw new NullPointerException();
        }
        this.mGroup = inMenuGroup;
    }

    int getIndentLevel() {
        return this.mIndentLevel;
    }

    void setIndentLevel(int indentLevel) {
        this.mIndentLevel = indentLevel;
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    ComponentRef getComponentRef() {
        return this.mComponentRef;
    }

    void setComponentRef(ComponentRef componentRef) {
        if (componentRef == null) {
            throw new NullPointerException();
        }
        this.mComponentRef = componentRef;
    }

    private String getCompName() {
        return this.mCompName;
    }

    private void setCompName(String compName) {
        this.mCompName = compName;
    }

    private FolderID getCompPathID() {
        return this.mCompPathID;
    }

    private void setCompPathID(FolderID compPathID) {
        this.mCompPathID = compPathID;
    }

    private int getCompVersion() {
        return this.mCompVersion;
    }

    private String getCompVersionString() {
        return new VersionNumber(this.getCompVersion()).getAsString();
    }

    private void setCompVersion(int compVersion) {
        this.mCompVersion = compVersion;
    }

    private void setCompVersion(String version) {
        try {
            this.mCompVersion = new VersionNumber(version).getSingleVersionNumber();
        }
        catch (PersistenceManagerException e) {
            this.mCompVersion = 0;
        }
    }

    ComponentTypeRef getCompleteViewMS(boolean createReadOnlyView) throws FolderDBException {
        this.readCompFromDBProps();
        return new ComponentTypeRef(this, createReadOnlyView);
    }

    private void readCompFromDBProps() {
        if (this.mComponentRef == null) {
            this.mComponentRef = new ComponentRef(this.getCompPathID(), this.getCompName(), this.getCompVersionString());
        }
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            ComponentTypeRefImpl result = (ComponentTypeRefImpl)super.getObjectDataClone();
            result.setPluginID(null);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save() throws PersistenceManagerException, RPCException {
        this.validate();
        this.writeCompToDBProps();
        this.saveRPC(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMS(final PersistContext ctx) throws PersistenceManagerException {
        Object object = ComponentType.LOCK;
        synchronized (object) {
            ComponentTypeRefImpl.transactMS(new AcquireWriteLockTransaction(){

                public Object execute() throws PersistenceManagerException {
                    ComponentTypeRefImpl.this.trSaveMS(ctx);
                    return null;
                }

                public ROXMessage getLockDescription() {
                    return new ROXMessage("cdb.SAVING_COMPTYPEREF", ComponentTypeRefImpl.this.getName());
                }
            });
        }
    }

    private void trSaveMS(PersistContext ctx) throws PersistenceManagerException {
        Plugin.checkWritePermissions(this.getCompleteViewMS(true));
        try {
            Component refdComp = this.validateRefMS();
            ComponentTypeRefID id = this.getID();
            boolean isNew = id == null;
            boolean updateCompVarsFlag = false;
            if (!isNew) {
                id.lockForUpdateMS();
                updateCompVarsFlag = this.validateInstallCompatibilityMS(refdComp);
            }
            super.saveMS(ctx);
            if (isNew) {
                this.updateAncestorLinksMS(refdComp);
            } else {
                this.invalidateClientCompsMS();
            }
            if (updateCompVarsFlag) {
                PersistenceManager.getInstance().getApplication().getConfigGenSubsystem().updateInstalledCompVars(this.getName());
            }
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
        catch (UnsupportedSubsystemException use) {
            throw new PersistenceManagerException(use);
        }
        catch (ConfigGenException cge) {
            throw ComponentDBException.unresolvedVarError(this.getName(), cge);
        }
    }

    private Component validateRefMS() throws PersistenceManagerException, RPCException {
        Component comp;
        try {
            comp = SingleComponentQuery.byRef(this.getComponentRef()).select();
        }
        catch (NoResultsFoundException nrFE) {
            throw ComponentDBException.noComponentType(this.getComponentRef());
        }
        if (Modifier.FINAL.equals(comp.getModifier())) {
            throw ComponentDBException.finalCompType(comp);
        }
        return comp;
    }

    private boolean validateInstallCompatibilityMS(Component curComp) throws PersistenceManagerException, RPCException {
        ComponentTypeRef oldRef = this.getID().getByIDQuery().select();
        ComponentRef oldCompRef = oldRef.getComponentRef();
        Component oldComp = SingleComponentQuery.byRef(oldCompRef).select();
        return InstallCompatibilityValidator.validate(oldComp, curComp, this.getName());
    }

    private void invalidateClientCompsMS() throws PersistenceManagerException {
        ComponentSQLOps ct = ComponentSQLOps.DEFAULT;
        ComponentSQLOps.execute(ct.incrUpdateCountWhere(ct.usesType(this.getID())));
    }

    private void updateAncestorLinksMS(Component refdComp) throws PersistenceManagerException {
        ComponentType parentType = refdComp.getExtendsType();
        if (parentType.isRoot()) {
            return;
        }
        ComponentTypeRefID parentID = parentType.getComponentTypeRef().getID();
        ComponentTypeRefID curID = this.getID();
        CompTypeRefToCompTypeRefLinkTable lt = CompTypeRefToCompTypeRefLinkTable.DEFAULT;
        Select newLinks = lt.select(CompTypeRefToCompTypeRefLinkTable.sList(lt.ParentID, (ScalarExp)CompTypeRefToCompTypeRefLinkTable.v(curID)), CompTypeRefToCompTypeRefLinkTable.where(CompTypeRefToCompTypeRefLinkTable.equals(lt.ChildID, parentID)));
        newLinks = CompTypeRefToCompTypeRefLinkTable.anonSelect(CompTypeRefToCompTypeRefLinkTable.sList(CompTypeRefToCompTypeRefLinkTable.v(parentID), (ScalarExp)CompTypeRefToCompTypeRefLinkTable.v(curID)), newLinks);
        lt.addLinks(newLinks);
    }

    private void writeCompToDBProps() {
        ComponentRef compRef = this.getComponentRef();
        this.setCompPathID(compRef.getPath());
        this.setCompName(compRef.getComponentName());
        this.setCompVersion(compRef.getComponentVersion());
    }

    void validate() throws ComponentDBException {
        ComponentTypeRef.validateSimpleName(this.getSimpleName());
        ComponentTypeRef.validateGroup(this.getGroup());
        ComponentTypeRef.validateOrder(this.getOrder());
        ComponentTypeRef.validateDescription(this.getDescription());
        ComponentTypeRef.validateComponentRef(this.getComponentRef());
        ComponentTypeRef.validateIndentLevel(this.getIndentLevel());
    }

    PluginID getPluginID() {
        return this.mPluginID;
    }

    private void setPluginID(PluginID plugin) {
        this.mPluginID = plugin;
    }
}

