/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleObjectByNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToCompTypeRefLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefObserverQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import java.security.AccessControlException;
import java.util.Arrays;

public class ComponentTypeRefID
extends ObjectID {
    private static final HostSetID UNKNOWN_HOST_SET = HostSetID.generateID();
    private static final IDFactory ID_FACTORY = new IDFactory();

    private ComponentTypeRefID() {
    }

    public ComponentTypeRefID(String key) {
        super(key);
    }

    public SingleComponentTypeRefQuery getByIDQuery() {
        return new SingleComponentTypeRefQuery(this);
    }

    public MultiHostSetQuery getPlatformsQuery() throws RPCException, PersistenceManagerException {
        SummaryComponent comp;
        try {
            comp = this.getComponentQuery().selectSummaryView();
        }
        catch (NoResultsFoundException e) {
            return UNKNOWN_HOST_SET.getDescendantsQuery();
        }
        return comp.getCompatiblePlatforms();
    }

    private SingleComponentQuery getComponentQuery() throws RPCException, PersistenceManagerException {
        ComponentTypeRef ref = this.getByIDQuery().select();
        return SingleComponentQuery.byRef(ref.getComponentRef());
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    public static ComponentTypeRefID generateID() {
        return (ComponentTypeRefID)ID_FACTORY.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            ComponentTypeRef ctr = this.getByIDQuery().select();
            try {
                Plugin.checkWritePermissions(ctr);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{ctr.getPluginID().getByIDQuery().selectSummaryView()});
            }
            Link[] links = CompTypeRefToComponentLinkTable.DEFAULT.getByParentID(this);
            ComponentIDSet childSet = new ComponentIDSet();
            Link.addChildIDs(childSet, Arrays.asList(links));
            SummaryComponent[] comps = childSet.getByIDsQuery().selectSummaryView();
            if (comps != null) {
                for (int i = 0; i < comps.length; ++i) {
                    if (inContext.objectWillBeDeletedPriorTo(comps[i].getID(), this)) continue;
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), (UsingObject[])new SummaryComponent[]{comps[i]});
                }
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        ComponentTypeRefIDSet idset = new ComponentTypeRefIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        CompTypeRefToCompTypeRefLinkTable.DEFAULT.removeByChildID(this);
        super.deleteMS(context);
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new ComponentTypeRefID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            ComponentTypeRefImplTable t = ComponentTypeRefImplTable.DEFAULT;
            SingleObjectByNameCache cache = new SingleObjectByNameCache(objectCache, t.Name);
            classMap.addSingleObjectCache(cache);
            ComponentID.registerObserverQuery(ComponentTypeRefObserverQuery.getInstance());
        }
    }
}

