/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefImpl;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.util.Validate;

public class ComponentTypeRef
implements RPCSerializable,
Cloneable,
UsingObject,
HasObjectID,
PluginMember {
    private boolean mImplIsCopy;
    private ComponentTypeRefImpl mImpl;
    private static final int MAX_NAME_LENGTH = 64;
    private boolean mIsReadOnly = false;

    public ComponentTypeRef() {
        this.setImpl(ComponentTypeRefImpl.create());
        this.mImplIsCopy = true;
        this.setIsReadOnly(false);
    }

    public ComponentTypeRef(PluginID plugin) throws PersistenceManagerException, RPCException {
        this.setImpl(ComponentTypeRefImpl.create(plugin));
        this.mImplIsCopy = true;
        this.setIsReadOnly(false);
    }

    ComponentTypeRef(ComponentTypeRefImpl impl, boolean isReadOnly) {
        this.setImpl(impl);
        this.mImplIsCopy = false;
        this.setIsReadOnly(isReadOnly);
    }

    private ComponentTypeRefImpl getImpl() {
        return this.mImpl;
    }

    private void setImpl(ComponentTypeRefImpl impl) {
        this.mImpl = impl;
    }

    private ComponentTypeRefImpl getMutableImpl() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("read only");
        }
        if (!this.mImplIsCopy) {
            this.setImpl((ComponentTypeRefImpl)this.getImpl().clone());
            this.mImplIsCopy = true;
        }
        return this.getImpl();
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public ComponentTypeRefID getID() {
        return this.getImpl().getID();
    }

    public int getUpdateCount() {
        return this.getImpl().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableImpl().setUpdateCount(updateCount);
    }

    public String getName() {
        return this.getImpl().getName();
    }

    public String getSimpleName() {
        return this.getImpl().getSimpleName();
    }

    public void setSimpleName(String name) {
        this.getMutableImpl().setSimpleName(name);
    }

    public String getDescription() {
        return this.getImpl().getDescription();
    }

    public void setDescription(String desc) {
        this.getMutableImpl().setDescription(desc);
    }

    public ComponentRef getComponentRef() {
        return this.getImpl().getComponentRef();
    }

    public void setComponentRef(ComponentRef componentRef) {
        this.getMutableImpl().setComponentRef(componentRef);
    }

    public String getOrder() {
        return this.getImpl().getOrder();
    }

    public void setOrder(String order) {
        this.getMutableImpl().setOrder(order);
    }

    public String getGroup() {
        return this.getImpl().getGroup();
    }

    public void setGroup(String group) {
        this.getMutableImpl().setGroup(group);
    }

    public int getIndentLevel() {
        return this.getImpl().getIndentLevel();
    }

    public void setIndentLevel(int indentLevel) {
        this.getMutableImpl().setIndentLevel(indentLevel);
    }

    public ComponentTypeRef getDataClone() {
        return new ComponentTypeRef((ComponentTypeRefImpl)this.getImpl().getObjectDataClone(), false);
    }

    public Object clone() {
        return this.clone(false);
    }

    private ComponentTypeRef clone(boolean readOnly) {
        if (this.mImplIsCopy) {
            return new ComponentTypeRef((ComponentTypeRefImpl)this.getImpl().clone(), readOnly);
        }
        return new ComponentTypeRef(this.getImpl(), readOnly);
    }

    public void save() throws ComponentDBException, PersistenceManagerException, RPCException {
        this.getMutableImpl().save();
    }

    public void validate() throws ComponentDBException {
        this.getImpl().validate();
    }

    public static void validateSimpleName(String name) throws ComponentDBException {
        if (name == null) {
            throw ComponentDBException.invalidComponentTypeRefName(name);
        }
        int len = name.length();
        if (len == 0 || len > 64) {
            throw ComponentDBException.invalidComponentTypeRefName(name);
        }
        if (!ComponentTypeRef.isValidNameCharacters(name)) {
            throw ComponentDBException.invalidComponentTypeRefName(name);
        }
    }

    public static void validateGroup(String group) throws ComponentDBException {
        if (group == null) {
            throw ComponentDBException.invalidComponentTypeRefGroup(group);
        }
        int len = group.length();
        if (len > 64) {
            throw ComponentDBException.invalidComponentTypeRefGroup(group);
        }
        if (len == 0) {
            return;
        }
        if (!ComponentTypeRef.isValidNameCharacters(group)) {
            throw ComponentDBException.invalidComponentTypeRefGroup(group);
        }
    }

    private static boolean isValidNameCharacters(String name) {
        if (!Validate.isValidFirstCharForName(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (ComponentTypeRef.isValidNameChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNameChar(char ch) {
        String validchars = "-_+. ";
        return Character.isDigit(ch) || Character.isLetter(ch) || validchars.indexOf(ch) != -1;
    }

    public static void validateDescription(String desc) throws ComponentDBException {
        if (!Validate.isValidObjectDescription(desc)) {
            throw ComponentDBException.invalidComponentTypeRefDescription(desc);
        }
    }

    public static void validateOrder(String order) throws ComponentDBException {
        int len = order.length();
        if (len == 0 || len > 64) {
            throw ComponentDBException.invalidComponentTypeRefOrder(order);
        }
        if (!Validate.hasValidDescriptionChars(order)) {
            throw ComponentDBException.invalidComponentTypeRefOrder(order);
        }
    }

    public static void validateComponentRef(ComponentRef ref) throws ComponentDBException {
        if (ref == null) {
            throw ComponentDBException.emptyComponentTypeRefComponentRef();
        }
        if (ref.hasUnresolvedPath()) {
            throw ComponentDBException.invalidComponentTypeRefComponentRef(ref);
        }
        if (!Validate.isValidObjectName(ref.getComponentName(), 512)) {
            throw ComponentDBException.invalidComponentTypeRefComponentRef(ref);
        }
        try {
            new VersionNumber(ref.getComponentVersion());
        }
        catch (PersistenceManagerException e) {
            throw ComponentDBException.invalidComponentTypeRefComponentRef(ref);
        }
    }

    public static void validateIndentLevel(int indentLevel) throws ComponentDBException {
        if (indentLevel < 0 || indentLevel > 10) {
            throw ComponentDBException.invalidComponentTypeRefIndentLevel(indentLevel);
        }
    }

    public boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    private void setIsReadOnly(boolean isReadOnly) {
        this.mIsReadOnly = isReadOnly;
    }

    public ComponentTypeRef toReadOnlyView() {
        if (this.isReadOnly()) {
            return this;
        }
        return this.clone(true);
    }

    public PluginID getPluginID() {
        return this.getImpl().getPluginID();
    }
}

