/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ComponentType
implements RPCSerializable,
Cloneable {
    private static final String ELEMENT_NAME = "type";
    private static final String NAME_ATTR = "name";
    private String mTypeName;
    private ComponentTypeRef mComponentTypeRef;
    private Component mComponent;
    public static final String EXPORTER_CLASS_NAME = "exporterClassName";
    public static final String EXPORTER_CLASS_PATH = "exporterClassPath";
    private boolean mIsReadOnly = false;
    public static final ComponentType ROOT = new RootType();
    static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentType create(String typeName) throws PersistenceManagerException, RPCException {
        if (typeName == null) {
            return ROOT;
        }
        Object object = LOCK;
        synchronized (object) {
            ComponentTypeRef typeRef = ComponentType.getComponentTypeRef(typeName);
            Component comp = ComponentType.getComponent(typeRef);
            return new ComponentType(typeRef, comp, typeName);
        }
    }

    static ComponentType create(Element elem) throws PersistenceManagerException, RPCException {
        Element[] types = XMLUtil.getChildren(elem, ELEMENT_NAME);
        if (types.length > 0) {
            return ComponentType.create(XMLUtil.getAttribute(types[0], NAME_ATTR));
        }
        return null;
    }

    private static ComponentTypeRef getComponentTypeRef(String typeName) throws PersistenceManagerException, RPCException {
        return SingleComponentTypeRefQuery.byName(typeName).selectReadOnlyView();
    }

    private static Component getComponent(ComponentTypeRef typeRef) throws PersistenceManagerException, RPCException {
        ComponentRef cr = typeRef.getComponentRef();
        return SingleComponentQuery.byRef(cr).selectReadOnlyView();
    }

    private ComponentType(ComponentTypeRef typeRef, Component comp, String typeName) {
        this.setComponentTypeRef(typeRef);
        this.setComponent(comp);
        this.setTypeName(typeName);
        this.setIsReadOnly(true);
    }

    private ComponentType() {
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    private void setTypeName(String typeName) {
        this.mTypeName = typeName;
    }

    public ComponentTypeRef getComponentTypeRef() {
        return this.mComponentTypeRef;
    }

    private void setComponentTypeRef(ComponentTypeRef componentTypeRef) {
        this.mComponentTypeRef = componentTypeRef;
    }

    public Component getComponent() {
        return this.mComponent;
    }

    private void setComponent(Component component) {
        this.mComponent = component;
    }

    public String getExporterClassName() {
        VarDecl var = this.getComponent().resolveVar(EXPORTER_CLASS_NAME, null);
        return var == null ? null : var.getDefaultValue();
    }

    public String getExporterClassPath() {
        VarDecl var = this.getComponent().resolveVar(EXPORTER_CLASS_PATH, null);
        return var == null ? null : var.getDefaultValue();
    }

    public Object clone() {
        return this.clone(false);
    }

    private ComponentType clone(boolean readOnly) {
        try {
            ComponentType result = (ComponentType)super.clone();
            Component comp = result.getComponent();
            if (comp != null) {
                comp = readOnly ? comp.toReadOnlyView() : (Component)comp.clone();
            }
            result.setComponent(comp);
            result.setIsReadOnly(readOnly);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    private void setIsReadOnly(boolean isReadOnly) {
        this.mIsReadOnly = isReadOnly;
    }

    public ComponentType toReadOnlyView() {
        if (this.isReadOnly()) {
            return this;
        }
        return this.clone(true);
    }

    public boolean isInstanceOf(ComponentType otherType) {
        return otherType.isRoot() || this.getTypeName().equals(otherType.getTypeName()) || this.getComponent().isInstanceOf(otherType);
    }

    public boolean isInstanceOf(ComponentID compID) {
        return this.getComponent().isInstanceOf(compID);
    }

    public boolean isRoot() {
        return false;
    }

    void writeToXML(XML elem) {
        XML typeElem = new XML(ELEMENT_NAME);
        typeElem.setPrettyPrint(true);
        XMLUtil.addAttributeIfNotNull(typeElem, NAME_ATTR, this.getTypeName());
        elem.addElement((org.apache.ecs.Element)typeElem);
    }

    private static class RootType
    extends ComponentType {
        private RootType() {
            super(null, null, null);
        }

        public boolean isInstanceOf(ComponentType otherType) {
            return otherType.isRoot();
        }

        public boolean isInstanceOf(ComponentID compID) {
            return false;
        }

        public Object clone() {
            return this;
        }

        public boolean isRoot() {
            return true;
        }

        void writeToXML(XML elem) {
        }
    }
}

