/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentCache;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.VariableSettingsSelector;

public class ComponentSelectorManager {
    public ComponentSelector getComponentSelector(ComponentRef compRef) throws PersistenceManagerException, RPCException {
        ComponentCache cc = new ComponentCache();
        cc.load(compRef);
        return cc.newComponentSelector(compRef);
    }

    public ComponentSelector[] getComponentSelector(ComponentRef[] compRefs) throws PersistenceManagerException, RPCException {
        ComponentCache cc = new ComponentCache();
        cc.load(compRefs);
        return cc.newComponentSelectors(compRefs);
    }

    public void refreshVariableSettingsSelectors(ComponentSelector selector) throws PersistenceManagerException, RPCException {
        ComponentCache cc = new ComponentCache();
        cc.load(selector.getComponentRef());
        this.refreshSelectors(selector, cc);
    }

    public void refreshVariableSettingsSelectors(ComponentSelector[] selectors) throws PersistenceManagerException, RPCException {
        int i;
        ComponentCache cc = new ComponentCache();
        ComponentRef[] refs = new ComponentRef[selectors.length];
        for (i = 0; i < selectors.length; ++i) {
            refs[i] = selectors[i].getComponentRef();
        }
        cc.load(refs);
        for (i = 0; i < selectors.length; ++i) {
            this.refreshSelectors(selectors[i], cc);
        }
    }

    private void refreshSelectors(ComponentSelector selector, ComponentCache cc) {
        ComponentVariableSettings settings;
        VariableSettingsSelector currentBuild = selector.getCurrent();
        String priorSettingsName = null;
        if (currentBuild != null && (settings = currentBuild.getCurrent()) != null) {
            priorSettingsName = settings.getName();
        }
        VariableSettingsSelector[] varSelectors = selector.getAll();
        for (int i = 0; i < varSelectors.length; ++i) {
            SummaryComponent comp = varSelectors[i].getComponent();
            varSelectors[i].setAll(cc.getVarSettings(comp));
        }
        if (priorSettingsName != null) {
            int nameNdx = currentBuild.getIndexOfName(priorSettingsName);
            currentBuild.setIndexOfCurrent(nameNdx);
        }
    }
}

