/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.VariableSettingsSelector;
import java.util.Arrays;
import java.util.Hashtable;

public class ComponentSelector
implements RPCSerializable {
    private Hashtable mVersionMap = new Hashtable();
    private ComponentRef mComponentRef;
    private VariableSettingsSelector[] mAll;
    public static final int UNDEFINED = -1;
    private int mCurrent;
    private int mLatest;
    private int mRecommended;
    private int mDefault;

    private ComponentSelector() {
    }

    ComponentSelector(ComponentRef compRef, VariableSettingsSelector[] varSels) {
        this.mComponentRef = compRef;
        this.mAll = varSels;
        for (int i = 0; i < varSels.length; ++i) {
            Integer ndx = new Integer(i);
            VariableSettingsSelector varSel = varSels[i];
            VersionNumber version = varSel.getComponent().getVersionNumber();
            this.mVersionMap.put(version.getAsString(), ndx);
        }
        this.mLatest = varSels.length > 0 ? 0 : -1;
        String version = compRef.getComponentVersion();
        this.mRecommended = version != null ? this.getIndexOfVersion(version) : this.mLatest;
        this.mCurrent = this.mDefault = this.mRecommended != -1 ? this.mRecommended : this.mLatest;
    }

    public ComponentRef getComponentRef() {
        return this.mComponentRef;
    }

    public VariableSettingsSelector[] getAll() {
        return this.mAll;
    }

    public int getIndexOfCurrent() {
        return this.mCurrent;
    }

    public void setIndexOfCurrent(int ndx) {
        if (ndx < 0 || ndx >= this.mAll.length) {
            throw new IndexOutOfBoundsException(String.valueOf(ndx));
        }
        String priorName = null;
        ComponentVariableSettings priorSettings = this.getCurrent().getCurrent();
        if (priorSettings != null) {
            priorName = priorSettings.getName();
        }
        this.mCurrent = ndx;
        VariableSettingsSelector current = this.getCurrent();
        int newIndex = priorName != null ? current.getIndexOfName(priorName) : -1;
        current.setIndexOfCurrent(newIndex);
    }

    public VariableSettingsSelector getCurrent() {
        return this.mCurrent == -1 ? null : this.mAll[this.mCurrent];
    }

    public int getIndexOfLatest() {
        return this.mLatest;
    }

    public int getIndexOfRecommended() {
        return this.mRecommended;
    }

    public int getIndexOfDefault() {
        return this.mDefault;
    }

    public int getIndexOfVersion(String version) {
        Integer ndx = (Integer)this.mVersionMap.get(version);
        if (ndx == null) {
            return -1;
        }
        return ndx;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ComponentSelector)) {
            return false;
        }
        ComponentSelector otherSel = (ComponentSelector)other;
        return this.getComponentRef().equals(otherSel.getComponentRef()) && Arrays.equals(this.getAll(), otherSel.getAll()) && this.getIndexOfCurrent() == otherSel.getIndexOfCurrent() && this.getIndexOfDefault() == otherSel.getIndexOfDefault() && this.getIndexOfLatest() == otherSel.getIndexOfLatest() && this.getIndexOfRecommended() == otherSel.getIndexOfRecommended() && this.mVersionMap.equals(otherSel.mVersionMap);
    }

    public int hashCode() {
        return this.getComponentRef().hashCode();
    }
}

