/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableDependency;
import com.raplix.rolloutexpress.persist.query.builder.ValueWrapper;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToCompTypeRefLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.regex.GlobPattern;

class ComponentSQLOps
extends ComponentImplTable {
    public static final ComponentSQLOps DEFAULT = new ComponentSQLOps();

    public ComponentSQLOps(String alias) {
        super(alias);
    }

    private ComponentSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new ComponentSQLOps(alias);
    }

    public ConditionalExpression matchesVersion(VersionRange range) {
        return range.getConditional(this.Version);
    }

    public ConditionalExpression matchesLabel(GlobPattern label) {
        return ComponentSQLOps.likeLower(this.Label, label);
    }

    public ConditionalExpression matchesCat(CategoryID catID) {
        return ComponentToCategoryLinkTable.DEFAULT.matchesCategoryID(catID, this.ID);
    }

    public ConditionalExpression isFullNameAndVersion(FolderID path, String name, String version) {
        return ComponentSQLOps.and(ComponentSQLOps.and(ComponentSQLOps.equals(this.PathID, path), ComponentSQLOps.equals(this.Name, name)), this.matchesVersion(version));
    }

    public OrderByList orderByFullNameAsc(QueryContext ctx) {
        FolderImplTable fT = new FolderImplTable("fT");
        ctx.addTable(fT);
        ctx.addAndWhereCondition(ComponentSQLOps.equals((ColumnNode)fT.ID, this.PathID));
        OrderByList result = ComponentSQLOps.dictOrderAsc(fT.FullPathString);
        result.add(ComponentSQLOps.dictOrderAsc(this.Name));
        result.add(this.orderByVersionDesc(ctx));
        return result;
    }

    public OrderByList orderByFullNameDesc(QueryContext ctx) {
        FolderImplTable fT = new FolderImplTable("fT");
        ctx.addTable(fT);
        ctx.addAndWhereCondition(ComponentSQLOps.equals((ColumnNode)fT.ID, this.PathID));
        OrderByList result = ComponentSQLOps.dictOrderDesc(fT.FullPathString);
        result.add(ComponentSQLOps.dictOrderDesc(this.Name));
        result.add(this.orderByVersionDesc(ctx));
        return result;
    }

    public OrderByList orderByLabelAsc(QueryContext ctx) {
        return ComponentSQLOps.dictOrderAsc(this.Label);
    }

    public OrderByList orderByLabelDesc(QueryContext ctx) {
        return ComponentSQLOps.dictOrderDesc(this.Label);
    }

    public OrderByList orderByExtendsTypeNameAsc(QueryContext ctx) {
        OrderByList result = ComponentSQLOps.dictOrderAsc(ComponentSQLOps.ifNull(this.ExtendsTypeName, ComponentSQLOps.v("untyped")));
        result.add(this.orderByFullNameAsc(ctx));
        return result;
    }

    public OrderByList orderByExtendsTypeNameDesc(QueryContext ctx) {
        OrderByList result = ComponentSQLOps.dictOrderDesc(ComponentSQLOps.ifNull(this.ExtendsTypeName, ComponentSQLOps.v("untyped")));
        result.add(this.orderByFullNameDesc(ctx));
        return result;
    }

    public ConditionalExpression matchesPlatform(HostSetID hostSet) throws PersistenceManagerException, RPCException {
        HostSetID allPlatforms = SystemPluginConstants.getInstance().ALL_PLATFORMS_ID;
        HostSetIDSet validPlatforms = allPlatforms.getDescendantsContaining(hostSet);
        return this.matchesPlatform(validPlatforms);
    }

    public ConditionalExpression matchesPlatform(HostID host) throws PersistenceManagerException, RPCException {
        HostSetIDSet platforms = SystemPluginConstants.getInstance().ALL_PLATFORMS_ID.getDescendantsContaining(host);
        return this.matchesPlatform(platforms);
    }

    public ConditionalExpression matchesPlatform(HostSetIDSet hostSetIDSet) {
        HostSetImplTable hst = HostSetImplTable.DEFAULT;
        ObjectID[] hostSets = hostSetIDSet.toIDArray();
        Select allPlatforms = hst.select(ComponentSQLOps.sList(hst.Name), ComponentSQLOps.where(ComponentSQLOps.emptyIn(hst.ID, ComponentSQLOps.rList(hostSets))));
        return ComponentSQLOps.in((ColumnNode)this.Platform, allPlatforms);
    }

    public ConditionalExpression matchesRefs(ComponentRef[] refs) {
        return ComponentSQLOps.matchesRefs(refs, this);
    }

    public static ConditionalExpression matchesRefs(ComponentRef[] refs, ComponentImplTable t) {
        if (refs.length == 0) {
            return ComponentSQLOps.none();
        }
        Select pathsAndNames = null;
        for (int i = 0; i < refs.length; ++i) {
            ValueWrapper pathLit = ComponentSQLOps.v(refs[i].getPath());
            ValueWrapper nameLit = ComponentSQLOps.v(refs[i].getComponentName());
            pathsAndNames = ComponentSQLOps.anonSelect(ComponentSQLOps.sList(pathLit, (ScalarExp)nameLit), pathsAndNames);
        }
        return ComponentSQLOps.in(ComponentSQLOps.cList(t.PathID, (ColumnNode)t.Name), pathsAndNames);
    }

    public ConditionalExpression usesType(ComponentTypeRefID typeID) {
        return this.usesAnyOfTypes(ComponentSQLOps.anonSelect(ComponentSQLOps.sList(ComponentSQLOps.v(typeID))));
    }

    public ConditionalExpression usesAnyOfTypes(Select typeIDs) {
        CompTypeRefToComponentLinkTable ctl = CompTypeRefToComponentLinkTable.DEFAULT;
        CompTypeRefToCompTypeRefLinkTable ttl = CompTypeRefToCompTypeRefLinkTable.DEFAULT;
        Select derivedTypes = ttl.selectChildIDs(typeIDs);
        return ComponentSQLOps.or(ComponentSQLOps.in((ColumnNode)this.ID, ctl.selectChildIDs(typeIDs)), ComponentSQLOps.in((ColumnNode)this.ID, ctl.selectChildIDs(derivedTypes)));
    }

    public ConditionalExpression usesAnyOfComps(Select compIDs) {
        ComponentTypeRefSQLOps tt = ComponentTypeRefSQLOps.DEFAULT;
        ComponentSQLOps ict = new ComponentSQLOps("ict");
        Select compTypeIDs = tt.select(ComponentSQLOps.sList(tt.ID), ComponentSQLOps.where(tt.refsComp(ict, ComponentSQLOps.in((ColumnNode)ict.ID, compIDs))));
        return this.usesAnyOfTypes(compTypeIDs);
    }

    TableDependency getTypeUserDependency() {
        return new TableDependency(){

            public void onUpdate(Select compIDsUpdated) throws PersistenceManagerException {
                ConditionalExpression isUserOfUpdatedComps = ComponentSQLOps.this.usesAnyOfComps(compIDsUpdated);
                QueryBuilder.execute(ComponentSQLOps.this.incrUpdateCountWhere(isUserOfUpdatedComps));
            }
        };
    }

    public ConditionalExpression isAccessibleTo(FolderID path) {
        return ComponentSQLOps.or(ComponentSQLOps.equals(this.AccessMode, com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode.PUBLIC), ComponentSQLOps.equals(this.PathID, path));
    }

    public ConditionalExpression hasModifier(Modifier mod) {
        return ComponentSQLOps.equals(this.Modifier, mod);
    }

    public ConditionalExpression extendsType(String typeName) {
        return ComponentSQLOps.equals(this.ExtendsTypeName, typeName);
    }

    public ConditionalExpression isInstanceOfType(String typeName) {
        ComponentTypeRefSQLOps ctr = new ComponentTypeRefSQLOps("ctr");
        return ComponentSQLOps.in((ColumnNode)this.ExtendsTypeName, ctr.selectNamesOfInstancesOfType(typeName));
    }

    public ConditionalExpression isInstanceOfTypeGroup(String typeGroup) {
        ComponentTypeRefSQLOps ctr = new ComponentTypeRefSQLOps("ctr");
        return ComponentSQLOps.in((ColumnNode)this.ExtendsTypeName, ctr.selectNamesOfInstancesOfGroup(typeGroup));
    }

    int markConfigTemplateValidated(ComponentID id) throws PersistenceManagerException {
        return ComponentSQLOps.execute(this.update(ComponentSQLOps.uList(ComponentSQLOps.set(this.ConfigTemplateIsValidated, true)), ComponentSQLOps.where(ComponentSQLOps.equals(this.ID, id))));
    }
}

