/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ComponentRefDecl
extends ComponentMemberBase {
    private InstallMode mInstallMode;
    private ComponentType mLocalType;
    private ArgList mOverrideArgs;
    private SummaryComponent mComponent;
    public static final String ELEMENT_NAME = "componentRef";
    public static final String LIST_ELEMENT_NAME = "componentRefList";
    private static final String INSTALL_MODE_ATTR = "installMode";
    private static final String COMP_ELEM = "component";
    private static final String COMP_ID_ATTR = "id";
    private static final String COMP_PATH_ATTR = "path";
    private static final String COMP_NAME_ATTR = "name";
    private static final String COMP_VERSION_ATTR = "version";
    private static final InstallMode DEFAULT_INSTALL_MODE = InstallMode.NESTED;

    private ComponentRefDecl() {
    }

    public ComponentRefDecl(Modifier modifier, String name, InstallMode installMode, ComponentType type, VariableSettingsSource argList, SummaryComponent comp) {
        super(null, modifier, name);
        this.setInstallMode(installMode);
        this.setLocalType(type);
        this.setOverrideArgs(argList);
        this.setComponent(comp);
    }

    public ComponentRefDecl(Element element, FolderID declarerPath, boolean isInternal) throws PersistenceManagerException, RPCException {
        super(element, DEFAULT_ACCESS);
        this.setInstallMode((InstallMode)XMLUtil.getEnumAttribute(element, INSTALL_MODE_ATTR, InstallMode.FACTORY));
        this.setLocalType(ComponentType.create(element));
        this.setOverrideArgs(new ArgList(element));
        this.setComponent(this.parseComponent(element, declarerPath, isInternal));
    }

    private SummaryComponent parseComponent(Element element, FolderID declarerPath, boolean isInternal) throws PersistenceManagerException, RPCException {
        Element[] comps = XMLUtil.getChildren(element, COMP_ELEM);
        if (comps.length == 0) {
            return null;
        }
        if (isInternal) {
            String idStr = XMLUtil.getAttribute(comps[0], COMP_ID_ATTR);
            return new ComponentID(idStr).getByIDQuery().selectSummaryView();
        }
        String path = XMLUtil.getAttribute(comps[0], COMP_PATH_ATTR);
        String name = XMLUtil.getAttribute(comps[0], COMP_NAME_ATTR);
        String version = XMLUtil.getAttribute(comps[0], COMP_VERSION_ATTR);
        ComponentRef compRef = new ComponentRef(path, name, version);
        compRef = compRef.resolvePath(declarerPath);
        return SingleComponentQuery.byRef(compRef).selectSummaryView();
    }

    public ComponentRefDecl getOverriddenCompRef() {
        return (ComponentRefDecl)this.getOverriddenMember();
    }

    public InstallMode getInstallMode() {
        return this.mInstallMode;
    }

    private void setInstallMode(InstallMode installMode) {
        if (installMode == null) {
            installMode = DEFAULT_INSTALL_MODE;
        }
        this.mInstallMode = installMode;
    }

    public ComponentType getLocalType() {
        return this.mLocalType;
    }

    private void setLocalType(ComponentType type) {
        if (type != null) {
            type = type.toReadOnlyView();
        }
        this.mLocalType = type;
    }

    public ComponentType getType() {
        return this.getType(this.getDeclaringComponent());
    }

    private ComponentType getType(Component declarer) {
        ComponentType type = this.getLocalType();
        if (type == null) {
            type = declarer.getCompRefListType();
        }
        return type;
    }

    public VariableSettingsSource getOverrideArgs() {
        return (VariableSettingsSource)this.mOverrideArgs.clone();
    }

    private void setOverrideArgs(ArgList args) {
        this.mOverrideArgs = args;
    }

    private void setOverrideArgs(VariableSettingsSource args) {
        if (args == null) {
            this.setOverrideArgs(new ArgList());
        } else {
            this.setOverrideArgs(new ArgList(args));
        }
    }

    public SummaryComponent getComponent() {
        return this.mComponent;
    }

    void setComponent(SummaryComponent comp) {
        if (comp != null && comp instanceof Component) {
            comp = ((Component)comp).toReadOnlyView();
        }
        this.mComponent = comp;
    }

    public VariableSettingsSource resolveOverrideArgs(ComponentConfigManager configMgr) throws ConfigGenException {
        VariableSettingsHolder result = new VariableSettingsHolder();
        this.resolveOverrideArgs(configMgr, result, false);
        return result;
    }

    void resolveOverrideArgs(ComponentConfigManager configMgr, VariableSettingsHolder holder, boolean limitToTypeVisibleArgs) throws ConfigGenException {
        ComponentRefDecl overridden = this.getOverriddenCompRef();
        if (overridden != null) {
            overridden.resolveOverrideArgs(configMgr, holder, true);
        }
        ArgList localArgs = this.mOverrideArgs;
        if (limitToTypeVisibleArgs) {
            localArgs = this.filterArgsByType(localArgs);
        }
        if (configMgr != null) {
            Caller caller = new Caller(null, this.getDeclaringComponent());
            ConfigGenerator generator = configMgr.newCallerScope(caller);
            localArgs = localArgs.generate(generator);
        }
        String[] names = localArgs.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            holder.setVarValue(names[i], localArgs.getVarValue(names[i]));
        }
    }

    private ArgList filterArgsByType(ArgList orig) {
        if (Modifier.ABSTRACT.equals(this.getModifier())) {
            return orig;
        }
        Component typeComp = this.getType().getComponent();
        ArgList result = new ArgList();
        if (typeComp == null) {
            return result;
        }
        String[] names = orig.getVarNames();
        CallSpec caller = new CallSpec(new Caller(null, this.getDeclaringComponent()), null);
        for (int i = 0; i < names.length; ++i) {
            VarDecl var = typeComp.resolveVar(names[i], caller);
            if (var == null || var.getAccessMode().isMoreRestrictiveThan(AccessMode.PROTECTED)) continue;
            result.setVarValue(names[i], orig.getVarValue(names[i]));
        }
        return result;
    }

    protected void populateXML(XML compRef, boolean isInternal) {
        ComponentType type;
        if (!DEFAULT_INSTALL_MODE.equals(this.getInstallMode())) {
            XMLUtil.addAttributeIfNotNull(compRef, INSTALL_MODE_ATTR, this.getInstallMode().toString());
        }
        if ((type = this.getLocalType()) != null) {
            type.writeToXML(compRef);
        }
        this.mOverrideArgs.writeToXML(compRef);
        SummaryComponent component = this.getComponent();
        if (component != null) {
            XML comp = new XML(COMP_ELEM);
            comp.setPrettyPrint(true);
            if (isInternal) {
                XMLUtil.addAttributeIfNotNull(comp, COMP_ID_ATTR, component.getID().toString());
            } else {
                String path = component.getPath().getFullPathString();
                if (!component.getPath().equals(FolderID.ROOT_FOLDER_ID)) {
                    path = path.substring(0, path.length() - 1);
                }
                XMLUtil.addAttributeIfNotNull(comp, COMP_PATH_ATTR, path);
                XMLUtil.addAttributeIfNotNull(comp, COMP_NAME_ATTR, component.getName());
                XMLUtil.addAttributeIfNotNull(comp, COMP_VERSION_ATTR, component.getVersionNumber().getAsString());
            }
            compRef.addElement((org.apache.ecs.Element)comp);
        }
    }

    protected void validate(Component declarer) throws ComponentDBException, PlanDBException {
        super.validate(declarer);
        Component base = declarer.getBaseComponent();
        ComponentRefDecl overridden = (ComponentRefDecl)this.getOverriddenMember(declarer);
        if (base != null && Modifier.FINAL.equals(base.getCompRefListModifier()) && overridden == null) {
            throw ComponentDBException.newLocalCompRefInFinalList(this);
        }
        ComponentType localType = this.getLocalType();
        if (localType == null) {
            localType = ComponentType.ROOT;
        } else if (!localType.isRoot()) {
            CallSpec caller = new CallSpec(new Caller(null, declarer), null);
            if (!localType.getComponent().isAccessible(caller)) {
                throw ComponentDBException.inaccessibleCompRefType(this);
            }
        }
        if (overridden != null) {
            if (!overridden.getInstallMode().equals(this.getInstallMode())) {
                throw ComponentDBException.invalidCompRefInstallModeOverride(this);
            }
            ComponentType baseType = overridden.getLocalType();
            if (baseType == null) {
                baseType = ComponentType.ROOT;
            }
            if (!localType.isInstanceOf(baseType)) {
                throw ComponentDBException.invalidCompRefTypeOverride(this);
            }
        }
        if (!this.getType(declarer).isInstanceOf(declarer.getCompRefListType())) {
            throw ComponentDBException.invalidCompRefListTypeOverride(this);
        }
        SummaryComponent refdComp = this.getComponent();
        if (Modifier.ABSTRACT.equals(this.getModifier())) {
            if (refdComp != null) {
                throw ComponentDBException.nonEmptyAbstractCompRef(this);
            }
        } else {
            if (refdComp == null) {
                throw ComponentDBException.emptyNonAbstractCompRef(this);
            }
            if (InstallMode.TOPLEVEL.equals(this.getInstallMode()) && !AccessMode.PUBLIC.equals(refdComp.getAccessMode())) {
                throw ComponentDBException.nonPublicToplevelCompRef(this);
            }
            if (Modifier.ABSTRACT.equals(refdComp.getModifier())) {
                throw ComponentDBException.abstractCompRef(this);
            }
        }
    }

    protected void validateMS(Component declarer) throws PersistenceManagerException, RPCException {
        Component refdComp;
        if (Modifier.ABSTRACT.equals(this.getModifier())) {
            refdComp = this.getType(declarer).getComponent();
        } else {
            CallSpec caller;
            refdComp = this.getComponent().getID().getByIDQuery().select();
            if (!refdComp.isAccessible(caller = new CallSpec(new Caller(null, declarer), null))) {
                throw ComponentDBException.inaccessibleCompRef(this);
            }
            ComponentType type = this.getType(declarer);
            if (!refdComp.isInstanceOf(type)) {
                throw ComponentDBException.incompatibleReferencedCompType(this);
            }
            ComponentRefDecl.validateNoCircularRefsMS(declarer, this, refdComp);
            if (InstallMode.NESTED.equals(this.getInstallMode()) && refdComp.getTargetRef() != null) {
                throw ComponentDBException.nestedTargetableRef(this, declarer.getName(), refdComp.getFullName());
            }
        }
        this.validateOverrideArgsMS(declarer, refdComp);
    }

    private static void validateNoCircularRefsMS(Component declarer, ComponentRefDecl origRef, Component curRef) throws PersistenceManagerException, RPCException {
        if (declarer.getName().equals(curRef.getName()) && declarer.getPath().equals(curRef.getPath())) {
            throw ComponentDBException.circularCompRef(origRef);
        }
        if (!curRef.isSimpleComponent()) {
            ComponentRefDecl[] refs = curRef.getCompRefList(null);
            for (int i = 0; i < refs.length; ++i) {
                curRef = refs[i].getComponent().getID().getByIDQuery().select();
                ComponentRefDecl.validateNoCircularRefsMS(declarer, origRef, curRef);
            }
        }
    }

    private void validateOverrideArgsMS(Component declarer, Component refdComp) throws ComponentDBException {
        String[] argNames = this.mOverrideArgs.getVarNames();
        if (argNames.length > 0 && refdComp == null) {
            throw ComponentDBException.untypedCompRefOverrideArgs(this);
        }
        CallSpec caller = new CallSpec(new Caller(null, declarer), null);
        for (int i = 0; i < argNames.length; ++i) {
            String argName = argNames[i];
            VarDecl refdVar = refdComp.resolveVar(argName, caller);
            if (refdVar == null) {
                throw ComponentDBException.unknownCompRefOverrideArg(argName, this);
            }
            if (Modifier.FINAL.equals(refdVar.getModifier())) {
                throw ComponentDBException.finalCompRefOverrideArg(argName, this);
            }
            if (!refdVar.getAccessMode().isMoreRestrictiveThan(AccessMode.PROTECTED)) continue;
            throw ComponentDBException.inaccessibleCompRefOverrideArg(argName, this);
        }
    }

    void validateDerivedCompListTypeMS(ComponentType listType) throws PersistenceManagerException, RPCException {
        Component comp;
        if (!Modifier.ABSTRACT.equals(this.getModifier()) && !(comp = this.getComponent().getID().getByIDQuery().select()).isInstanceOf(listType)) {
            throw ComponentDBException.baseCompRefIncompatibleReferencedComp(this);
        }
        ComponentType localType = this.getLocalType();
        if (localType != null && !listType.isInstanceOf(localType) && !localType.isInstanceOf(listType)) {
            throw ComponentDBException.baseCompRefIncompatibleDeclaredType(this);
        }
    }

    void accept(CompDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.mOverrideArgs);
    }

    ComponentMemberBase accept(CompDBTransformer t) throws Exception {
        ComponentRefDecl crd = (ComponentRefDecl)super.accept(t);
        crd.mOverrideArgs = (ArgList)t.transform(this.mOverrideArgs);
        return crd;
    }

    void validateNamespace(CompDBPluginNSValidator v) throws Exception {
        super.validateNamespace(v);
        Plugin p = v.getPlugin();
        SummaryComponent c = this.getComponent();
        if (c != null) {
            p.validateNamespace(c.getPluginID(), c.getFullName(), ELEMENT_NAME);
        }
        v.visit(this.getLocalType());
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected String getListElementName() {
        return LIST_ELEMENT_NAME;
    }
}

