/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;

public class ComponentRef
implements RPCSerializable,
Cloneable {
    private String mComponentName;
    private String mUnresolvedPath = null;
    private FolderID mPath = null;
    private String mComponentVersion;

    protected ComponentRef() {
    }

    public ComponentRef(String componentName) {
        this(componentName, null);
    }

    public ComponentRef(String componentName, String componentVersion) {
        this(FolderID.ROOT_FOLDER_ID, componentName, componentVersion);
    }

    public ComponentRef(String path, String componentName, String componentVersion) {
        this.setUnresolvedPath(path);
        this.setComponentName(componentName);
        this.setComponentVersion(componentVersion);
    }

    public ComponentRef(FolderID path, String componentName, String componentVersion) {
        this.setPath(path);
        this.setComponentName(componentName);
        this.setComponentVersion(componentVersion);
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    private void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public String getUnresolvedPath() {
        return this.mUnresolvedPath;
    }

    private void setUnresolvedPath(String path) {
        if ("".equals(path)) {
            path = null;
        }
        this.mUnresolvedPath = path;
        this.mPath = null;
    }

    public FolderID getPath() {
        if (this.mPath == null) {
            String thePathInfo = this.getComponentFullName();
            throw new NullPointerException("unresolved path: " + thePathInfo);
        }
        return this.mPath;
    }

    private void setPath(FolderID path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.mPath = path;
        this.mUnresolvedPath = null;
    }

    public boolean hasUnresolvedPath() {
        return this.mPath == null;
    }

    public ComponentRef resolvePath(FolderID path) throws PersistenceManagerException, RPCException {
        if (this.hasUnresolvedPath()) {
            ComponentRef result = (ComponentRef)this.clone();
            path = path.getByResolvedPathQuery(result.getUnresolvedPath()).selectSummaryView().getID();
            result.setPath(path);
            return result;
        }
        return this;
    }

    public String getResolvedPathString(FolderID path) throws FolderDBException {
        if (this.hasUnresolvedPath()) {
            return path.getResolvedPath(this.getUnresolvedPath());
        }
        try {
            String crPath = this.getPath().getByIDQuery().selectSummaryView().getFullPathString();
            return crPath;
        }
        catch (RPCException e) {
            throw new FolderDBException(e);
        }
        catch (PersistenceManagerException e) {
            throw new FolderDBException(e);
        }
    }

    public String getComponentVersion() {
        return this.mComponentVersion;
    }

    private void setComponentVersion(String componentVersion) {
        if ("".equals(componentVersion)) {
            componentVersion = null;
        }
        this.mComponentVersion = componentVersion;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ComponentRef)) {
            return false;
        }
        ComponentRef otherComp = (ComponentRef)other;
        if (!this.equals(otherComp.getUnresolvedPath(), this.getUnresolvedPath())) {
            return false;
        }
        if (!this.equals(otherComp.mPath, this.mPath)) {
            return false;
        }
        if (!otherComp.getComponentName().equals(this.getComponentName())) {
            return false;
        }
        return this.equals(otherComp.getComponentVersion(), this.getComponentVersion());
    }

    protected boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public int hashCode() {
        String version = this.getComponentVersion();
        return this.getPathString().hashCode() + this.getComponentName().hashCode() + (version == null ? 0 : version.hashCode());
    }

    public String toString() {
        String theNameString = this.getComponentFullName();
        return "component{name=" + theNameString + ",version=" + this.getComponentVersion() + "}";
    }

    public String getPathString() {
        if (this.hasUnresolvedPath()) {
            return this.getUnresolvedPath();
        }
        String result = this.getPath().getFullPathString();
        if (!FolderID.ROOT_FOLDER_ID.equals(this.getPath())) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String getComponentFullName() {
        String result = this.getPathString();
        if (result == null) {
            result = "";
        } else if (!result.endsWith("/")) {
            result = result + "/";
        }
        result = result + this.getComponentName();
        return result;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void addComponentRefsMS(ComponentNameRefAdder adder) throws Exception {
        this.accept(adder);
        String path = this.getResolvedPathString(adder.getCaller().getDeclaredPath());
        adder.getNameRefSet().addNameRef(this.getComponentName(), path);
    }

    public ComponentRef updateComponentRefsMS(ComponentNameRefUpdater t) throws Exception {
        ComponentRef cr = this.accept(t);
        String icrPath = this.getResolvedPathString(t.getCaller().getDeclaredPath());
        if (!this.isRefTo(t.getComponent(), icrPath)) {
            if (t.getNewPath() != null && this.isRelativeRef() && ComponentRef.sameComponent(t.getComponent(), t.getCaller())) {
                cr.setUnresolvedPath(t.getNewPath().findRelativePath(icrPath));
            }
            return cr;
        }
        if (t.getNewName() != null) {
            cr.setComponentName(t.getNewName());
        }
        if (t.getNewPath() == null) {
            return cr;
        }
        if (!this.isRelativeRef()) {
            if (!this.hasUnresolvedPath()) {
                cr.setPath(t.getNewPath().getID());
            } else {
                cr.setUnresolvedPath(t.getNewPath().getFullPathString());
            }
            return cr;
        }
        if (ComponentRef.sameComponent(t.getComponent(), t.getCaller())) {
            cr.setUnresolvedPath("");
        } else {
            cr.setUnresolvedPath(t.getCaller().getDeclaredPath().findRelativePath(t.getNewPath().getFullPathString()));
        }
        return cr;
    }

    private boolean isRelativeRef() {
        return this.getPathString() == null || !this.getPathString().startsWith("/");
    }

    private boolean isRefTo(SummaryComponent sc, String resolvedPath) {
        return sc.getName().equals(this.getComponentName()) && sc.getPath().getFullPathString().equals(resolvedPath);
    }

    private static boolean sameComponent(SummaryComponent sc, Caller caller) {
        if (caller.getDeclaredComponent() == null || sc == null) {
            return false;
        }
        return sc.getName().equals(caller.getDeclaredComponent().getName()) && sc.getPath().equals(caller.getDeclaredComponent().getPath());
    }

    void accept(CompDBVisitor v) throws Exception {
    }

    ComponentRef accept(CompDBTransformer t) throws Exception {
        return t.clone(this);
    }

    ComponentRef cloneForTransform() {
        return (ComponentRef)this.clone();
    }

    void validateNamespace(CompDBPluginNSValidator v) throws Exception {
        block5: {
            this.accept(v);
            SummaryFolder f = v.getCaller().getDeclaredPath().getByResolvedPathQuery(this.getPathString()).selectSummaryView();
            try {
                SummaryComponent c = SingleComponentQuery.byName(f.getID(), this.getComponentName(), this.getComponentVersion()).selectSummaryView();
                v.getPlugin().validateNamespace(c.getPluginID(), c.getFullName(), "component");
            }
            catch (NoResultsFoundException e) {
                VersionNumber rver;
                if (v.getContext() == null) {
                    throw e;
                }
                Component c = v.getCaller().getActualComponent();
                if (!c.getName().equals(this.getComponentName()) || !c.getPath().equals(f.getID())) {
                    throw e;
                }
                if (this.getComponentVersion() == null) {
                    return;
                }
                VersionNumber sver = v.getContext().getVersionToSaveAs();
                if (sver.equals(rver = new VersionNumber(this.getComponentVersion()))) break block5;
                throw e;
            }
        }
    }
}

