/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiCompObserverQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import java.util.ArrayList;

class ComponentObserverQuery
implements MultiCompObserverQuery {
    private static ComponentObserverQuery sInstance = null;

    private ComponentObserverQuery() {
    }

    public static ComponentObserverQuery getInstance() {
        if (sInstance == null) {
            sInstance = new ComponentObserverQuery();
        }
        return sInstance;
    }

    public ComponentObserver[] selectCompObservers(String name, SummaryFolder path) throws PersistenceManagerException {
        try {
            String pathStr = path.getFullPathString();
            NameRef[] nrs = ComponentToComponentNameRefTable.DEFAULT.getByChildNameAndPath(name, pathStr);
            ComponentIDSet id = new ComponentIDSet();
            NameRef.parentIDSet(nrs, id);
            Component[] comps = id.getByIDsQuery().select();
            ArrayList<ComponentImpl> al = new ArrayList<ComponentImpl>();
            for (int i = 0; i < comps.length; ++i) {
                al.add(comps[i].getComponent());
            }
            return al.toArray(new ComponentImpl[0]);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    public void updateCompRefTable(String oldName, FolderID oldPath, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ComponentToComponentNameRefTable.DEFAULT.updateNameRefs(oldName, oldPath, newName, newPath);
    }
}

