/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessResolver;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMember;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.util.reflect.ClassUtil;
import com.raplix.util.reflect.ConstructorUtil;
import com.raplix.util.reflect.FieldUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

class ComponentMemberList
implements Cloneable,
RPCSerializable {
    private Vector mMemberList = new Vector();
    private Hashtable mMemberMap = new Hashtable();
    private String mListElementName;
    private String mMemberClassName;
    private transient Class mMemberClass;
    private String mMemberElementName;
    private transient Constructor mMemberConstructor;

    private ComponentMemberList() {
    }

    public ComponentMemberList(Class memberClass) {
        this.setMemberClass(memberClass);
    }

    String getListElementName() {
        return this.mListElementName;
    }

    private void setListElementName(String listElementName) {
        this.mListElementName = listElementName;
    }

    private Class getMemberClass() {
        if (this.mMemberClass == null) {
            this.mMemberClass = ClassUtil.findClass(this.mMemberClassName);
        }
        return this.mMemberClass;
    }

    private void setMemberClass(Class memberClass) {
        this.mMemberClassName = memberClass.getName();
        this.mMemberClass = memberClass;
        Field f = FieldUtil.findField(memberClass, "LIST_ELEMENT_NAME");
        this.setListElementName((String)FieldUtil.getStatic(f));
        f = FieldUtil.findField(memberClass, "ELEMENT_NAME");
        this.setMemberElementName((String)FieldUtil.getStatic(f));
    }

    private String getMemberElementName() {
        return this.mMemberElementName;
    }

    private void setMemberElementName(String memberElementName) {
        this.mMemberElementName = memberElementName;
    }

    private Constructor getMemberConstructor() {
        if (this.mMemberConstructor == null) {
            this.mMemberConstructor = ConstructorUtil.find(this.getMemberClass(), new Class[]{Element.class, FolderID.class, Boolean.TYPE});
        }
        return this.mMemberConstructor;
    }

    private ComponentMemberBase constructMember(Element elem, FolderID path, boolean isInternal) throws PersistenceManagerException, RPCException {
        try {
            return (ComponentMemberBase)ConstructorUtil.create(this.getMemberConstructor(), new Object[]{elem, path, new Boolean(isInternal)});
        }
        catch (PersistenceManagerException e) {
            throw e;
        }
        catch (RPCException e) {
            throw e;
        }
        catch (Exception e) {
            throw ComponentImpl.newParseError(e);
        }
    }

    public boolean add(ComponentMemberBase member) {
        if (!this.getMemberClass().isInstance(member)) {
            throw new ClassCastException(member.getClass().getName());
        }
        member = (ComponentMemberBase)member.clone();
        return this.addLocal(member);
    }

    private boolean addLocal(ComponentMemberBase member) {
        ComponentMember oldMember = this.mMemberMap.put(member.getName(), member);
        if (oldMember != null) {
            ListIterator<ComponentMemberBase> iter = this.mMemberList.listIterator();
            while (iter.hasNext()) {
                ComponentMember curMember = (ComponentMember)iter.next();
                if (!curMember.getName().equals(oldMember.getName())) continue;
                iter.set(member);
                break;
            }
            return false;
        }
        this.mMemberList.add(member);
        return true;
    }

    public void remove(String memberName) {
        ComponentMember oldMember = (ComponentMember)this.mMemberMap.remove(memberName);
        if (oldMember != null) {
            ListIterator iter = this.mMemberList.listIterator();
            while (iter.hasNext()) {
                ComponentMember curMember = (ComponentMember)iter.next();
                if (!curMember.getName().equals(oldMember.getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    public void resetFromXML(Element listContainerElement, FolderID path, boolean isInternal) throws PersistenceManagerException, RPCException {
        this.clear();
        Element[] lists = XMLUtil.getChildren(listContainerElement, this.getListElementName());
        if (lists.length > 0) {
            Element[] memberElems = XMLUtil.getChildren(lists[0], this.getMemberElementName());
            for (int i = 0; i < memberElems.length; ++i) {
                ComponentMemberBase member = this.constructMember(memberElems[i], path, isInternal);
                this.addLocal(member);
            }
        }
    }

    public void resetFromArray(ComponentMemberBase[] newMembers) {
        this.clear();
        if (newMembers != null) {
            for (int i = 0; i < newMembers.length; ++i) {
                this.add(newMembers[i]);
            }
        }
    }

    void resetFromArrayLocal(ComponentMemberBase[] newMembers) {
        this.clear();
        if (newMembers != null) {
            for (int i = 0; i < newMembers.length; ++i) {
                this.addLocal(newMembers[i]);
            }
        }
    }

    public boolean contains(String memberName) {
        return this.mMemberMap.containsKey(memberName);
    }

    ComponentMemberBase getLocal(String memberName) {
        return (ComponentMemberBase)this.mMemberMap.get(memberName);
    }

    public ComponentMemberBase get(Component declarer, String memberName, CallSpec caller) {
        AccessResolver accessResolver = new AccessResolver(declarer, caller);
        if (!accessResolver.currentComponentIsAccessible()) {
            return null;
        }
        while (accessResolver != null) {
            AccessMode accessMode;
            Component current = accessResolver.getCurrentComponent();
            ComponentMemberList memberList = this.getMemberListOf(current);
            ComponentMemberBase member = memberList.getLocal(memberName);
            if (member != null && (declarer = accessResolver.getAccessibleDeclarer(accessMode = member.getAccessMode())) != null) {
                return this.resolveMember(declarer, memberName);
            }
            accessResolver = accessResolver.getBaseComponentAccessResolver();
        }
        return null;
    }

    private ComponentMemberBase externalize(Component declarer, ComponentMemberBase member) {
        ComponentMemberBase result = (ComponentMemberBase)member.clone();
        result.setDeclaringComponent(declarer);
        return result;
    }

    Iterator iterator() {
        return this.mMemberList.iterator();
    }

    public int size() {
        return this.mMemberList.size();
    }

    public void writeToXML(XML outXML, boolean isInternal) {
        if (this.size() == 0) {
            return;
        }
        XML list = new XML(this.getListElementName());
        list.setPrettyPrint(true);
        this.writeMembersToXML(list, isInternal);
        outXML.addElement((org.apache.ecs.Element)list);
    }

    public void writeMembersToXML(XML list, boolean isInternal) {
        Iterator members = this.iterator();
        while (members.hasNext()) {
            ComponentMemberBase member = (ComponentMemberBase)members.next();
            member.writeToXML(list, isInternal);
        }
    }

    public ComponentMemberBase[] toArray(Component declarer, CallSpec caller) {
        AccessResolver accessResolver = new AccessResolver(declarer, caller);
        ComponentMemberList result = new ComponentMemberList();
        result.setMemberClass(this.getMemberClass());
        if (accessResolver.currentComponentIsAccessible()) {
            this.addAccessibleMembers(result, accessResolver);
        }
        return result.toArray();
    }

    private void addAccessibleMembers(ComponentMemberList result, AccessResolver accessResolver) {
        AccessResolver baseResolver = accessResolver.getBaseComponentAccessResolver();
        if (baseResolver != null) {
            this.addAccessibleMembers(result, baseResolver);
        }
        Component current = accessResolver.getCurrentComponent();
        ComponentMemberList declaredMemberList = this.getMemberListOf(current);
        Iterator locals = declaredMemberList.iterator();
        while (locals.hasNext()) {
            AccessMode accessMode;
            Component declarer;
            ComponentMember member = (ComponentMember)locals.next();
            if (result.contains(member.getName()) || (declarer = accessResolver.getAccessibleDeclarer(accessMode = member.getAccessMode())) == null) continue;
            result.addLocal(this.resolveMember(declarer, member.getName()));
        }
    }

    private ComponentMemberList getMemberListOf(Component declarer) {
        return declarer.getMemberList(this.getListElementName());
    }

    private ComponentMemberBase resolveMember(Component declarer, String memberName) {
        while (declarer != null) {
            ComponentMemberList list = this.getMemberListOf(declarer);
            ComponentMemberBase member = list.getLocal(memberName);
            if (member != null) {
                return this.externalize(declarer, member);
            }
            declarer = declarer.getBaseComponent();
        }
        return null;
    }

    public void clear() {
        this.mMemberMap.clear();
        this.mMemberList.clear();
    }

    private ComponentMemberBase[] getMemberArray() {
        return (ComponentMemberBase[])Array.newInstance(this.getMemberClass(), this.size());
    }

    ComponentMemberBase[] toArray() {
        return this.mMemberList.toArray(this.getMemberArray());
    }

    public ComponentMemberBase[] toArray(Component declarer) {
        ComponentMemberBase[] result = this.toArray();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.externalize(declarer, result[i]);
        }
        return result;
    }

    public Object clone() {
        try {
            ComponentMemberList result = (ComponentMemberList)super.clone();
            result.mMemberList = (Vector)result.mMemberList.clone();
            result.mMemberMap = (Hashtable)result.mMemberMap.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void validatePreparse() throws SystemModelParseException, ComponentDBException {
        Iterator members = this.iterator();
        while (members.hasNext()) {
            ComponentMemberBase member = (ComponentMemberBase)members.next();
            member.validatePreparse();
        }
    }

    void validate(Component declarer) throws ComponentDBException, PlanDBException {
        Iterator members = this.iterator();
        while (members.hasNext()) {
            ComponentMemberBase member = (ComponentMemberBase)members.next();
            member.validate(declarer);
        }
        this.validateAbstractMembers(declarer);
    }

    private void validateAbstractMembers(Component declarer) throws ComponentDBException {
        if (Modifier.ABSTRACT.equals(declarer.getModifier())) {
            return;
        }
        Component base = declarer.getBaseComponent();
        if (base == null || !Modifier.ABSTRACT.equals(base.getModifier())) {
            return;
        }
        ComponentMemberList baseList = this.getMemberListOf(base);
        ComponentMemberBase[] baseMembers = baseList.toArray(base, null);
        for (int i = 0; i < baseMembers.length; ++i) {
            ComponentMemberBase local;
            ComponentMemberBase baseMember = baseMembers[i];
            if (!Modifier.ABSTRACT.equals(baseMember.getModifier()) || (local = this.getLocal(baseMember.getName())) != null && local.getOverriddenMember(declarer) != null) continue;
            throw ComponentDBException.abstractNotOverridden(baseMember);
        }
    }

    void accept(CompDBVisitor v) throws Exception {
        ComponentMemberBase[] arr = this.toArray();
        for (int i = 0; i < arr.length; ++i) {
            v.visit(arr[i]);
        }
    }

    ComponentMemberList accept(CompDBTransformer t) throws Exception {
        ComponentMemberList result = t.clone(this);
        ComponentMemberBase[] arr = result.toArray();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = t.transform(arr[i]);
        }
        result.resetFromArrayLocal(arr);
        return result;
    }

    ComponentMemberList cloneForTransform() {
        return (ComponentMemberList)this.clone();
    }
}

