/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMember;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberList;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.util.message.MessageManager;
import org.apache.ecs.xml.XML;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.w3c.dom.Element;

abstract class ComponentMemberBase
implements RPCSerializable,
ComponentMember,
Cloneable {
    private transient Component mDeclaringComponent;
    static final Modifier DEFAULT_MODIFIER = Modifier.NONE;
    private Modifier mModifier = DEFAULT_MODIFIER;
    static final AccessMode DEFAULT_ACCESS = AccessMode.PUBLIC;
    private AccessMode mAccessMode = DEFAULT_ACCESS;
    private String mName;
    private static final String NAME_ATTR = "name";
    private static final String MODIFIER_ATTR = "modifier";
    private static final String ACCESS_ATTR = "access";

    ComponentMemberBase() {
    }

    public ComponentMemberBase(AccessMode accessMode, Modifier modifier, String name) {
        this.setName(name);
        this.setModifier(modifier);
        this.setAccessMode(accessMode);
    }

    public ComponentMemberBase(Element element, AccessMode accessMode) {
        this.setName(XMLUtil.getAttribute(element, NAME_ATTR));
        Modifier modifier = (Modifier)XMLUtil.getEnumAttribute(element, MODIFIER_ATTR, Modifier.FACTORY);
        this.setModifier(modifier);
        if (accessMode == null) {
            accessMode = (AccessMode)XMLUtil.getEnumAttribute(element, ACCESS_ATTR, AccessMode.FACTORY);
        }
        this.setAccessMode(accessMode);
    }

    public Component getDeclaringComponent() {
        return this.mDeclaringComponent;
    }

    void setDeclaringComponent(Component comp) {
        this.mDeclaringComponent = comp;
    }

    public Modifier getModifier() {
        return this.mModifier;
    }

    private void setModifier(Modifier mod) {
        if (mod == null) {
            mod = DEFAULT_MODIFIER;
        }
        this.mModifier = mod;
    }

    public AccessMode getAccessMode() {
        return this.mAccessMode;
    }

    private void setAccessMode(AccessMode access) {
        if (access == null) {
            access = DEFAULT_ACCESS;
        }
        this.mAccessMode = access;
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    public ComponentMember getOverriddenMember() {
        Component comp = this.getDeclaringComponent();
        return this.getOverriddenMember(comp);
    }

    ComponentMember getOverriddenMember(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp.isDerivedComponent()) {
            CallSpec cs = comp.getSuperCallSpec();
            ComponentMemberList list = comp.getMemberList(this.getListElementName());
            return list.get(comp, this.getName(), cs);
        }
        return null;
    }

    protected void validatePreparse() throws SystemModelParseException, ComponentDBException {
        if (this.getName() == null) {
            throw ComponentDBException.invalidMemberName(this.getName(), this);
        }
        try {
            this.validateName(this.getName());
        }
        catch (InvalidDatatypeValueException e) {
            throw ComponentDBException.invalidMemberName(this.getName(), this);
        }
    }

    protected void validateName(String name) throws SystemModelParseException, InvalidDatatypeValueException {
        XMLUtil.validateIdentifier(name);
    }

    protected void validate(Component declarer) throws ComponentDBException, PlanDBException {
        ComponentMember overridden;
        if (Modifier.ABSTRACT.equals(this.getModifier())) {
            if (!Modifier.ABSTRACT.equals(declarer.getModifier())) {
                throw ComponentDBException.nonAbstractComp(this);
            }
            if (AccessMode.PRIVATE.equals(this.getAccessMode())) {
                throw ComponentDBException.privateAbstractMember(this);
            }
        }
        if ((overridden = this.getOverriddenMember(declarer)) != null) {
            if (Modifier.FINAL.equals(overridden.getModifier())) {
                throw ComponentDBException.finalOverride(this);
            }
            AccessMode origAccess = overridden.getAccessMode();
            if (this.getAccessMode().isMoreRestrictiveThan(origAccess)) {
                throw ComponentDBException.moreRestrictiveAccess(this);
            }
        }
    }

    void validateCompatibleParams(PromptParamList curList, PromptParamList origList) throws ComponentDBException {
        String[] curNames = curList.getVarNames();
        for (int i = 0; i < curNames.length; ++i) {
            PromptParam curParam = curList.getParam(curNames[i]);
            if (curParam.getDefaultValue() != null) continue;
            PromptParam origParam = origList.getParam(curNames[i]);
            if (origParam == null) {
                throw ComponentDBException.newRequiredParam(curNames[i], this);
            }
            if (origParam.getDefaultValue() == null) continue;
            throw ComponentDBException.optionalToRequiredParam(curNames[i], this);
        }
    }

    protected void writeToXML(XML outXML, boolean isInternal) {
        XML compRef = new XML(this.getElementName());
        compRef.setPrettyPrint(true);
        XMLUtil.addAttribute(compRef, MODIFIER_ATTR, this.getModifier(), DEFAULT_MODIFIER);
        XMLUtil.addAttribute(compRef, ACCESS_ATTR, this.getAccessMode(), DEFAULT_ACCESS);
        XMLUtil.addAttributeIfNotNull(compRef, NAME_ATTR, this.getName());
        this.populateXML(compRef, isInternal);
        outXML.addElement((org.apache.ecs.Element)compRef);
    }

    protected abstract String getElementName();

    protected abstract String getListElementName();

    protected abstract void populateXML(XML var1, boolean var2);

    public String getElementDescription() {
        return MessageManager.messageAsString("cdb.member." + this.getElementName());
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void accept(CompDBVisitor v) throws Exception {
    }

    ComponentMemberBase accept(CompDBTransformer t) throws Exception {
        return t.clone(this);
    }

    ComponentMemberBase cloneForTransform() {
        return (ComponentMemberBase)this.clone();
    }

    void validateNamespace(CompDBPluginNSValidator v) throws Exception {
        this.accept(v);
    }
}

