/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireReadLockTransaction;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.ResourceTreeMover;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.SingleRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceSpecException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompVarNStepValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMember;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberList;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ControlBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.SaveCompatibilityValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.SnapshotBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.UninstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ComponentImpl
extends VersionedPersistentBean
implements Cloneable,
ComponentObserver {
    private static final String DEFAULT_VERSION = "5.2";
    private static final String VERSION_5_1 = "5.1";
    private static final String VERSION_5_0 = "5.0";
    private static final String COMPONENT_SCHEMA = "component.xsd";
    static final String ELEMENT_NAME = "component";
    private static final String PATH_ATTR = "path";
    private static final String NAME_ATTR = "name";
    private static final String ACCESS_MODE_ATTR = "access";
    private static final String MODIFIER_ATTR = "modifier";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String LABEL_ATTR = "label";
    private static final String SOFTWARE_VENDOR_ATTR = "softwareVendor";
    private static final String AUTHOR_ATTR = "author";
    private static final String PLATFORM_ATTR = "platform";
    private static final String LIMIT_TO_HOSTSET_ATTR = "limitToHostSet";
    private static final String VERSION_ATTR = "version";
    private static final String EXTENDS_ELEMENT = "extends";
    private static final String RSRC_REF_ELEMENT = "resourceRef";
    private static final String RSRC_REF_MOD_ATTR = "modifier";
    private static final String RSRC_REF_RSRC_ELEMENT = "resource";
    private static final String RSRC_REF_RSRC_NAME_ATTR = "name";
    private static final String RSRC_REF_RSRC_VERSION_ATTR = "version";
    private static final String COMP_REF_LIST_MOD_ATTR = "modifier";
    private static final String LOCAL_INSTALL_PATH_ATTR = "installPath";
    private static final String DIFF_LIST_ELEMENT = "diff";
    private static final String IGNORE_ELEMENT = "ignore";
    private static final String IGNORE_PATH_ATTR = "path";
    private static final AccessMode DEFAULT_ACCESS_MODE = AccessMode.PUBLIC;
    private AccessMode mAccessMode = DEFAULT_ACCESS_MODE;
    private static final Modifier DEFAULT_MODIFIER = Modifier.NONE;
    private Modifier mModifier = DEFAULT_MODIFIER;
    private String mName;
    private FolderID mPathID = FolderID.ROOT_FOLDER_ID;
    private static final String DEFAULT_DESCRIPTION = "";
    private String mDescription = "";
    private static final String DEFAULT_LABEL = "";
    private String mLabel = "";
    private static final String DEFAULT_PLATFORM = SystemPluginConstants.ALL_PLATFORMS_NAME;
    private String mPlatform = DEFAULT_PLATFORM;
    private String mLimitToHostSet = null;
    private String mHostType = null;
    private String mExtendsTypeName;
    private String mSoftwareVendor;
    private String mAuthor;
    private String mLocalInstallPath = null;
    private Vector mIgnorePaths = new Vector();
    private boolean mIsSimple = false;
    private HostID mSourceInfoRawHostID;
    private String mSourceInfoRawString;
    private boolean mConfigTemplateIsValidated;
    private transient SummaryComponent mSummaryView;
    private boolean mExternalDataLoaded = false;
    private transient String mXMLContent;
    private ComponentType mExtendsType = ComponentType.ROOT;
    private CategoryIDSet mCategoryIDSet;
    private String mSchemaVersion = "5.2";
    static final Modifier RSRC_REF_MOD_DEFAULT = Modifier.NONE;
    private Modifier mLocalResourceModifier;
    private ResourceDefinition mResourceInstallSpec;
    private RsrcInfo mLocalResource;
    private ResourceID mLocalResourceID;
    static final Modifier COMP_REF_LIST_MOD_DEFAULT = Modifier.NONE;
    private Modifier mLocalCompRefListModifier;
    private ComponentType mLocalCompRefListType;
    ComponentMemberList mCompRefList = new ComponentMemberList(ComponentRefDecl.class);
    ComponentMemberList mVarList = new ComponentMemberList(VarDecl.class);
    private transient Map mMemberListMap;
    ComponentMemberList mInstallBlockList = new ComponentMemberList(InstallBlock.class);
    ComponentMemberList mUninstallBlockList = new ComponentMemberList(UninstallBlock.class);
    ComponentMemberList mSnapshotBlockList = new ComponentMemberList(SnapshotBlock.class);
    ComponentMemberList mControlBlockList = new ComponentMemberList(ControlBlock.class);
    private TargetRef mTargetRef;
    private PluginID mPluginID;

    private ComponentImpl() {
    }

    static ComponentImpl create() {
        ComponentImpl result = new ComponentImpl();
        result.resetExternalData(true);
        return result;
    }

    static ComponentImpl create(PluginID plugin) {
        ComponentImpl result = new ComponentImpl();
        result.resetExternalData(true);
        result.setPluginID(plugin);
        return result;
    }

    ComponentID getID() {
        return (ComponentID)this.getObjectID();
    }

    ComponentID getRootID() {
        return (ComponentID)this.getRootObjectID();
    }

    protected UserID getUserID() {
        return super.getUserID();
    }

    protected Date getTimeStamp() {
        return super.getTimeStamp();
    }

    protected VersionNumber getVersionNumber() {
        return super.getVersionNumber();
    }

    AccessMode getAccessMode() {
        return this.mAccessMode;
    }

    void setAccessMode(AccessMode accessMode) {
        if (accessMode == null) {
            throw new NullPointerException();
        }
        this.mAccessMode = accessMode;
    }

    Modifier getModifier() {
        return this.mModifier;
    }

    void setModifier(Modifier modifier) {
        if (modifier == null) {
            throw new NullPointerException();
        }
        this.mModifier = modifier;
    }

    String getName() {
        return this.mName;
    }

    void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    FolderID getPathID() {
        return this.mPathID;
    }

    void setPathID(FolderID path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.mPathID = path;
    }

    String getFullName() {
        String theFullName = this.getPathID().getFullPathString();
        if (this.getName() != null) {
            theFullName = theFullName + this.getName();
        }
        return theFullName;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.mDescription = desc;
    }

    private void resetDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        this.mDescription = desc;
    }

    protected Visibility getVisibility() {
        return super.getVisibility();
    }

    protected void setVisibility(Visibility visibility) {
        super.setVisibility(visibility);
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    String getLabel() {
        return this.mLabel;
    }

    void setLabel(String label) {
        if (label == null) {
            throw new NullPointerException();
        }
        this.mLabel = label;
    }

    private void resetLabel(String label) {
        if (label == null) {
            label = "";
        }
        this.mLabel = label;
    }

    String getPlatform() {
        return this.mPlatform;
    }

    void setPlatform(String platform) {
        if (platform == null) {
            platform = DEFAULT_PLATFORM;
        }
        this.mPlatform = platform;
    }

    String getLocalLimitToHostSet() {
        return this.mLimitToHostSet;
    }

    void setLocalLimitToHostSet(String limitToHostSet) {
        this.mLimitToHostSet = limitToHostSet;
    }

    private String getHostType() {
        return this.mHostType;
    }

    private void setHostType(String hostType) {
        this.mHostType = hostType;
    }

    String getExtendsTypeName() {
        return this.mExtendsTypeName;
    }

    private void setExtendsTypeName(String extendsTypeName) {
        this.mExtendsTypeName = extendsTypeName;
    }

    private String[] toStringArray(Vector v) {
        return v.toArray(new String[v.size()]);
    }

    private void fromStringArray(Vector v, String[] a) {
        v.clear();
        v.addAll(Arrays.asList(a));
    }

    String getSoftwareVendor() {
        return this.mSoftwareVendor;
    }

    void setSoftwareVendor(String softwareVendor) {
        this.mSoftwareVendor = softwareVendor;
    }

    String getAuthor() {
        return this.mAuthor;
    }

    void setAuthor(String author) {
        this.mAuthor = author;
    }

    String getLocalInstallPath() {
        return this.mLocalInstallPath;
    }

    void setLocalInstallPath(String localInstallPath) {
        this.mLocalInstallPath = localInstallPath;
    }

    String[] getIgnorePaths() {
        return this.toStringArray(this.mIgnorePaths);
    }

    void setIgnorePaths(String[] ignorePaths) {
        this.fromStringArray(this.mIgnorePaths, ignorePaths);
    }

    boolean isDerivedComponent() {
        return this.getExtendsTypeName() != null;
    }

    boolean getIsSimpleComponent() {
        if (this.isExternalDataLoaded()) {
            if (this.isDerivedComponent()) {
                return this.getBaseComponent().isSimpleComponent();
            }
            return this.isLocalSimpleComponent();
        }
        return this.mIsSimple;
    }

    private boolean isLocalSimpleComponent() {
        return this.mResourceInstallSpec != null || this.getLocalResourceID() != null || this.getLocalResourceModifier() != null;
    }

    private void setIsSimpleComponent(boolean isSimple) {
        this.mIsSimple = isSimple;
    }

    SourceInfo getSourceInfo() {
        if (this.getSourceInfoRawHostID() == null && this.getSourceInfoRawString() == null) {
            return null;
        }
        return SourceInfo.reconstitute(this.getSourceInfoRawHostID(), this.getSourceInfoRawString());
    }

    void setSourceInfo(SourceInfo sourceInfo) {
        if (sourceInfo == null) {
            this.setSourceInfoRawHostID(null);
            this.setSourceInfoRawString(null);
        } else {
            this.setSourceInfoRawHostID(sourceInfo.getHost());
            this.setSourceInfoRawString(sourceInfo.getPersistString());
        }
    }

    private HostID getSourceInfoRawHostID() {
        return this.mSourceInfoRawHostID;
    }

    private void setSourceInfoRawHostID(HostID sourceInfoRawHostID) {
        this.mSourceInfoRawHostID = sourceInfoRawHostID;
    }

    private String getSourceInfoRawString() {
        return this.mSourceInfoRawString;
    }

    private void setSourceInfoRawString(String sourceInfoRawString) {
        this.mSourceInfoRawString = sourceInfoRawString;
    }

    boolean getConfigTemplateIsValidated() {
        return this.mConfigTemplateIsValidated;
    }

    private void setConfigTemplateIsValidated(boolean isValidated) {
        this.mConfigTemplateIsValidated = isValidated;
    }

    SummaryComponent getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryComponent(this);
        }
        return this.mSummaryView;
    }

    Component getCompleteViewMS(boolean createReadOnlyView) throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new Component(this, createReadOnlyView);
    }

    private boolean isExternalDataLoaded() {
        return this.mExternalDataLoaded;
    }

    private void resetExternalData(boolean isLoadComplete) {
        this.mCategoryIDSet = new CategoryIDSet();
        if (isLoadComplete) {
            this.setExternalDataLoaded();
        }
    }

    private void setExternalDataLoaded() {
        this.mExternalDataLoaded = true;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        if (this.getID() != null) {
            Link[] cats = ComponentToCategoryLinkTable.DEFAULT.getByChildID(this.getID());
            this.setExternalDataMS(Arrays.asList(cats));
        } else {
            this.resetExternalData(true);
        }
    }

    static void loadExternalDataMS(List components) throws PersistenceManagerException {
        int size = components.size();
        if (size == 0) {
            return;
        }
        ComponentIDSet idSet = new ComponentIDSet();
        for (int i = 0; i < size; ++i) {
            ComponentImpl component = (ComponentImpl)components.get(i);
            if (component.isExternalDataLoaded()) continue;
            idSet.add(component.getID());
        }
        if (idSet.isEmpty()) {
            return;
        }
        ObjectID[] componentIDs = idSet.toIDArray();
        Map catMap = ComponentToCategoryLinkTable.DEFAULT.mapLinksByChildIDs(componentIDs);
        for (int i = 0; i < size; ++i) {
            ComponentImpl component = (ComponentImpl)components.get(i);
            if (component.isExternalDataLoaded()) continue;
            List catList = (List)catMap.get(component.getID());
            component.setExternalDataMS(catList);
        }
    }

    private synchronized void setExternalDataMS(List catList) throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        this.resetExternalData(false);
        Link.addParentIDs(this.mCategoryIDSet, catList);
        this.getMemberListMap();
        try {
            this.initExtendsType();
            this.initMembersFromXML();
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
        this.setExternalDataLoaded();
    }

    private String getXMLContent() {
        return this.mXMLContent;
    }

    private void setXMLContent(String XMLContent) {
        this.mXMLContent = XMLContent;
    }

    ComponentType getExtendsType() {
        return this.mExtendsType;
    }

    void setExtendsType(ComponentType extendsType) {
        if (extendsType == null) {
            throw new NullPointerException();
        }
        this.setExtendsTypeName(extendsType.getTypeName());
        this.mExtendsType = extendsType;
    }

    private void initExtendsType() throws PersistenceManagerException, RPCException {
        this.setExtendsType(ComponentType.create(this.getExtendsTypeName()));
    }

    Component getBaseComponent() {
        return this.getExtendsType().getComponent();
    }

    CategoryIDSet getCategories() {
        return (CategoryIDSet)this.mCategoryIDSet.clone();
    }

    void setCategories(CategoryIDSet set) {
        this.mCategoryIDSet = (CategoryIDSet)set.clone();
    }

    String getSchemaVersion() {
        return this.mSchemaVersion;
    }

    void setSchemaVersion(String schemaVersion) {
        this.mSchemaVersion = schemaVersion != null && (schemaVersion.equals(VERSION_5_0) || schemaVersion.equals(VERSION_5_1)) ? DEFAULT_VERSION : schemaVersion;
    }

    Modifier getLocalResourceModifier() {
        return this.mLocalResourceModifier;
    }

    void setLocalResourceModifier(Modifier localResourceModifier) {
        this.mLocalResourceModifier = localResourceModifier;
    }

    ResourceDefinition getLocalResourceInstallSpec(Component declarer) {
        ResourceDefinition result = this.mResourceInstallSpec;
        if (result != null) {
            result = (ResourceDefinition)result.clone();
            result.setDeclaringComponent(declarer);
        }
        return result;
    }

    void setLocalResourceInstallSpec(ResourceDefinition installSpec) {
        if (installSpec != null) {
            installSpec = (ResourceDefinition)installSpec.clone();
        }
        this.mResourceInstallSpec = installSpec;
    }

    RsrcInfo getLocalResource() {
        return this.mLocalResource;
    }

    void setLocalResource(RsrcInfo resource) {
        if (resource == null) {
            this.mLocalResource = null;
            this.mLocalResourceID = null;
        } else {
            this.mLocalResource = resource;
            this.mLocalResourceID = resource.getResourceID();
        }
    }

    private ResourceID getLocalResourceID() {
        return this.mLocalResourceID;
    }

    private void setLocalResourceID(ResourceID localResourceID) {
        this.mLocalResourceID = localResourceID;
    }

    Modifier getLocalCompRefListModifier() {
        return this.mLocalCompRefListModifier;
    }

    void setLocalCompRefListModifier(Modifier localCompRefListModifier) {
        this.mLocalCompRefListModifier = localCompRefListModifier;
    }

    ComponentType getLocalCompRefListType() {
        return this.mLocalCompRefListType;
    }

    void setLocalCompRefListType(ComponentType localCompRefListType) {
        if (localCompRefListType != null) {
            localCompRefListType = localCompRefListType.toReadOnlyView();
        }
        this.mLocalCompRefListType = localCompRefListType;
    }

    ComponentMemberList getLocalCompRefList() {
        return this.mCompRefList;
    }

    ComponentMemberList getLocalVarList() {
        return this.mVarList;
    }

    ComponentMemberList getMemberList(String listName) {
        return (ComponentMemberList)this.getMemberListMap().get(listName);
    }

    private Map getMemberListMap() {
        if (this.mMemberListMap == null) {
            HashMap map = new HashMap();
            this.putList(map, this.getLocalCompRefList());
            this.putList(map, this.getLocalVarList());
            this.putList(map, this.getLocalInstallBlockList());
            this.putList(map, this.getLocalUninstallBlockList());
            this.putList(map, this.getLocalSnapshotBlockList());
            this.putList(map, this.getLocalControlBlockList());
            this.mMemberListMap = map;
        }
        return this.mMemberListMap;
    }

    private void putList(Map map, ComponentMemberList list) {
        map.put(list.getListElementName(), list);
    }

    ComponentMemberList getLocalInstallBlockList() {
        return this.mInstallBlockList;
    }

    ComponentMemberList getLocalUninstallBlockList() {
        return this.mUninstallBlockList;
    }

    ComponentMemberList getLocalSnapshotBlockList() {
        return this.mSnapshotBlockList;
    }

    ComponentMemberList getLocalControlBlockList() {
        return this.mControlBlockList;
    }

    TargetRef getLocalTargetRef(Component declarer) {
        TargetRef result = this.mTargetRef;
        if (result != null) {
            result = (TargetRef)result.clone();
            result.setDeclaringComponent(declarer);
        }
        return result;
    }

    void setLocalTargetRef(TargetRef targetRef) {
        this.mTargetRef = targetRef;
        if (targetRef != null) {
            this.setHostType(targetRef.getTypeName());
        } else {
            this.setHostType(null);
        }
    }

    void readFromXML(String source) throws PersistenceManagerException, RPCException {
        this.readFromXML(this.toInputSource(source), false);
    }

    private InputSource toInputSource(String s) {
        return new InputSource(new StringReader(s));
    }

    void readFromXML(InputStream file, boolean createFolders) throws PersistenceManagerException, RPCException {
        this.readFromXML(new InputSource(file), createFolders);
    }

    private void readFromXML(InputSource inputSource, boolean createFolders) throws PersistenceManagerException, RPCException {
        Element topElement = this.parseInputSource(inputSource, true);
        this.parseSummaryData(topElement, createFolders);
        this.parseDetailData(topElement, false);
        this.validateVarSettings();
        this.validateInheritance();
    }

    private Element parseInputSource(InputSource input, boolean reportErrors) throws SystemModelParseException {
        DOMParser parser = XMLUtil.obtainParser(reportErrors, COMPONENT_SCHEMA, "cdb.");
        try {
            parser.parse(input);
            return parser.getDocument().getDocumentElement();
        }
        catch (IOException e) {
            throw ComponentImpl.newParseError(e);
        }
        catch (SAXException e) {
            throw ComponentImpl.newParseError(e);
        }
    }

    private void parseSummaryData(Element compElem, boolean createFolder) throws PersistenceManagerException, RPCException {
        this.parseSummaryCompAttrs(compElem, createFolder);
        this.parseExtends(compElem);
        this.parseDiffPrefs(compElem);
    }

    private void parseSummaryCompAttrs(Element compElem, boolean createFolder) throws SystemModelParseException {
        this.setAccessMode((AccessMode)XMLUtil.getEnumAttribute(compElem, ACCESS_MODE_ATTR, AccessMode.FACTORY, DEFAULT_ACCESS_MODE));
        this.setModifier((Modifier)XMLUtil.getEnumAttribute(compElem, "modifier", Modifier.FACTORY, DEFAULT_MODIFIER));
        this.setPathID(XMLUtil.getPathAttribute(compElem, "path", "cdb.", createFolder));
        this.setName(XMLUtil.getAttribute(compElem, "name"));
        this.resetDescription(XMLUtil.getAttribute(compElem, DESCRIPTION_ATTR));
        this.resetLabel(XMLUtil.getAttribute(compElem, LABEL_ATTR));
        this.mSoftwareVendor = XMLUtil.getAttribute(compElem, SOFTWARE_VENDOR_ATTR);
        this.mAuthor = XMLUtil.getAttribute(compElem, AUTHOR_ATTR);
        this.setPlatform(XMLUtil.getAttribute(compElem, PLATFORM_ATTR));
        this.setLocalLimitToHostSet(XMLUtil.getAttribute(compElem, LIMIT_TO_HOSTSET_ATTR));
        this.setLocalInstallPath(XMLUtil.getAttribute(compElem, LOCAL_INSTALL_PATH_ATTR));
    }

    private void parseExtends(Element compElem) throws PersistenceManagerException, RPCException {
        ComponentType type = ComponentType.ROOT;
        Element[] extendsElems = XMLUtil.getChildren(compElem, EXTENDS_ELEMENT);
        if (extendsElems.length > 0) {
            type = ComponentType.create(extendsElems[0]);
        }
        this.setExtendsType(type);
    }

    private void parseDiffPrefs(Element compElem) {
        this.mIgnorePaths.clear();
        Element[] lists = XMLUtil.getChildren(compElem, DIFF_LIST_ELEMENT);
        if (lists.length > 0) {
            Element[] ignores = XMLUtil.getChildren(lists[0], IGNORE_ELEMENT);
            for (int i = 0; i < ignores.length; ++i) {
                this.mIgnorePaths.add(XMLUtil.getAttribute(ignores[i], "path"));
            }
        }
    }

    private void parseDetailData(Element compElem, boolean isInternal) throws PersistenceManagerException, RPCException {
        this.parseDetailCompAttrs(compElem);
        this.getLocalVarList().resetFromXML(compElem, this.getPathID(), isInternal);
        this.parseResourceRef(compElem, isInternal);
        this.parseCompRefList(compElem, isInternal);
        this.parseTargetRef(compElem);
        this.getLocalInstallBlockList().resetFromXML(compElem, this.getPathID(), isInternal);
        this.getLocalUninstallBlockList().resetFromXML(compElem, this.getPathID(), isInternal);
        this.getLocalSnapshotBlockList().resetFromXML(compElem, this.getPathID(), isInternal);
        this.getLocalControlBlockList().resetFromXML(compElem, this.getPathID(), isInternal);
    }

    private void parseDetailCompAttrs(Element compElem) {
        this.setSchemaVersion(XMLUtil.getAttribute(compElem, "version"));
    }

    private void parseResourceRef(Element compElem, boolean isInternal) throws PersistenceManagerException, RPCException {
        Element[] resources;
        this.mResourceInstallSpec = null;
        ResourceID rsrcID = this.getLocalResourceID();
        this.setLocalResource(null);
        this.setLocalResourceModifier(null);
        Element[] refs = XMLUtil.getChildren(compElem, RSRC_REF_ELEMENT);
        if (refs.length == 0) {
            return;
        }
        Modifier mod = (Modifier)XMLUtil.getEnumAttribute(refs[0], "modifier", Modifier.FACTORY, RSRC_REF_MOD_DEFAULT);
        this.setLocalResourceModifier(mod);
        Element[] installSpecs = XMLUtil.getChildren(refs[0], "installSpec");
        if (installSpecs.length > 0) {
            this.mResourceInstallSpec = new ResourceDefinition(installSpecs[0]);
        }
        if ((resources = XMLUtil.getChildren(refs[0], RSRC_REF_RSRC_ELEMENT)).length > 0) {
            if (isInternal) {
                this.setLocalResource(rsrcID.getByIDQuery().select());
            } else {
                String rsrcName = XMLUtil.getAttribute(resources[0], "name");
                String rsrcVersion = XMLUtil.getAttribute(resources[0], "version");
                try {
                    ResourceSpec spec = new ResourceSpec(rsrcName);
                    RsrcInfo resource = SingleRsrcInfoQuery.bySpec(spec, rsrcVersion).select();
                    this.setLocalResource(resource);
                }
                catch (ResourceSpecException e) {
                    throw ComponentImpl.newParseError(e);
                }
            }
        }
    }

    private void parseCompRefList(Element compElem, boolean isInternal) throws PersistenceManagerException, RPCException {
        this.setLocalCompRefListModifier(null);
        this.setLocalCompRefListType(null);
        Element[] list = XMLUtil.getChildren(compElem, "componentRefList");
        if (list.length > 0) {
            Modifier mod = (Modifier)XMLUtil.getEnumAttribute(list[0], "modifier", Modifier.FACTORY, COMP_REF_LIST_MOD_DEFAULT);
            this.setLocalCompRefListModifier(mod);
            this.setLocalCompRefListType(ComponentType.create(list[0]));
        }
        this.getLocalCompRefList().resetFromXML(compElem, this.getPathID(), isInternal);
    }

    private void parseTargetRef(Element compElem) {
        Element[] refs = XMLUtil.getChildren(compElem, TargetRef.getElementName());
        if (refs.length > 0) {
            this.setLocalTargetRef(new TargetRef(refs[0]));
        } else {
            this.setLocalTargetRef(null);
        }
    }

    static SystemModelParseException newParseError(Exception e) {
        return new SystemModelParseException(e, "cdb.");
    }

    private SystemModelParseException newParseError(String code, String arg1) {
        ROXMessage message = new ROXMessage(code, (Object[])new String[]{arg1}, 2000);
        return new SystemModelParseException(message);
    }

    private void initMembersFromXML() throws PersistenceManagerException, RPCException {
        Element topElement = this.parseInputSource(this.toInputSource(this.getXMLContent()), false);
        this.parseDetailData(topElement, true);
    }

    String writeToXML() {
        String sep = System.getProperty("line.separator");
        return XMLUtil.getXMLHeaderString() + this.writeToXMLElement().toString() + sep;
    }

    void writeToXML(OutputStream out) {
        XMLUtil.writeXMLHeader(out);
        this.writeToXMLElement().output(out);
        new PrintWriter(out, true).println();
    }

    private XML writeToXMLElement() {
        XML comp = new XML(ELEMENT_NAME);
        comp.setPrettyPrint(true);
        XMLUtil.addSchemaAttributes(comp, COMPONENT_SCHEMA);
        this.writeSummaryCompAttrs(comp);
        this.writeDetailCompAttrs(comp);
        this.writeExtends(comp);
        this.writeDetailMembers(comp, false);
        this.writeDiffPrefs(comp);
        return comp;
    }

    private void writeDetailMembers(XML comp, boolean isInternal) {
        this.getLocalVarList().writeToXML(comp, isInternal);
        this.writeTargetRef(comp);
        this.writeResourceRef(comp);
        this.writeCompRefList(comp, isInternal);
        this.getLocalInstallBlockList().writeToXML(comp, isInternal);
        this.getLocalUninstallBlockList().writeToXML(comp, isInternal);
        this.getLocalSnapshotBlockList().writeToXML(comp, isInternal);
        this.getLocalControlBlockList().writeToXML(comp, isInternal);
    }

    private void writeSummaryCompAttrs(XML compElem) {
        XMLUtil.addAttribute(compElem, ACCESS_MODE_ATTR, this.getAccessMode(), DEFAULT_ACCESS_MODE);
        XMLUtil.addAttribute(compElem, "modifier", this.getModifier(), DEFAULT_MODIFIER);
        XMLUtil.addPathAttribute(compElem, "path", this.getPathID());
        this.addOptAttr(compElem, "name", this.getName());
        this.addOptAttr(compElem, DESCRIPTION_ATTR, this.mDescription);
        this.addOptAttr(compElem, LABEL_ATTR, this.mLabel);
        this.addOptAttr(compElem, SOFTWARE_VENDOR_ATTR, this.mSoftwareVendor);
        this.addOptAttr(compElem, AUTHOR_ATTR, this.mAuthor);
        if (!DEFAULT_PLATFORM.equals(this.mPlatform)) {
            this.addOptAttr(compElem, PLATFORM_ATTR, this.mPlatform);
        }
        this.addOptAttr(compElem, LIMIT_TO_HOSTSET_ATTR, this.getLocalLimitToHostSet());
        this.addOptAttr(compElem, LOCAL_INSTALL_PATH_ATTR, this.mLocalInstallPath);
    }

    private void writeDetailCompAttrs(XML compElem) {
        this.addOptAttr(compElem, "version", this.mSchemaVersion);
    }

    private void writeExtends(XML compElem) {
        ComponentType type = this.getExtendsType();
        if (type.isRoot()) {
            return;
        }
        XML extendsElem = new XML(EXTENDS_ELEMENT);
        extendsElem.setPrettyPrint(true);
        type.writeToXML(extendsElem);
        compElem.addElement((org.apache.ecs.Element)extendsElem);
    }

    private void writeTargetRef(XML compDef) {
        if (this.mTargetRef != null) {
            XML tgtRefXml = new XML(TargetRef.getElementName());
            tgtRefXml.setPrettyPrint(true);
            this.mTargetRef.populateXML(tgtRefXml);
            compDef.addElement((org.apache.ecs.Element)tgtRefXml);
        }
    }

    private void writeResourceRef(XML compDef) {
        RsrcInfo rsrc;
        if (!this.isLocalSimpleComponent()) {
            return;
        }
        XML resourceRef = new XML(RSRC_REF_ELEMENT);
        resourceRef.setPrettyPrint(true);
        Modifier mod = this.getLocalResourceModifier();
        if (mod == null) {
            mod = RSRC_REF_MOD_DEFAULT;
        }
        XMLUtil.addAttribute(resourceRef, "modifier", mod, RSRC_REF_MOD_DEFAULT);
        ResourceDefinition installSpec = this.mResourceInstallSpec;
        if (installSpec != null) {
            installSpec.writeToXML(resourceRef);
        }
        if ((rsrc = this.getLocalResource()) != null) {
            XML resource = new XML(RSRC_REF_RSRC_ELEMENT);
            resource.setPrettyPrint(true);
            XMLUtil.addAttributeIfNotNull(resource, "name", rsrc.getName());
            XMLUtil.addAttributeIfNotNull(resource, "version", rsrc.getVersionNumber().getAsString());
            resourceRef.addElement((org.apache.ecs.Element)resource);
        }
        compDef.addElement((org.apache.ecs.Element)resourceRef);
    }

    private void writeCompRefList(XML comp, boolean isInternal) {
        ComponentMemberList list = this.getLocalCompRefList();
        Modifier mod = this.getLocalCompRefListModifier();
        ComponentType type = this.getLocalCompRefListType();
        if (type != null && type.isRoot()) {
            type = null;
        }
        if (list.size() > 0 || mod != null || type != null) {
            XML listXML = new XML("componentRefList");
            listXML.setPrettyPrint(true);
            if (mod == null) {
                mod = COMP_REF_LIST_MOD_DEFAULT;
            }
            XMLUtil.addAttribute(listXML, "modifier", mod, COMP_REF_LIST_MOD_DEFAULT);
            if (type != null) {
                type.writeToXML(listXML);
            }
            list.writeMembersToXML(listXML, isInternal);
            comp.addElement((org.apache.ecs.Element)listXML);
        }
    }

    private void writeDiffPrefs(XML compElem) {
        if (this.mIgnorePaths.size() > 0) {
            XML diff = new XML(DIFF_LIST_ELEMENT);
            diff.setPrettyPrint(true);
            for (int i = 0; i < this.mIgnorePaths.size(); ++i) {
                XML ignore = new XML(IGNORE_ELEMENT);
                ignore.setPrettyPrint(true);
                String path = (String)this.mIgnorePaths.get(i);
                XMLUtil.addAttributeIfNotNull(ignore, "path", path);
                diff.addElement((org.apache.ecs.Element)ignore);
            }
            compElem.addElement((org.apache.ecs.Element)diff);
        }
    }

    private void addOptAttr(XML element, String name, String value) {
        if (value != null && !value.equals("")) {
            XMLUtil.addAttributeIfNotNull(element, name, value);
        }
    }

    private void writeMembersToXML() {
        XML comp = new XML(ELEMENT_NAME);
        this.writeDetailCompAttrs(comp);
        this.writeDetailMembers(comp, true);
        this.setXMLContent(XMLUtil.getXMLForDB(comp));
    }

    protected Object clone() {
        try {
            ComponentImpl result = (ComponentImpl)super.clone();
            result.mSummaryView = null;
            result.mCompRefList = (ComponentMemberList)result.mCompRefList.clone();
            result.mIgnorePaths = (Vector)result.mIgnorePaths.clone();
            result.mVarList = (ComponentMemberList)result.mVarList.clone();
            result.mInstallBlockList = (ComponentMemberList)result.mInstallBlockList.clone();
            result.mUninstallBlockList = (ComponentMemberList)result.mUninstallBlockList.clone();
            result.mSnapshotBlockList = (ComponentMemberList)result.mSnapshotBlockList.clone();
            result.mControlBlockList = (ComponentMemberList)result.mControlBlockList.clone();
            result.mMemberListMap = null;
            result.setExtendsType(result.getExtendsType().toReadOnlyView());
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            ComponentImpl result = (ComponentImpl)super.getObjectDataClone();
            result.setPluginID(null);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save(ComponentSaveContext ctx) throws PersistenceManagerException, RPCException {
        this.validate();
        this.saveRPC(ctx);
    }

    protected void saveMS(final VersionedSaveContext context) throws PersistenceManagerException {
        ComponentImpl.transactMS(new AcquireReadLockTransaction(){

            public Object execute() throws PersistenceManagerException {
                ComponentImpl.this.executeSaveMS(context);
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("cdb.SAVING_COMPONENT", ComponentImpl.this.getFullName());
            }
        });
    }

    private void executeSaveMS(VersionedSaveContext context) throws PersistenceManagerException {
        VersionedSaveContext vcxt = this.getValidContext(context);
        ComponentID.verifyPerms(this.getSummaryView(), null, false);
        this.validateMS(vcxt);
        this.setConfigTemplateIsValidated(true);
        this.writeMembersToXML();
        super.saveMS(context);
    }

    protected void saveSameVersionMS() throws PersistenceManagerException {
        this.writeMembersToXML();
        super.saveSameVersionMS();
    }

    protected void trSaveMS(VersionedPersistentBean latest, VersionedSaveContext ctx) throws PersistenceManagerException {
        Component currentComp = this.getCompleteViewMS(true);
        if (latest != null) {
            Component latestComp = ((ComponentImpl)latest).getCompleteViewMS(true);
            try {
                SaveCompatibilityValidator.validate(latestComp, currentComp);
            }
            catch (RPCException e) {
                throw ComponentDBException.unexpectedRPCError(e);
            }
        }
        super.trSaveMS(latest, ctx);
        ComponentToCategoryLinkTable.DEFAULT.updateCategoriesMS(this.getID(), new CategoryUpdateContext(this.mCategoryIDSet), this.getID().equals(this.getRootID()));
        this.incrementUpdateCountInSave();
        HashSet refdTypes = new HashSet();
        this.addTypeRef(refdTypes, this.getExtendsType());
        this.addTypeRef(refdTypes, this.getLocalCompRefListType());
        ComponentIDSet refdComps = new ComponentIDSet();
        Iterator compRefs = this.getLocalCompRefList().iterator();
        while (compRefs.hasNext()) {
            ComponentRefDecl compRef = (ComponentRefDecl)compRefs.next();
            this.addTypeRef(refdTypes, compRef.getLocalType());
            SummaryComponent comp = compRef.getComponent();
            if (comp == null) continue;
            refdComps.add(comp.getID());
        }
        ComponentToComponentLinkTable.DEFAULT.resetLinks(this.getID(), refdComps.toIDArray(), false);
        ObjectID[] refdTypeIDs = refdTypes.toArray(new ComponentTypeRefID[refdTypes.size()]);
        CompTypeRefToComponentLinkTable.DEFAULT.resetLinks(refdTypeIDs, this.getID(), false);
        NameRefSet set = new NameRefSet();
        this.addComponentRefsMS(set);
        ComponentToComponentNameRefTable.DEFAULT.addReferences(this.getID(), set);
        if (!(ctx instanceof ComponentSaveContext)) {
            return;
        }
        ComponentSaveContext compCtx = (ComponentSaveContext)ctx;
        ComponentID importFromID = compCtx.getImportSettingsFromID();
        if (importFromID != null) {
            currentComp.importVariableSettingsMS(importFromID);
        }
        if (latest != null && compCtx.getImportSettings()) {
            ComponentID fromID = ((ComponentImpl)latest).getID();
            currentComp.importVariableSettingsMS(fromID);
        }
    }

    private void addTypeRef(HashSet set, ComponentType type) {
        if (type != null && !type.isRoot()) {
            set.add(type.getComponentTypeRef().getID());
        }
    }

    void validate() throws PersistenceManagerException, RPCException {
        Component.validateName(this.getName());
        Iterator memberLists = this.getMemberListMap().values().iterator();
        while (memberLists.hasNext()) {
            ComponentMemberList list = (ComponentMemberList)memberLists.next();
            list.validatePreparse();
        }
        this.validateXMLContent();
    }

    private void validateXMLContent() throws PersistenceManagerException, RPCException {
        String xml = this.writeToXML();
        ComponentImpl temp = ComponentImpl.create();
        temp.readFromXML(xml);
    }

    private static ConfigTemplate getConfigTemplate(final RsrcInfo rsrcInfo) throws ResourceException {
        return (ConfigTemplate)new ResourceAccessor(((Server)Server.getApp()).getResourceSubsystem()){

            public Object innerAccess() throws ResourceException {
                RsrcManifest manifest = this.getManifest(rsrcInfo.getResourceID(), null);
                InputStream istream = manifest.getInputStream(manifest.getEntryIterator().next());
                try {
                    UnicodeInputStreamReader reader = new UnicodeInputStreamReader(istream);
                    ConfigTemplate configTemplate = new ConfigParser().createTemplate(reader);
                    return configTemplate;
                }
                catch (ConfigGenException e) {
                    throw new ResourceException(e);
                }
                finally {
                    try {
                        istream.close();
                    }
                    catch (IOException e) {
                        throw new ResourceException(e);
                    }
                }
            }
        }.access();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateConfigTemplateMS() throws PersistenceManagerException {
        RsrcInfo localRsrc = this.getLocalResource();
        ConfigTemplate rsrcContent = null;
        if (localRsrc != null && localRsrc.getConfigurable()) {
            try {
                rsrcContent = ComponentImpl.getConfigTemplate(localRsrc);
            }
            catch (ResourceException e) {
                throw new PersistenceManagerException(e);
            }
        }
        if (rsrcContent != null) {
            Component curComp = new Component(this, true);
            Caller real = new Caller(null, curComp);
            CompVarNStepValidator validator = new CompVarNStepValidator(real);
            TokenCallContext tcc = validator.getTokenCallContext();
            tcc.pushVarScope();
            try {
                tcc.addSystemCompVars();
                VarDecl[] compVars = curComp.getVarList(null);
                for (int i = 0; i < compVars.length; ++i) {
                    tcc.addVarDecl(compVars[i].getName());
                }
                if (curComp.getTargetRef() != null) {
                    tcc.addVarDecl("sys.targetRefName");
                }
                if (this.getIsSimpleComponent()) {
                    tcc.addVarDecl("sys.rsrcInstallPath");
                }
                try {
                    validator.visit(rsrcContent);
                }
                catch (Exception e) {
                    throw validator.mapException(e);
                }
            }
            finally {
                tcc.popVarScope();
            }
        }
    }

    private void validateVarSettings() throws ComponentDBException, PersistenceManagerException {
        Component curComp = new Component(this, true);
        Caller real = new Caller(null, curComp);
        CompVarNStepValidator validator = new CompVarNStepValidator(real);
        try {
            validator.visit(this);
        }
        catch (Exception e) {
            throw validator.mapException(e);
        }
    }

    private void validateMS(VersionedSaveContext cxt) throws PersistenceManagerException {
        try {
            this.validateName();
            this.validateInheritanceMS();
            this.validateNamespaceMS(cxt);
            this.validateConfigTemplateMS();
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    private void validateName() throws PersistenceManagerException, RPCException {
        SummaryComponent rootComp;
        String rootName;
        ComponentID rootID = this.getRootID();
        if (rootID != null && !(rootName = (rootComp = rootID.getByIDQuery().selectSummaryView()).getFullName()).equals(this.getFullName())) {
            throw ComponentDBException.compNameMustMatchRoot(rootName);
        }
    }

    private void validateInheritance() throws ComponentDBException, PlanDBException {
        Component base = this.getBaseComponent();
        Component current = new Component(this, true);
        ComponentImpl.validateInstallPath(this.getLocalInstallPath(), base);
        this.validateIsSimpleComp(base);
        this.validateInstallSpec(current, base);
        this.validateExtendsAndCompRefListTypeAccessible(current, base);
        this.validateResource(current);
        this.validateResourceModifier(current, base);
        this.validateCompRefListModifierAndType(current, base);
        ComponentImpl.validateMembers(this.getMemberListMap().values().iterator(), current);
        this.validateRequiredBlocks(current);
        this.validateTargetRef(current, base);
    }

    private void validateInheritanceMS() throws PersistenceManagerException, RPCException {
        Component base = this.getBaseComponent();
        Component current = new Component(this, true);
        this.validatePlatform(base);
        this.validateLimitToHostSet(base);
        this.validateCompRefListMS(current, base);
    }

    private void validatePlatform(Component base) throws PersistenceManagerException, RPCException {
        String platformName = this.getPlatform();
        try {
            SummaryHostSet curHostSet;
            String allPlatformsName;
            HostSetID baseHostSetID;
            String baseHostSetName = null;
            if (base != null) {
                baseHostSetName = base.getPlatform();
            }
            if (!(baseHostSetID = ComponentImpl.getHostSetIDByName(baseHostSetName, allPlatformsName = SystemPluginConstants.ALL_PLATFORMS_NAME)).isDescendant((curHostSet = ComponentImpl.getHostSetByName(platformName, allPlatformsName)).getID())) {
                throw ComponentDBException.invalidPlatform(platformName, baseHostSetName);
            }
            if (!curHostSet.isSupported()) {
                throw ComponentDBException.unsupportedHostset(curHostSet.getName(), this.getFullName());
            }
        }
        catch (NoResultsFoundException e) {
            throw ComponentDBException.unknownPlatform(platformName);
        }
    }

    private void validateLimitToHostSet(Component base) throws PersistenceManagerException, RPCException {
        String hostSetName = this.getLocalLimitToHostSet();
        try {
            SummaryHostSet shs;
            HostSetID curHostSetID;
            String baseHostSetName = null;
            if (base != null) {
                baseHostSetName = base.getLimitToHostSet();
            }
            HostSetID hostSetID = curHostSetID = (shs = ComponentImpl.getHostSetByName(hostSetName, null)) == null ? null : shs.getID();
            if (curHostSetID != null && baseHostSetName != null) {
                throw ComponentDBException.invalidLimitToHostSet(baseHostSetName);
            }
            if (shs != null && !shs.isSupported()) {
                throw ComponentDBException.unsupportedHostset(shs.getName(), this.getFullName());
            }
        }
        catch (NoResultsFoundException e) {
            throw ComponentDBException.unknownLimitToHostSet(hostSetName);
        }
    }

    static SummaryHostSet getHostSetByName(String name, String defaultName) throws PersistenceManagerException, RPCException {
        if (name == null) {
            return defaultName == null ? null : ComponentImpl.getHostSetByName(defaultName, null);
        }
        return SingleHostSetQuery.byName(name).selectSummaryView();
    }

    static HostSetID getHostSetIDByName(String name, String defaultName) throws PersistenceManagerException, RPCException {
        SummaryHostSet shs = ComponentImpl.getHostSetByName(name, defaultName);
        return shs == null ? null : shs.getID();
    }

    private static void validateInstallPath(String installPath, Component base) throws ComponentDBException {
        if (base != null) {
            if (installPath != null) {
                throw ComponentDBException.installPathInDerivedComp();
            }
        } else if (installPath == null) {
            throw ComponentDBException.noInstallPathInNonDerivedComp();
        }
    }

    private static void validateMembers(Iterator memberLists, Component comp) throws ComponentDBException, PlanDBException {
        while (memberLists.hasNext()) {
            ComponentMemberList list = (ComponentMemberList)memberLists.next();
            list.validate(comp);
        }
    }

    private void validateIsSimpleComp(Component base) throws ComponentDBException {
        if (base != null) {
            if (base.isSimpleComponent()) {
                if (this.isLocalCompositeComponent()) {
                    throw ComponentDBException.localCompositeBaseSimple();
                }
            } else if (this.isLocalSimpleComponent()) {
                throw ComponentDBException.localSimpleBaseComposite();
            }
        }
    }

    private boolean isLocalCompositeComponent() {
        ComponentMemberList list = this.getLocalCompRefList();
        Modifier mod = this.getLocalCompRefListModifier();
        ComponentType type = this.getLocalCompRefListType();
        if (type != null && type.isRoot()) {
            type = null;
        }
        return list.size() > 0 || mod != null || type != null;
    }

    private void validateInstallSpec(Component current, Component base) throws ComponentDBException {
        if (!current.isSimpleComponent()) {
            return;
        }
        if (base != null) {
            if (this.mResourceInstallSpec != null) {
                throw ComponentDBException.installSpecInDerivedComp();
            }
        } else if (this.mResourceInstallSpec == null) {
            throw ComponentDBException.noInstallSpecInRootComp();
        }
    }

    private void validateResource(Component current) throws ComponentDBException {
        if (!current.isSimpleComponent()) {
            return;
        }
        if (!this.isLocalSimpleComponent()) {
            return;
        }
        if (Modifier.ABSTRACT.equals(current.getResourceModifier())) {
            if (this.getLocalResource() != null) {
                throw ComponentDBException.nonEmptyAbstractRsrcRef();
            }
        } else if (this.getLocalResource() == null) {
            throw ComponentDBException.emptyNonAbstractRsrcRef();
        }
    }

    private void validateResourceModifier(Component current, Component base) throws ComponentDBException {
        if (!current.isSimpleComponent()) {
            return;
        }
        Modifier curMod = current.getLocalResourceModifier();
        if (Modifier.ABSTRACT.equals(curMod) && !Modifier.ABSTRACT.equals(this.getModifier())) {
            throw ComponentDBException.abstractRsrcNonAbstractComp();
        }
        if (base != null) {
            Modifier baseMod = base.getResourceModifier();
            if (Modifier.FINAL.equals(baseMod)) {
                if (this.isLocalSimpleComponent()) {
                    throw ComponentDBException.finalRsrcOverride();
                }
            } else if (Modifier.ABSTRACT.equals(baseMod) && !Modifier.ABSTRACT.equals(this.getModifier()) && !this.isLocalSimpleComponent()) {
                throw ComponentDBException.abstractRsrcNotOverridden();
            }
        }
    }

    private void validateExtendsAndCompRefListTypeAccessible(Component current, Component base) throws ComponentDBException {
        CallSpec caller = new CallSpec(new Caller(null, current), null);
        if (base != null && !base.isAccessible(caller)) {
            throw ComponentDBException.inaccessibleExtendsType();
        }
        ComponentType listType = this.getLocalCompRefListType();
        if (listType != null && !listType.isRoot() && !listType.getComponent().isAccessible(caller)) {
            throw ComponentDBException.inaccessibleCompRefListType();
        }
    }

    private void validateCompRefListModifierAndType(Component current, Component base) throws ComponentDBException {
        if (current.isSimpleComponent()) {
            return;
        }
        if (!this.isLocalCompositeComponent()) {
            return;
        }
        if (base == null) {
            return;
        }
        if (Modifier.FINAL.equals(base.getCompRefListModifier()) && !Modifier.FINAL.equals(this.getLocalCompRefListModifier())) {
            throw ComponentDBException.overrideCompRefListNonFinal();
        }
        ComponentType baseType = base.getCompRefListType();
        ComponentType curType = this.getLocalCompRefListType();
        if (curType == null) {
            curType = ComponentType.ROOT;
        }
        if (!curType.isInstanceOf(baseType)) {
            throw ComponentDBException.incompatibleCompRefListType();
        }
    }

    private void validateCompRefListMS(Component current, Component base) throws PersistenceManagerException, RPCException {
        if (current.isSimpleComponent()) {
            return;
        }
        Iterator localRefs = this.getLocalCompRefList().iterator();
        while (localRefs.hasNext()) {
            ComponentRefDecl compRef = (ComponentRefDecl)localRefs.next();
            compRef.validateMS(current);
        }
        this.validateCompRefListTypeMS(current, base);
    }

    private void validateCompRefListTypeMS(Component current, Component base) throws PersistenceManagerException, RPCException {
        if (base == null) {
            return;
        }
        ComponentType curListType = current.getCompRefListType();
        ComponentType baseListType = base.getCompRefListType();
        if (ObjectUtil.equals(curListType.getTypeName(), baseListType.getTypeName())) {
            return;
        }
        while (base != null) {
            ComponentRefDecl[] baseRefs = current.getCompRefList(base.getThisCallSpec());
            for (int i = 0; i < baseRefs.length; ++i) {
                if (baseRefs[i].getDeclaringComponent() != base) continue;
                baseRefs[i].validateDerivedCompListTypeMS(curListType);
            }
            base = base.getBaseComponent();
        }
    }

    private void validateRequiredBlocks(Component current) throws ComponentDBException {
        if (!Modifier.ABSTRACT.equals(this.getModifier())) {
            if (!this.hasNonPrivateMember(current.getInstallList(null))) {
                throw ComponentDBException.noAccessibleInstallBlocks();
            }
            if (!this.hasNonPrivateMember(current.getUninstallList(null))) {
                throw ComponentDBException.noAccessibleUninstallBlocks();
            }
        }
    }

    private boolean hasNonPrivateMember(ComponentMember[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (AccessMode.PRIVATE.equals(list[i].getAccessMode())) continue;
            return true;
        }
        return false;
    }

    private void validateTargetRef(Component current, Component base) throws ComponentDBException {
        if (base != null && current != null && base.getTargetRef() != null && current.getLocalTargetRef() != null) {
            throw ComponentDBException.invalidTargetRefOverride(current.getFullName(), base.getFullName());
        }
    }

    PluginID getPluginID() {
        return this.mPluginID;
    }

    private void setPluginID(PluginID plugin) {
        this.mPluginID = plugin;
    }

    void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        Component curComp = this.getCompleteViewMS(true);
        Caller real = new Caller(null, curComp);
        ComponentNameRefAdder adder = new ComponentNameRefAdder(set, real);
        try {
            adder.visit(this);
        }
        catch (Exception e) {
            throw adder.mapException(e);
        }
        set.addNameRef(this.getName(), this.getPathID().getFullPathString());
    }

    ComponentImpl updateComponentRefsMS(SummaryComponent sc, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ComponentImpl result;
        Caller real = new Caller(null, this.getCompleteViewMS(true));
        ComponentNameRefUpdater updater = new ComponentNameRefUpdater(sc, real, newName, newPath);
        try {
            result = updater.transform(this);
        }
        catch (Exception e) {
            throw updater.mapException(e);
        }
        if (this.getRootID().equals(sc.getRootID())) {
            if (newName != null) {
                result.setName(newName);
            }
            if (newPath != null) {
                result.setPathID(newPath.getID());
            }
        }
        return result;
    }

    public void renameComponent(SummaryComponent sc, String name, SummaryFolder path) throws PersistenceManagerException, RPCException {
        String origFullName = this.getFullName();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("moving component " + origFullName + " to " + (path == null ? this.getPathID().getFullPathString() : path.getFullPathString()) + (name == null ? this.getName() : name), this);
        }
        ComponentImpl comp = this.updateComponentRefsMS(sc, name, path);
        int curUpdateCount = this.getID().getByIDQuery().selectSummaryView().getUpdateCount();
        comp.setUpdateCount(curUpdateCount);
        comp.saveSameVersionMS();
        String newFullName = path != null ? path.getFullPathString() + comp.getName() : comp.getFullName();
        this.moveResource(sc, origFullName, newFullName);
    }

    private void moveResource(SummaryComponent sc, String origFullName, String newFullName) throws PersistenceManagerException, RPCException {
        RsrcInfo rsrc = this.getLocalResource();
        if (rsrc == null) {
            return;
        }
        if (!this.getRootID().equals(sc.getRootID())) {
            return;
        }
        try {
            rsrc = rsrc.getResourceID().getByIDQuery().select();
            if (origFullName.equals(rsrc.getName())) {
                ResourceSubsystem rsrcSubsys = PersistenceManager.getInstance().getApplication().getResourceSubsystem();
                ResourceTreeMover mover = new ResourceTreeMover(rsrcSubsys);
                mover.moveTrees(origFullName, newFullName);
            }
        }
        catch (ResourceException e) {
            throw new PersistenceManagerException(e);
        }
        catch (UnsupportedSubsystemException e) {
            throw new PersistenceManagerException(e);
        }
    }

    boolean isMoveNeeded(String name, SummaryFolder path) {
        if (name == null) {
            if (path == null) {
                return false;
            }
            if (this.getPathID() != null && this.getPathID().getFullPathString().equals(path.getFullPathString())) {
                return false;
            }
        } else if (this.getName().equals(name)) {
            if (path == null) {
                return false;
            }
            if (this.getPathID() != null && this.getPathID().getFullPathString().equals(path.getFullPathString())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(CompDBVisitor v) throws Exception {
        Component curComp = this.getCompleteViewMS(true);
        TokenCallContext tcc = v.getTokenCallContext();
        tcc.pushVarScope();
        try {
            ResourceDefinition ris;
            int i;
            tcc.enterComponentVarContext();
            try {
                tcc.addSystemCompVars();
                VarDecl[] compVars = curComp.getVarList(null);
                for (i = 0; i < compVars.length; ++i) {
                    if (this.mVarList.contains(compVars[i].getName())) {
                        v.visit(compVars[i]);
                    }
                    tcc.addVarDecl(compVars[i].getName());
                }
            }
            finally {
                tcc.exitContext();
            }
            if (this.mTargetRef != null) {
                v.visit(this.mTargetRef);
            }
            if (curComp.getTargetRef() != null) {
                tcc.addVarDecl("sys.targetRefName");
            }
            if ((ris = this.getLocalResourceInstallSpec(curComp)) != null) {
                v.visit(ris);
            }
            if (this.getIsSimpleComponent()) {
                tcc.addVarDecl("sys.rsrcInstallPath");
            }
            v.visitToken(this.getLocalInstallPath());
            v.visit(this.mControlBlockList);
            v.visit(this.mInstallBlockList);
            v.visit(this.mUninstallBlockList);
            v.visit(this.mSnapshotBlockList);
            v.visit(this.mCompRefList);
            for (i = 0; i < this.mIgnorePaths.size(); ++i) {
                v.visitToken((String)this.mIgnorePaths.get(i));
            }
        }
        finally {
            tcc.popVarScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentImpl accept(CompDBTransformer t) throws Exception {
        Component curComp = this.getCompleteViewMS(true);
        ComponentImpl resImpl = t.clone(this);
        TokenCallContext tcc = t.getTokenCallContext();
        tcc.pushVarScope();
        try {
            int i;
            tcc.enterComponentVarContext();
            try {
                tcc.addSystemCompVars();
                VarDecl[] compVars = curComp.getVarList(null);
                for (i = 0; i < compVars.length; ++i) {
                    String compVar = compVars[i].getName();
                    if (this.mVarList.contains(compVar)) {
                        resImpl.mVarList.add(t.transform(compVars[i]));
                    }
                    tcc.addVarDecl(compVars[i].getName());
                }
            }
            finally {
                tcc.exitContext();
            }
            if (this.mTargetRef != null) {
                resImpl.setLocalTargetRef(t.transform(this.mTargetRef));
            }
            if (curComp.getTargetRef() != null) {
                tcc.addVarDecl("sys.targetRefName");
            }
            if (this.mResourceInstallSpec != null) {
                resImpl.mResourceInstallSpec = t.transform(this.mResourceInstallSpec);
            }
            if (this.getIsSimpleComponent()) {
                tcc.addVarDecl("sys.rsrcInstallPath");
            }
            resImpl.setLocalInstallPath(t.transformToken(this.getLocalInstallPath()));
            resImpl.mControlBlockList = t.transform(this.mControlBlockList);
            resImpl.mInstallBlockList = t.transform(this.mInstallBlockList);
            resImpl.mUninstallBlockList = t.transform(this.mUninstallBlockList);
            resImpl.mSnapshotBlockList = t.transform(this.mSnapshotBlockList);
            resImpl.mCompRefList = t.transform(this.mCompRefList);
            String[] igPaths = this.getIgnorePaths();
            for (i = 0; i < igPaths.length; ++i) {
                igPaths[i] = t.transformToken(igPaths[i]);
            }
            resImpl.setIgnorePaths(igPaths);
        }
        finally {
            tcc.popVarScope();
        }
        return resImpl;
    }

    ComponentImpl cloneForTransform() {
        return (ComponentImpl)this.clone();
    }

    private void validateNamespaceMS(VersionedSaveContext cxt) throws PersistenceManagerException, RPCException {
        SummaryComponent root;
        PluginID plid = this.getPluginID();
        if (this.getRootID() != null && !ObjectUtil.equals(plid, (root = this.getRootID().getByIDQuery().selectSummaryView()).getPluginID())) {
            throw ComponentDBException.pluginMustMatchRoot();
        }
        SummaryFolder csf = this.getPathID().getByIDQuery().selectSummaryView();
        ComponentID.verifyFolder(this.getSummaryView(), csf);
        if (plid != null) {
            Plugin p = plid.getByIDQuery().select();
            p.validateNamespace(this.getPluginID(), this.getFullName(), ELEMENT_NAME);
            Caller real = new Caller(null, this.getCompleteViewMS(true));
            CompDBPluginNSValidator cnv = new CompDBPluginNSValidator(p, real, cxt);
            try {
                cnv.visit(this);
            }
            catch (Exception e) {
                throw cnv.mapException(e);
            }
            cnv.visit(this.getExtendsType());
            cnv.visit(this.getLocalCompRefListType());
            cnv.visitHostSet(this.getLocalLimitToHostSet());
            cnv.visitHostSet(this.getPlatform());
        }
    }
}

