/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlan;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlanTable;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.SubplanInfoID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.query.MultiAutoGenPlanQuery;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireReadLockRPCTransaction;
import com.raplix.rolloutexpress.persist.AcquireWriteLockRPCTransaction;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleVersionedObjectByFullNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.PrivilegedTableDependency;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.TableDependency;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.resource.MultiRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallCompatibilityValidator;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompVarSettingsObserverQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompVarSettingsToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserverQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiCompObserverQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentVariableSettingsQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentVariableSettingsQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ComponentID
extends VersionedObjectID {
    public static final ComponentID COMPONENT_SENTINEL_ID = new ComponentID("010010001024-0000000000000-00022-0000000052");
    private static final IDFactory ID_FACTORY = new IDFactory();
    private String[] mNewVarSetNames = null;
    private static Vector sObserverQueries = new Vector();

    private ComponentID() {
    }

    public ComponentID(String sID) {
        super(sID);
    }

    public static ComponentID generateID() {
        return (ComponentID)ID_FACTORY.generateObjectID();
    }

    public void updateVisibility(Visibility inVisibility) throws PersistenceManagerException, RPCException {
        this.updateVisibilityRPC(inVisibility, null);
    }

    public String[] importVariableSettings(final ComponentID fromComp) throws PersistenceManagerException, RPCException {
        ComponentID.transactRPC(new AcquireReadLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                ComponentID.this.importVariableSettingsMS(fromComp);
                return null;
            }

            public ROXMessage getLockDescription() {
                String fullName = this.toString();
                try {
                    Component c = fromComp.getByIDQuery().select();
                    fullName = c.getFullName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new ROXMessage("cdb.IMPORTING_COMPVARSETTINGS", fullName);
            }
        });
        return this.mNewVarSetNames;
    }

    public String[] importVariableSettings(final Hashtable inVarSetHash) throws PersistenceManagerException, RPCException {
        ComponentID.transactRPC(new AcquireReadLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                ComponentID.this.importVariableSettingsMS(inVarSetHash);
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("cdb.IMPORTING_COMPVARSETTINGS_FROM_HASH");
            }
        });
        return this.mNewVarSetNames;
    }

    void importVariableSettingsMS(ComponentID fromCompID) throws PersistenceManagerException {
        try {
            this.lockForUpdateMS();
            this.mNewVarSetNames = this.getByIDQuery().select().importVariableSettingsMS(fromCompID);
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    void importVariableSettingsMS(Hashtable inHash) throws PersistenceManagerException {
        try {
            this.lockForUpdateMS();
            this.mNewVarSetNames = this.getByIDQuery().select().importVariableSettingsMS(inHash);
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        super.lockForUpdateMS();
    }

    public SingleComponentQuery getByIDQuery() {
        return new SingleComponentQuery(this);
    }

    public MultiComponentQuery getAllVersionsQuery() {
        return MultiComponentQuery.allVersionsOf(this);
    }

    public MultiSystemServiceRefQuery getActiveSystemServiceQuery() {
        return MultiSystemServiceRefQuery.byComponent(this);
    }

    public int updateCategories(CategoryUpdateContext ctx) throws PersistenceManagerException, RPCException {
        return ComponentToCategoryLinkTable.DEFAULT.updateCategories(this, ctx);
    }

    protected static PersistContext transactRPC(RPCTransaction tx) throws PersistenceManagerException, RPCException {
        return ObjectID.transactRPC(tx);
    }

    public MultiComponentVariableSettingsQuery getVariableSettingsQuery() {
        return MultiComponentVariableSettingsQuery.byComp(this);
    }

    public SingleComponentVariableSettingsQuery getVariableSettingsQuery(String name) {
        return SingleComponentVariableSettingsQuery.byName(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConfigTemplateMS() throws PersistenceManagerException, RPCException {
        SingleComponentQuery query = this.getByIDQuery();
        ComponentImpl component = query.selectSummaryView().getComponent();
        if (component.getConfigTemplateIsValidated()) {
            return;
        }
        ComponentImpl componentImpl = component;
        synchronized (componentImpl) {
            component = query.select().getComponent();
            if (component.getConfigTemplateIsValidated()) {
                return;
            }
            component.validateConfigTemplateMS();
            ComponentSQLOps.DEFAULT.markConfigTemplateValidated(this);
        }
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Examining Component " + this.toString() + " for dependent objects", "persist.objectdeletion");
        }
        try {
            Component theComp;
            SystemServiceRef[] srefs;
            if (COMPONENT_SENTINEL_ID.equals(this)) {
                throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
            }
            ComponentTypeRef[] crefs = MultiComponentTypeRefQuery.byComponent(this).select();
            if (crefs != null) {
                for (int i = 0; i < crefs.length; ++i) {
                    if (inContext.objectWillBeDeletedPriorTo(crefs[i].getID(), this)) continue;
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), (UsingObject[])new ComponentTypeRef[]{crefs[i]});
                }
            }
            if ((srefs = this.getActiveSystemServiceQuery().select()) != null) {
                for (int i = 0; i < srefs.length; ++i) {
                    if (inContext.objectWillBeDeletedPriorTo(srefs[i].getID(), this)) continue;
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), (UsingObject[])new SystemServiceRef[]{srefs[i]});
                }
            }
            ComponentToComponentLinkTable ctclT = ComponentToComponentLinkTable.DEFAULT;
            Link[] links = ctclT.getByChildID(this);
            ComponentIDSet parentSet = new ComponentIDSet();
            Link.addParentIDs(parentSet, Arrays.asList(links));
            SummaryComponent[] comps = parentSet.getByIDsQuery().selectSummaryView();
            for (int i = 0; i < comps.length; ++i) {
                if (inContext.objectWillBeDeletedPriorTo(comps[i].getID(), this)) continue;
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{comps[i]});
            }
            MultiInstalledComponentQuery micq = MultiInstalledComponentQuery.byComp(this);
            InstalledComponentBean[] iComps = micq.select();
            if (iComps != null && iComps.length > 0) {
                ArrayList<SummaryHost> tmpHosts = new ArrayList<SummaryHost>();
                HashSet<String> nonDuplicateHostSet = new HashSet<String>();
                for (int i = 0; i < iComps.length; ++i) {
                    if (!nonDuplicateHostSet.add(iComps[i].getSummaryHost().getName())) continue;
                    tmpHosts.add(iComps[i].getSummaryHost());
                }
                UsingObject[] hosts = tmpHosts.toArray(new SummaryHost[tmpHosts.size()]);
                throw new ObjectInUseException(new ROXMessage("cdb.CANNOT_DELETE_INSTALLED_COMPONENT", iComps[0].getComponent().getFullName(), iComps[0].getComponent().getVersionNumber().getAsString()), hosts);
            }
            this.checkVersionedObjectInUse(inContext);
            SummaryComponent thisComp = this.getByIDQuery().selectSummaryView();
            try {
                Plugin.checkWritePermissions(thisComp);
            }
            catch (AccessControlException e) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{thisComp.getPluginID().getByIDQuery().selectSummaryView()});
            }
            FolderPermission fp = new FolderPermission(thisComp.getPath(), "write");
            try {
                AccessController.checkPermission(fp);
            }
            catch (AccessControlException e) {
                throw new ObjectNotDeletableException(fp.getMessage());
            }
            MultiAutoGenPlanQuery autoGenPlanQuery = MultiAutoGenPlanQuery.all();
            autoGenPlanQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    AutoGeneratedPlanTable t = (AutoGeneratedPlanTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(AutoGeneratedPlanTable.equals(t.ComponentID, ComponentID.this));
                }
            });
            HasObjectID[] objs = autoGenPlanQuery.selectObjects();
            for (int i = 0; i < objs.length; ++i) {
                inDependentContainer.addDependentObject(((AutoGeneratedPlan)objs[i]).getPlanID().getByIDQuery().selectSummaryView());
            }
            micq.setInstalledFilter(null);
            HasObjectID[] ics = micq.selectObjects();
            inDependentContainer.addAllDependentObjects(ics);
            ArrayList<HasObjectID> installsToKeep = new ArrayList<HasObjectID>();
            for (int i = 0; i < ics.length; ++i) {
                InstalledComponentBean icb = (InstalledComponentBean)ics[i];
                if (inContext.objectWillBeDeletedPriorTo(icb.getTaskID(), ics[i].getObjectID())) continue;
                installsToKeep.add(ics[i]);
            }
            inContext.setInstalledComponents(installsToKeep.toArray(new InstalledComponentBean[0]));
            try {
                theComp = this.getByIDQuery().select();
            }
            catch (RPCException e) {
                throw new PersistenceManagerException(e);
            }
            RsrcInfo theRsrcInfo = theComp.getLocalResource();
            if (theRsrcInfo != null && theComp.getPluginID() == null) {
                this.processResources(inContext, theRsrcInfo, inPostDependentContainer);
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    private void processResources(DeleteSessionContext context, RsrcInfo rsrc, DeleteSessionDependentContainer container) throws PersistenceManagerException, RPCException {
        int i;
        HashMap<ResourceID, RsrcInfo> orphans = new HashMap<ResourceID, RsrcInfo>();
        if (!VersionNumber.ROOT.equals(rsrc.getVersionNumber())) {
            if (this.allReferringCompsWillBeDeleted(context, rsrc, orphans)) {
                container.addDependentObject(rsrc);
            } else {
                return;
            }
        }
        RsrcInfo[] allRsrcVersions = MultiRsrcInfoQuery.allVersionsOfOne(rsrc.getResourceSpec()).select();
        for (i = 0; i < allRsrcVersions.length; ++i) {
            if (this.allReferringCompsWillBeDeleted(context, allRsrcVersions[i], orphans)) continue;
            return;
        }
        orphans.put(allRsrcVersions[i - 1].getResourceID(), allRsrcVersions[i - 1]);
        container.addAllDependentObjects(orphans.values());
    }

    private boolean allReferringCompsWillBeDeleted(DeleteSessionContext context, RsrcInfo rsrc, HashMap orphans) throws PersistenceManagerException {
        SummaryComponent[] referringComps = rsrc.getResourceID().getReferringComps();
        if (referringComps.length == 0) {
            orphans.put(rsrc.getResourceID(), rsrc);
        }
        for (int i = 0; i < referringComps.length; ++i) {
            ComponentID refCompID = referringComps[i].getID();
            if (this.equals(refCompID) || context.objectWillBeDeletedPriorTo(refCompID, this)) continue;
            return false;
        }
        return true;
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        ComponentIDSet idset = new ComponentIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        ComponentToComponentLinkTable.DEFAULT.removeByParentID(this);
        ComponentToCategoryLinkTable.DEFAULT.removeByChildID(this);
        CompTypeRefToComponentLinkTable.DEFAULT.removeByChildID(this);
        ComponentVariableSettingsSQLOps cvsT = ComponentVariableSettingsSQLOps.DEFAULT;
        Select cvses = cvsT.select(ComponentVariableSettingsSQLOps.sList(cvsT.ID), ComponentVariableSettingsSQLOps.where(cvsT.isInComp(this)));
        CompVarSettingsToComponentNameRefTable cvstc = CompVarSettingsToComponentNameRefTable.DEFAULT;
        CompVarSettingsToComponentNameRefTable.execute(CompVarSettingsToComponentNameRefTable.delete(cvstc, CompVarSettingsToComponentNameRefTable.where(CompVarSettingsToComponentNameRefTable.in((ColumnNode)cvstc.ParentID, cvses))));
        ComponentVariableSettingsSQLOps.execute(ComponentVariableSettingsSQLOps.delete(cvsT, ComponentVariableSettingsSQLOps.where(cvsT.isInComp(this))));
        ComponentToComponentNameRefTable.DEFAULT.removeByParentID(this);
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("While deleting Component " + this.toString() + ", looking for install plans to update", "persist.objectdeletion");
        }
        try {
            DeleteSessionContext dsCtx = (DeleteSessionContext)context;
            InstalledComponentBean[] ics = dsCtx.getInstalledComponents();
            for (int i = 0; i < ics.length; ++i) {
                TaskID taskID = ics[i].getTaskID();
                if (dsCtx.objectWillBeDeletedPriorTo(taskID, null)) continue;
                TaskInfo task = taskID.getByIDQuery().select();
                SubplanInfo[] subplans = task.getSubplanInfos();
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Examining installed component " + ics[i].getInstalledComponentID() + " with task " + task.getID(), "persist.objectdeletion");
                }
                HashMap<SubplanInfoID, SubplanInfo> subplansToSave = new HashMap<SubplanInfoID, SubplanInfo>();
                for (int j = 0; j < subplans.length; ++j) {
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("Examining subplan " + subplans[j].getID(), "persist.objectdeletion");
                    }
                    ComponentID[] comps = subplans[j].getComponentIDs();
                    for (int k = 0; k < comps.length; ++k) {
                        if (Logger.isDebugEnabled("persist.objectdeletion")) {
                            Logger.debug("Examining component " + comps[k], "persist.objectdeletion");
                        }
                        if (!comps[k].equals(this)) continue;
                        if (Logger.isDebugEnabled("persist.objectdeletion")) {
                            Logger.debug("Replacing component " + comps[k] + " with sentinel id in subplan " + subplans[j].getID(), "persist.objectdeletion");
                        }
                        comps[k] = COMPONENT_SENTINEL_ID;
                        subplansToSave.put(subplans[j].getID(), subplans[j]);
                    }
                }
                Iterator it = subplansToSave.values().iterator();
                while (it.hasNext()) {
                    SubplanInfo si = (SubplanInfo)it.next();
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("Saving subplan " + si.getID(), "persist.objectdeletion");
                    }
                    si.save();
                }
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
        catch (PlanExecutionException pee) {
            throw new PersistenceManagerException(pee);
        }
        super.deleteMS(context);
    }

    public boolean isCallCompatibleWith(final ComponentID otherID) throws PersistenceManagerException, RPCException {
        if (otherID == null) {
            throw new NullPointerException();
        }
        if (this.equals(otherID)) {
            return true;
        }
        BooleanResult result = (BooleanResult)ComponentID.transactRPC(new RPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                return new BooleanResult(ComponentID.this.isCallCompatibleWithMS(otherID));
            }
        });
        return result.getValue();
    }

    private boolean isCallCompatibleWithMS(ComponentID otherID) throws PersistenceManagerException {
        try {
            Component thisComp = this.getByIDQuery().select();
            Component otherComp = otherID.getByIDQuery().select();
            CallCompatibilityValidator.validate(otherComp, thisComp);
            return true;
        }
        catch (ComponentDBException e) {
            return false;
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    public void move(String name, FolderID path) throws PersistenceManagerException, RPCException, AccessControlException {
        ComponentID.move(this, name, path);
    }

    static void move(final ComponentID comp, final String name, final FolderID path) throws RPCException, PersistenceManagerException {
        if (name == null && path == null) {
            return;
        }
        ComponentID.transactRPC(new AcquireWriteLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    SummaryFolder f = path == null ? null : path.getByIDQuery().selectSummaryView();
                    ComponentID.trMoveMS(comp, name, f);
                    return null;
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("cdb.MOVING_COMPONENTS");
            }
        });
    }

    static void trMoveMS(ComponentID compId, String name, SummaryFolder path) throws PersistenceManagerException {
        if (name == null && path == null) {
            return;
        }
        try {
            SummaryComponent comp = compId.getByIDQuery().selectSummaryView();
            if (!comp.isMoveNeeded(name, path)) {
                return;
            }
            if (Logger.isDebugEnabled(ComponentID.class)) {
                Logger.debug("tr moving component " + comp.getFullName() + " to " + (path == null ? comp.getPath().getFullPathString() : path.getFullPathString()) + (name == null ? comp.getName() : name), ComponentID.class);
            }
            boolean isFolderMove = path != null && comp.getPath().equals(path.getID());
            SummaryFolder compPath = comp.getPath().getByIDQuery().selectSummaryView();
            ComponentID.validateMove(comp, name, path, isFolderMove);
            Iterator iter = sObserverQueries.iterator();
            while (iter.hasNext()) {
                MultiCompObserverQuery next = (MultiCompObserverQuery)iter.next();
                ComponentObserver[] co = next.selectCompObservers(comp.getName(), compPath);
                for (int j = 0; j < co.length; ++j) {
                    co[j].renameComponent(comp, name, path);
                }
                String updateName = name == null ? comp.getName() : name;
                SummaryFolder updatePath = path == null ? compPath : path;
                next.updateCompRefTable(comp.getName(), comp.getPath(), updateName, updatePath);
            }
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private static void validateMove(SummaryComponent comp, String name, SummaryFolder path, boolean isFolderMove) throws ComponentDBException, PersistenceManagerException, RPCException {
        if (!isFolderMove) {
            FolderID qPath;
            String qName = name == null ? comp.getName() : name;
            FolderID folderID = qPath = path == null ? comp.getPath() : path.getID();
            if (SingleComponentQuery.byName(qPath, qName, null).selectExists()) {
                throw ComponentDBException.nameCollision(comp.getFullName(), qName, qPath.getFullPathString());
            }
        }
        ComponentID.verifyPerms(comp, path, isFolderMove);
        if (path != null) {
            ComponentID.verifyFolder(comp, path);
        }
    }

    static void verifyFolder(SummaryComponent comp, SummaryFolder path) throws ComponentDBException {
        if (!ObjectUtil.equals(comp.getPluginID(), path.getPluginID())) {
            throw ComponentDBException.pluginMustMatchFolder(comp, path);
        }
    }

    static void verifyPerms(SummaryComponent comp, SummaryFolder newPath, boolean isFolderMove) throws AccessControlException {
        Plugin.checkWritePermissions(comp);
        if (!isFolderMove) {
            AccessController.checkPermission(new FolderPermission(comp.getPath(), "write"));
            if (newPath != null) {
                AccessController.checkPermission(new FolderPermission(newPath.getID(), "write"));
            }
        }
    }

    public static void registerObserverQuery(MultiCompObserverQuery query) {
        sObserverQueries.add(query);
    }

    public Comparator getDeletionComparator() {
        return new ComponentDeletionComparator();
    }

    private static final class ComponentDeletionComparator
    implements Comparator {
        private HashMap descendentsByParentID = new HashMap();

        private ComponentDeletionComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof ComponentDeletionComparator;
        }

        private HashSet findDescendents(ComponentID inID) {
            HashSet<ComponentID> descendents;
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Looking for children of " + inID, "persist.objectdeletion");
            }
            if (null == (descendents = (HashSet<ComponentID>)this.descendentsByParentID.get(inID))) {
                block7: {
                    try {
                        descendents = new HashSet<ComponentID>();
                        Link[] childLinks = ComponentToComponentLinkTable.DEFAULT.getByParentID(inID);
                        for (int i = 0; i < childLinks.length; ++i) {
                            ComponentID child = (ComponentID)childLinks[i].getChildObjectID();
                            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                                Logger.debug("Adding child " + child + " to descendents list", "persist.objectdeletion");
                            }
                            descendents.add(child);
                            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                                Logger.debug("Looking for children of " + child, "persist.objectdeletion");
                            }
                            descendents.addAll(this.findDescendents(child));
                        }
                    }
                    catch (PersistenceManagerException pme) {
                        if (!Logger.isDebugEnabled(this)) break block7;
                        Logger.debug("Trapped an exception while searching for contained components", pme, this);
                    }
                }
                this.descendentsByParentID.put(inID, descendents);
            }
            return descendents;
        }

        public int compare(Object lhs, Object rhs) {
            ComponentID id1 = (ComponentID)((HasObjectID)lhs).getObjectID();
            ComponentID id2 = (ComponentID)((HasObjectID)rhs).getObjectID();
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Comparing component " + id2 + " to component " + id1, "persist.objectdeletion");
            }
            if (id1.equals(id2)) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Component " + id1 + " is equal to component " + id2 + " (this is weird)", "persist.objectdeletion");
                }
                return 0;
            }
            HashSet childrenOfOne = this.findDescendents(id1);
            if (childrenOfOne.contains(id2)) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Component " + id2 + " is a descendent of component " + id1 + " so 1 is \"less than\" 2", "persist.objectdeletion");
                }
                return -1;
            }
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Component " + id2 + " is not a descendent of component " + id1, "persist.objectdeletion");
            }
            return 1;
        }
    }

    private static class BooleanResult
    extends PersistContext {
        private boolean mValue;

        public BooleanResult(boolean value) {
            this.mValue = value;
        }

        public boolean getValue() {
            return this.mValue;
        }
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new ComponentID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            ComponentSQLOps t = ComponentSQLOps.DEFAULT;
            SingleVersionedObjectByFullNameCache cache = new SingleVersionedObjectByFullNameCache(objectCache, t.PathID, t.Name, t.Version);
            classMap.addSingleObjectCache(cache);
            TableDependency rsrcDep = t.getInvalidateByIDDependency(t.LocalResourceID);
            rsrcDep = new PrivilegedTableDependency(rsrcDep);
            ResourceTable.DEFAULT.registerDependency(rsrcDep);
            ComponentToComponentLinkTable crt = ComponentToComponentLinkTable.DEFAULT;
            TableDependency compRefDep = crt.getInvalidateParentDependency(t);
            t.registerDependency(compRefDep);
            t.registerDependency(t.getTypeUserDependency());
            ComponentID.registerObserverQuery(CompVarSettingsObserverQuery.getInstance());
            ComponentID.registerObserverQuery(ComponentObserverQuery.getInstance());
        }
    }
}

