/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelectorList;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptorList;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;

public class ComponentDescriptor
implements RPCSerializable {
    private Component mCurrentComp;
    private Component mHolderComp;
    private ResourceSelectorList mResources;
    private VarDescriptorList mVarList = new VarDescriptorList();

    public static ComponentDescriptor create(final ComponentID compID) throws PersistenceManagerException, RPCException {
        if (compID == null) {
            throw new NullPointerException();
        }
        return ((Context)ComponentID.transactRPC((RPCTransaction)new RPCTransaction(){

            public PersistContext executeMS() throws PersistenceManagerException {
                return new Context(compID);
            }
        })).mResult;
    }

    public static ComponentDescriptor create(final String typeName) throws PersistenceManagerException, RPCException {
        return ((Context)ComponentID.transactRPC((RPCTransaction)new RPCTransaction(){

            public PersistContext executeMS() throws PersistenceManagerException {
                return new Context(typeName);
            }
        })).mResult;
    }

    private ComponentDescriptor(ComponentID compID) throws PersistenceManagerException {
        try {
            this.mCurrentComp = compID.getByIDQuery().select();
            this.init((Component)this.mCurrentComp.clone());
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    private ComponentDescriptor(String typeName) throws PersistenceManagerException {
        try {
            this.mCurrentComp = null;
            Component holder = new Component();
            ComponentType type = ComponentType.create(typeName);
            holder.setExtendsType(type);
            if (holder.isDerivedComponent()) {
                holder.setPlatform(type.getComponent().getPlatform());
            }
            this.init(holder);
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
    }

    private void init(Component holder) throws PersistenceManagerException, RPCException {
        int i;
        this.mHolderComp = holder;
        if (!this.mHolderComp.isSimpleComponent()) {
            this.mResources = new ResourceSelectorList();
            ComponentRefDecl[] compRefs = this.mHolderComp.getCompRefList(null);
            for (i = 0; i < compRefs.length; ++i) {
                this.addResource(compRefs[i]);
            }
        }
        VarDecl[] vars = this.mHolderComp.getVarList(null);
        for (i = 0; i < vars.length; ++i) {
            this.mVarList.add(new VarDescriptor(vars[i], this.mHolderComp));
        }
    }

    private ComponentDescriptor() {
    }

    public Component getCurrentComponent() {
        return this.mCurrentComp == null ? null : (Component)this.mCurrentComp.clone();
    }

    public String getFullName() {
        return this.mHolderComp.getFullName();
    }

    public void setFullName(String fullName) throws FolderDBException {
        String name;
        FolderID path;
        int sepNdx = fullName.lastIndexOf("/");
        if (sepNdx == -1) {
            path = FolderID.ROOT_FOLDER_ID;
            name = fullName;
        } else {
            try {
                path = SingleFolderQuery.byPath(fullName.substring(0, sepNdx + 1)).selectSummaryView().getID();
            }
            catch (RPCException e) {
                throw new FolderDBException(e);
            }
            catch (PersistenceManagerException e) {
                throw new FolderDBException(e);
            }
            name = fullName.substring(sepNdx + 1);
        }
        this.mHolderComp.setName(name);
        this.mHolderComp.setPath(path);
    }

    public String getName() {
        return this.mHolderComp.getName();
    }

    public void setName(String name) {
        this.mHolderComp.setName(name);
    }

    public FolderID getPath() {
        return this.mHolderComp.getPath();
    }

    public void setPath(FolderID path) {
        this.mHolderComp.setPath(path);
    }

    public ComponentType getExtendsType() {
        return this.mHolderComp.getExtendsType();
    }

    public boolean isDerivedComponent() {
        return this.mHolderComp.isDerivedComponent();
    }

    public String getLabel() {
        return this.mHolderComp.getLabel();
    }

    public void setLabel(String label) {
        this.mHolderComp.setLabel(label);
    }

    public String getDescription() {
        return this.mHolderComp.getDescription();
    }

    public void setDescription(String description) {
        this.mHolderComp.setDescription(description);
    }

    public String getInstallPath() {
        try {
            return this.mHolderComp.getInstallPath(null);
        }
        catch (ConfigGenException e) {
            throw new InternalError();
        }
    }

    public void setInstallPath(String installPath) {
        this.mHolderComp.setLocalInstallPath(installPath);
    }

    public String getPlatform() {
        return this.mHolderComp.getPlatform();
    }

    public void setPlatform(String platform) {
        this.mHolderComp.setPlatform(platform);
    }

    public boolean isSimpleComponent() {
        return this.mHolderComp.isSimpleComponent();
    }

    public boolean isReadOnlyResourceList() {
        if (this.isSimpleComponent()) {
            return true;
        }
        if (!this.isDerivedComponent()) {
            return false;
        }
        Component base = this.mHolderComp.getBaseComponent();
        return Modifier.FINAL.equals(base.getCompRefListModifier());
    }

    public ComponentType getResourceListType() {
        return this.mHolderComp.getCompRefListType();
    }

    public ResourceSelectorList getResourceSelectors() {
        return this.mResources;
    }

    public ResourceSelector addResource(ComponentID compID) throws PersistenceManagerException, RPCException {
        if (this.isSimpleComponent()) {
            throw new IllegalArgumentException("simple component");
        }
        if (this.isReadOnlyResourceList()) {
            throw new IllegalArgumentException("read only list");
        }
        ResourceSelector result = new ResourceSelector(compID, this.mHolderComp);
        this.mResources.add(result);
        return result;
    }

    private ResourceSelector addResource(ComponentRefDecl compRef) throws PersistenceManagerException, RPCException {
        ResourceSelector result = new ResourceSelector(compRef, this.mHolderComp);
        this.mResources.add(result);
        return result;
    }

    public VarDescriptorList getVarList() {
        return this.mVarList;
    }

    public Component generateComponent() throws ComponentDBException {
        int i;
        Component result;
        if (this.mCurrentComp == null) {
            result = new Component();
            result.setExtendsType(this.getExtendsType());
        } else {
            result = (Component)this.mCurrentComp.clone();
        }
        result.setPath(this.getPath());
        result.setName(this.getName());
        result.setLabel(this.getLabel());
        result.setDescription(this.getDescription());
        result.setPlatform(this.getPlatform());
        if (this.mHolderComp.getLocalInstallPath() != null) {
            result.setLocalInstallPath(this.getInstallPath());
        }
        result.setVisibility(Visibility.VISIBLE);
        if (!this.isSimpleComponent()) {
            int numCompRefs = this.mResources.size();
            result.setLocalCompRefList(null);
            for (i = 0; i < numCompRefs; ++i) {
                ComponentRefDecl compRef = this.mResources.getSelector(i).generateComponentRefDecl();
                if (compRef == null || result.addLocalCompRef(compRef)) continue;
                throw ComponentDBException.duplicateCompRef(compRef.getName());
            }
        }
        result.setLocalVarList(null);
        int numVars = this.mVarList.size();
        for (i = 0; i < numVars; ++i) {
            VarDecl var = this.mVarList.getVar(i).generateVarDecl();
            if (var == null || result.addLocalVar(var)) continue;
            throw ComponentDBException.duplicateCompVar(var.getName());
        }
        return result;
    }

    private static class Context
    extends PersistContext {
        ComponentDescriptor mResult;

        private Context(ComponentID compID) throws PersistenceManagerException {
            this.mResult = new ComponentDescriptor(compID);
        }

        private Context(String typeName) throws PersistenceManagerException {
            this.mResult = new ComponentDescriptor(typeName);
        }
    }
}

