/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallScopeBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMember;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ElementDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.Messages;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.enum.Enum;

public class ComponentDBException
extends PersistenceManagerException
implements Messages {
    protected ComponentDBException() {
    }

    public ComponentDBException(Throwable t) {
        super(t);
    }

    public ComponentDBException(ROXMessage message, Throwable t, int wrapMode) {
        super(message, t, wrapMode);
    }

    public ComponentDBException(ROXMessage message, Throwable t) {
        super(message, t);
    }

    public ComponentDBException(ROXMessage message) {
        super(message);
    }

    static ComponentDBException configValidationError(ConfigGenException e) {
        return new ComponentDBException(e);
    }

    static ComponentDBException invalidResourceName(String resName, Throwable detail) {
        return ComponentDBException.newValidationError("cdb.BAD_RES_NAME", resName, detail);
    }

    static ComponentDBException invalidRsrcPermissions(SummaryComponent comp, String resPerms) {
        return ComponentDBException.newValidationError("cdb.BAD_RES_PERMS", comp.getFullName(), resPerms);
    }

    static ComponentDBException invalidRsrcDeployMode(SummaryComponent comp, String deployMode) {
        return ComponentDBException.newValidationError("cdb.BAD_RES_DEPLOY_MODE", comp.getFullName(), deployMode);
    }

    static ComponentDBException invalidRsrcDiffDeploy(SummaryComponent comp, String diffDeploy) {
        return ComponentDBException.newValidationError("cdb.BAD_RES_DIFF_DEPLOY", comp.getFullName(), diffDeploy);
    }

    static ComponentDBException invalidComponentName(String name) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMP_NAME", name);
    }

    static ComponentDBException invalidComponentPath(String path) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMP_PATH", path);
    }

    static ComponentDBException invalidMemberName(String name, ComponentMember member) {
        return ComponentDBException.newValidationError("cdb.INVALID_MEMBER_NAME", name, member.getElementDescription());
    }

    static ComponentDBException compNameMustMatchRoot(String rootName) {
        return ComponentDBException.newValidationError("cdb.COMP_ROOT_NAME_ERR", rootName);
    }

    static ComponentDBException invalidCompVars(ConfigGenException e) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMP_VARS", e);
    }

    static ComponentDBException invalidVarsName(String name) {
        return ComponentDBException.newValidationError("cdb.INVALID_VARS_NAME", name);
    }

    static ComponentDBException invalidVarsVarName(String name) {
        return ComponentDBException.newValidationError("cdb.INVALID_VARS_VAR_NAME", name);
    }

    static ComponentDBException invalidVarsComp(SummaryComponent comp) {
        return ComponentDBException.newValidationError("cdb.COMP_CANT_CONTAIN_VARS", comp.getFullName());
    }

    static ComponentDBException invalidHashForVarSetImport() {
        return ComponentDBException.newValidationError("cdb.INVALID_IMPORTED_COMPVARSETTINGS");
    }

    static ComponentDBException readOnlyVarsVar(String name) {
        return ComponentDBException.newValidationError("cdb.READ_ONLY_VARS_VAR", name);
    }

    static ComponentDBException invalidVarsVars(ConfigGenException e) {
        return ComponentDBException.newValidationError("cdb.INVALID_VARS_VARS", e);
    }

    static ComponentDBException pluginMustMatchRoot() {
        return ComponentDBException.newValidationError("cdb.ROOT_PLUGIN_ERR");
    }

    static ComponentDBException pluginMustMatchFolder(SummaryComponent comp, SummaryFolder path) {
        return ComponentDBException.newValidationError("cdb.PLUGIN_FOLDER_ERR", comp.getName(), path.getFullPathString());
    }

    static ComponentDBException invalidPlatform(String name, String baseName) {
        if (name == null) {
            name = SystemPluginConstants.ALL_PLATFORMS_NAME;
        }
        if (baseName == null) {
            baseName = SystemPluginConstants.ALL_PLATFORMS_NAME;
        }
        return ComponentDBException.newValidationError("cdb.INVALID_PLATFORM", name, baseName);
    }

    static ComponentDBException unknownPlatform(String name) {
        return ComponentDBException.newValidationError("cdb.UNKNOWN_PLATFORM", name);
    }

    static ComponentDBException invalidLimitToHostSet(String baseName) {
        return ComponentDBException.newValidationError("cdb.INVALID_LIMIT_TO_HOST_SET", baseName);
    }

    static ComponentDBException unknownLimitToHostSet(String name) {
        return ComponentDBException.newValidationError("cdb.UNKNOWN_LIMIT_TO_HOST_SET", name);
    }

    static ComponentDBException invalidServiceRefName(String name) {
        return ComponentDBException.newValidationError("cdb.INVALID_SERVICE_REF_NAME", name);
    }

    static ComponentDBException invalidServiceRefDescription(String desc) {
        return ComponentDBException.newValidationError("cdb.INVALID_SERVICE_REF_DESC", desc);
    }

    static ComponentDBException invalidServiceRefComponentRef(InstalledComponentRef ref) {
        return ComponentDBException.newValidationError("cdb.INVALID_SERVICE_REF_COMPONENT_REF", String.valueOf(ref));
    }

    static ComponentDBException emptyServiceRefComponentRef() {
        return ComponentDBException.newValidationError("cdb.EMPTY_SERVICE_REF_COMPONENT_REF");
    }

    static ComponentDBException notSystemService() {
        return ComponentDBException.newValidationError("cdb.SERVICE_REF_NO_SYSTEM_SERVICE");
    }

    static ComponentDBException unexpectedRPCError(RPCException e) {
        return new ComponentDBException(e);
    }

    static ComponentDBException unresolvedVarError(String typeName, ConfigGenException e) {
        return ComponentDBException.newValidationError("cdb.UNRESOLVED_VAR_ERR", typeName, (Throwable)e);
    }

    static ComponentDBException unexpectedPersistenceManagerError(PersistenceManagerException e) {
        return new ComponentDBException(e);
    }

    static ComponentDBException duplicateCompVar(String name) {
        return ComponentDBException.newValidationError("cdb.DUPLICATE_COMP_VAR", name);
    }

    static ComponentDBException duplicateCompRef(String name) {
        return ComponentDBException.newValidationError("cdb.DUPLICATE_COMP_REF", name);
    }

    static ComponentDBException invalidComponentTypeRefName(String name) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMPONENT_TYPE_REF_NAME", name);
    }

    static ComponentDBException invalidComponentTypeRefGroup(String group) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMPONENT_TYPE_REF_GROUP", group);
    }

    static ComponentDBException invalidComponentTypeRefOrder(String order) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMPONENT_TYPE_REF_ORDER", order);
    }

    static ComponentDBException invalidComponentTypeRefDescription(String desc) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMPONENT_TYPE_REF_DESC", desc);
    }

    static ComponentDBException invalidComponentTypeRefComponentRef(ComponentRef ref) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMPONENT_TYPE_REF_COMPONENT_REF", String.valueOf(ref));
    }

    static ComponentDBException emptyComponentTypeRefComponentRef() {
        return ComponentDBException.newValidationError("cdb.EMPTY_COMPONENT_TYPE_REF_COMPONENT_REF");
    }

    static ComponentDBException invalidComponentTypeRefIndentLevel(int indentLevel) {
        return ComponentDBException.newValidationError("cdb.INVALID_COMPONENT_TYPE_REF_INDENT_LEVEL", new Integer(indentLevel).toString());
    }

    static ComponentDBException noComponentType(ComponentRef ref) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_TYPE_REF_NO_COMPONENT_TYPE", String.valueOf(ref));
    }

    static ComponentDBException finalCompType(SummaryComponent comp) {
        return ComponentDBException.newValidationError("cdb.COMP_TYPE_REF_FINAL_COMP", comp.getFullName());
    }

    static ComponentDBException installPathInDerivedComp() {
        return ComponentDBException.newValidationError("cdb.INSTALL_PATH_IN_DERIVED_COMP");
    }

    static ComponentDBException noInstallPathInNonDerivedComp() {
        return ComponentDBException.newValidationError("cdb.NO_INSTALL_PATH_IN_NON_DERIVED_COMP");
    }

    static ComponentDBException abstractNotOverridden(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.ABSTRACT_MEMBER_NOT_OVERRIDDEN", member);
    }

    static ComponentDBException nonAbstractComp(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.ABSTRACT_MEMBER_NON_ABSTRACT_COMP", member);
    }

    static ComponentDBException privateAbstractMember(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.PRIVATE_ABSTRACT_MEMBER", member);
    }

    static ComponentDBException finalOverride(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.FINAL_MEMBER_OVERRIDDEN", member);
    }

    static ComponentDBException moreRestrictiveAccess(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.OVERRIDE_WITH_MORE_RESTRICTIVE_ACCESS", member);
    }

    static ComponentDBException nonEmptyAbstractVar(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.NON_EMPTY_ABSTRACT_VAR", member);
    }

    static ComponentDBException emptyNonAbstractVar(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.EMPTY_NON_ABSTRACT_VAR", member);
    }

    static ComponentDBException localSimpleBaseComposite() {
        return ComponentDBException.newValidationError("cdb.LOCAL_SIMPLE_BASE_COMPOSITE");
    }

    static ComponentDBException localCompositeBaseSimple() {
        return ComponentDBException.newValidationError("cdb.LOCAL_COMPOSITE_BASE_SIMPLE");
    }

    static ComponentDBException installSpecInDerivedComp() {
        return ComponentDBException.newValidationError("cdb.INSTALL_SPEC_IN_DERIVED_COMP");
    }

    static ComponentDBException noInstallSpecInRootComp() {
        return ComponentDBException.newValidationError("cdb.NO_INSTALL_SPEC_IN_ROOT_COMP");
    }

    static ComponentDBException nonEmptyAbstractRsrcRef() {
        return ComponentDBException.newValidationError("cdb.NON_EMPTY_ABSTRACT_RSRC_REF");
    }

    static ComponentDBException emptyNonAbstractRsrcRef() {
        return ComponentDBException.newValidationError("cdb.EMPTY_NON_ABSTRACT_RSRC_REF");
    }

    static ComponentDBException abstractRsrcNonAbstractComp() {
        return ComponentDBException.newValidationError("cdb.ABSTRACT_RSRC_NON_ABSTRACT_COMP");
    }

    static ComponentDBException finalRsrcOverride() {
        return ComponentDBException.newValidationError("cdb.FINAL_RSRC_OVERRIDDEN");
    }

    static ComponentDBException abstractRsrcNotOverridden() {
        return ComponentDBException.newValidationError("cdb.ABSTRACT_RSRC_NOT_OVERRIDDEN");
    }

    static ComponentDBException overrideCompRefListNonFinal() {
        return ComponentDBException.newValidationError("cdb.OVERRIDE_COMP_REF_LIST_NON_FINAL");
    }

    static ComponentDBException incompatibleCompRefListType() {
        return ComponentDBException.newValidationError("cdb.INVALID_COMP_REF_LIST_TYPE");
    }

    static ComponentDBException newLocalCompRefInFinalList(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.FINAL_COMP_REF_LIST_MOD", member);
    }

    static ComponentDBException invalidCompRefInstallModeOverride(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.INVALID_COMP_REF_INSTALL_MODE_OVERRIDE", member);
    }

    static ComponentDBException invalidCompRefTypeOverride(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.INVALID_COMP_REF_TYPE_OVERRIDE", member);
    }

    static ComponentDBException invalidCompRefListTypeOverride(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.INVALID_COMP_REF_LIST_TYPE_OVERRIDE", member);
    }

    static ComponentDBException nonEmptyAbstractCompRef(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.NON_EMPTY_ABSTRACT_COMP_REF", member);
    }

    static ComponentDBException emptyNonAbstractCompRef(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.EMPTY_NON_ABSTRACT_COMP_REF", member);
    }

    static ComponentDBException nonPublicToplevelCompRef(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.NON_PUBLIC_TOPLEVEL_COMP_REF", member);
    }

    static ComponentDBException inaccessibleCompRef(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.INACCESSIBLE_COMP_REF", member);
    }

    static ComponentDBException abstractCompRef(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.ABSTRACT_COMP_REF", member);
    }

    static ComponentDBException incompatibleReferencedCompType(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.INCOMPATIBLE_REFERENCED_COMP_TYPE", member);
    }

    static ComponentDBException circularCompRef(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.CIRCULAR_COMP_REF", member);
    }

    static ComponentDBException untypedCompRefOverrideArgs(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.UNTYPED_COMP_REF_OVERRIDE_ARGS", member);
    }

    static ComponentDBException unknownCompRefOverrideArg(String argName, ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.UNKNOWN_COMP_REF_OVERRIDE_ARG", argName, member);
    }

    static ComponentDBException finalCompRefOverrideArg(String argName, ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.FINAL_COMP_REF_OVERRIDE_ARG", argName, member);
    }

    static ComponentDBException inaccessibleCompRefOverrideArg(String argName, ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.INACCESSIBLE_COMP_REF_OVERRIDE_ARG", argName, member);
    }

    static ComponentDBException baseCompRefIncompatibleReferencedComp(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.BASE_COMP_REF_INCOMPATIBLE_REFERENCED_COMP", member);
    }

    static ComponentDBException baseCompRefIncompatibleDeclaredType(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.BASE_COMP_REF_INCOMPATIBLE_DECLARED_TYPE", member);
    }

    static ComponentDBException inaccessibleExtendsType() {
        return ComponentDBException.newValidationError("cdb.INACCESSIBLE_EXTENDS_TYPE");
    }

    static ComponentDBException inaccessibleCompRefListType() {
        return ComponentDBException.newValidationError("cdb.INACCESSIBLE_COMP_REF_LIST_TYPE");
    }

    static ComponentDBException inaccessibleCompRefType(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.INACCESSIBLE_COMP_REF_TYPE", member);
    }

    static ComponentDBException noAccessibleInstallBlocks() {
        return ComponentDBException.newValidationError("cdb.NO_ACCESSIBLE_INSTALL_BLOCKS");
    }

    static ComponentDBException noAccessibleUninstallBlocks() {
        return ComponentDBException.newValidationError("cdb.NO_ACCESSIBLE_UNINSTALL_BLOCKS");
    }

    static ComponentDBException nonEmptyAbstractBlock(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.NON_EMPTY_ABSTRACT_BLOCK", member);
    }

    static ComponentDBException newRequiredParam(String paramName, ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.NEW_REQUIRED_PARAM", paramName, member);
    }

    static ComponentDBException optionalToRequiredParam(String paramName, ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.OPTIONAL_TO_REQUIRED_PARAM", paramName, member);
    }

    static ComponentDBException nonEmptyAbstractSnapshot(ComponentMemberBase member) {
        return ComponentDBException.newError("cdb.NON_EMPTY_ABSTRACT_SNAPSHOT", member);
    }

    static ComponentDBException invalidTargetRefOverride(String compName, String typeName) {
        return ComponentDBException.newValidationError("cdb.INVALID_TARGET_REF_OVERRIDE", compName, typeName);
    }

    static ComponentDBException nestedTargetableRef(ComponentMemberBase member, String contName, String refdName) {
        return ComponentDBException.newError("cdb.NESTED_TARGETABLE_REF", contName, refdName, member);
    }

    static ComponentDBException nameCollision(String oldFullName, String newName, String newFolder) {
        return ComponentDBException.newValidationError("cdb.NAME_COLLISION", oldFullName, newName, newFolder);
    }

    static ComponentDBException unsupportedHostset(String hsName, String compName) {
        return ComponentDBException.newValidationError("cdb.UNSUPPORTED_HOSTSET", hsName, compName);
    }

    static ComponentDBException invalidTgtRefConnType(SummaryComponent comp, String connType) {
        return ComponentDBException.newValidationError("cdb.INVALID_TGTREF_CONNTYPE", comp.getFullName(), connType);
    }

    static ComponentDBException requiredStepsForReturnsAttr(String blockName, String blockType) {
        return ComponentDBException.newValidationError("cdb.REQUIRES_STEPS_FOR_RETURNS", blockType, blockName);
    }

    static ComponentDBException plandbExecStepError(PlanDBException e) {
        return new ComponentDBException(e);
    }

    static String displayName(ElementDescriptor element) {
        if (element == null) {
            return String.valueOf(element);
        }
        return element.getName();
    }

    static String displayName(Component comp) {
        if (comp == null) {
            return String.valueOf(comp);
        }
        return comp.getFullName();
    }

    static String displayName(Enum enum_) {
        return String.valueOf(enum_);
    }

    static String displayName(String string) {
        return String.valueOf(string);
    }

    static String displayName(ComponentType componentType) {
        if (componentType == null) {
            return String.valueOf(componentType);
        }
        return componentType.getTypeName();
    }

    static String displayName(PromptParam param) {
        if (param == null) {
            return String.valueOf(param);
        }
        return param.getName();
    }

    static String displayName(FolderID folder) {
        if (folder == null) {
            return String.valueOf(folder);
        }
        return folder.getFullPathString();
    }

    static String displayName(ResourceDefinition resourceDefinition) {
        if (resourceDefinition == null) {
            return String.valueOf(resourceDefinition);
        }
        return resourceDefinition.getInstallName();
    }

    static String displayName(VersionNumber versionNumber) {
        if (versionNumber == null) {
            return String.valueOf(versionNumber);
        }
        return versionNumber.getAsString();
    }

    static ComponentDBException authorChanged(Component component, String oldAuthor, String newAuthor) {
        return ComponentDBException.newValidationError("cdb.AUTHOR_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldAuthor), ComponentDBException.displayName(newAuthor));
    }

    static ComponentDBException nonPrivateBlockAdded(ComponentMember addedBlock, Component component, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.NON_PRIVATE_BLOCK_ADDED", ComponentDBException.displayName(component), addedBlock.getElementDescription(), ComponentDBException.displayName(addedBlock), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException finalBlockAdded(ComponentMember addedBlock, Component baseComponent, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.FINAL_BLOCK_ADDED", ComponentDBException.displayName(baseComponent), addedBlock.getElementDescription(), ComponentDBException.displayName(addedBlock), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException blockAddedWithInvalidAccess(ComponentMember addedBlock, Component baseComponent, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.BLOCK_ADDED_WITH_INVALID_ACCESS", ComponentDBException.displayName(baseComponent), addedBlock.getElementDescription(), ComponentDBException.displayName(addedBlock), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException abstractBlockAdded(ComponentMember addedBlock, Component component, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.ABSTRACT_BLOCK_ADDED", ComponentDBException.displayName(component), addedBlock.getElementDescription(), ComponentDBException.displayName(addedBlock), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException componentNameChanged(Component oldComponent, Component newComponent) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_NAME_CHANGED", ComponentDBException.displayName(oldComponent), ComponentDBException.displayName(newComponent));
    }

    static ComponentDBException componentReferenceAdded(Component component, ComponentRefDecl compRef, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_REFERENCE_ADDED", ComponentDBException.displayName(component), ComponentDBException.displayName(compRef), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException abstractComponentRefAdded(Component component, ComponentRefDecl compRef, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.ABSTRACT_COMPONENT_REF_ADDED", ComponentDBException.displayName(component), ComponentDBException.displayName(compRef), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException componentReferenceRemovedOrRenamed(Component component, ComponentRefDecl compRef) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_REFERENCE_REMOVED_OR_RENAMED", ComponentDBException.displayName(component), ComponentDBException.displayName(compRef));
    }

    static ComponentDBException descriptionChanged(Component component, String oldDescription, String newDescription) {
        return ComponentDBException.newValidationError("cdb.DESCRIPTION_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldDescription), ComponentDBException.displayName(newDescription));
    }

    static ComponentDBException extendsTypeChanged(ElementDescriptor extendingObject, ComponentType oldType, ComponentType newType) {
        return ComponentDBException.newValidationError("cdb.EXTENDS_TYPE_CHANGED", extendingObject.getElementDescription(), extendingObject.getName(), ComponentDBException.displayName(oldType), ComponentDBException.displayName(newType));
    }

    static ComponentDBException finalDefaultValueChanged(VarDecl var, Component component, String oldValue, String newValue) {
        return ComponentDBException.newValidationError("cdb.FINAL_DEFAULT_VALUE_CHANGED", ComponentDBException.displayName(var), ComponentDBException.displayName(component), ComponentDBException.displayName(oldValue), ComponentDBException.displayName(newValue));
    }

    static ComponentDBException returnsChanged(Component component, NamedBlock oldBlock, boolean oldReturns, boolean newReturns) {
        return ComponentDBException.newValidationError("cdb.RETURNS_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldBlock), new Boolean(oldReturns).toString(), new Boolean(newReturns).toString());
    }

    static ComponentDBException hostSetChanged(Component component, String oldHostSet, String newHostSet) {
        return ComponentDBException.newValidationError("cdb.HOST_SET_CHANGED", ComponentDBException.displayName(component), oldHostSet, newHostSet);
    }

    static ComponentDBException installModeChanged(ComponentRefDecl compRef, Component component, InstallMode oldInstallMode, InstallMode newInstallMode) {
        return ComponentDBException.newValidationError("cdb.INSTALL_MODE_CHANGED", ComponentDBException.displayName(compRef), ComponentDBException.displayName(component), ComponentDBException.displayName(oldInstallMode), ComponentDBException.displayName(newInstallMode));
    }

    static ComponentDBException labelChanged(Component component, String oldLabel, String newLabel) {
        return ComponentDBException.newValidationError("cdb.LABEL_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldLabel), ComponentDBException.displayName(newLabel));
    }

    static ComponentDBException componentModifierChanged(Component component, Modifier oldModifier, Modifier newModifier) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_MODIFIER_CHANGED", component.getName(), ComponentDBException.displayName(oldModifier), ComponentDBException.displayName(newModifier));
    }

    static ComponentDBException componentRefModifierChanged(ComponentRefDecl componentRef, Modifier oldModifier, Modifier newModifier) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_REF_MODIFIER_CHANGED", componentRef.getName(), ComponentDBException.displayName(oldModifier), ComponentDBException.displayName(newModifier));
    }

    static ComponentDBException componentRefListModifierChanged(Component component, Modifier oldModifier, Modifier newModifier) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_REF_LIST_MODIFIER_CHANGED", component.getName(), ComponentDBException.displayName(oldModifier), ComponentDBException.displayName(newModifier));
    }

    static ComponentDBException resourceModifierChanged(Component component, Modifier oldModifier, Modifier newModifier) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_MODIFIER_CHANGED", component.getName(), ComponentDBException.displayName(oldModifier), ComponentDBException.displayName(newModifier));
    }

    static ComponentDBException blockModifierChanged(CallScopeBlock block, Component component, Modifier oldModifier, Modifier newModifier) {
        return ComponentDBException.newValidationError("cdb.BLOCK_MODIFIER_CHANGED", block.getName(), component.getName(), ComponentDBException.displayName(oldModifier), ComponentDBException.displayName(newModifier));
    }

    static ComponentDBException varModifierChanged(VarDecl var, Component component, Modifier oldModifier, Modifier newModifier) {
        return ComponentDBException.newValidationError("cdb.VAR_MODIFIER_CHANGED", var.getName(), component.getName(), ComponentDBException.displayName(oldModifier), ComponentDBException.displayName(newModifier));
    }

    static ComponentDBException componentAccessChanged(Component component, AccessMode oldAccess, AccessMode newAccess) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_ACCESS_CHANGED", component.getName(), ComponentDBException.displayName(oldAccess), ComponentDBException.displayName(newAccess));
    }

    static ComponentDBException blockAccessChanged(CallScopeBlock block, Component component, AccessMode oldAccess, AccessMode newAccess) {
        return ComponentDBException.newValidationError("cdb.BLOCK_ACCESS_CHANGED", block.getName(), component.getName(), ComponentDBException.displayName(oldAccess), ComponentDBException.displayName(newAccess));
    }

    static ComponentDBException blockAccessChangedMoreAccessibleThanDerived(CallScopeBlock block, Component component, AccessMode oldAccess, AccessMode newAccess, Component derived) {
        return ComponentDBException.newValidationError("cdb.BLOCK_ACCESS_CHANGED_MORE_ACCESSIBLE_THAN_DERIVED", block.getElementDescription(), block.getName(), component.getName(), ComponentDBException.displayName(oldAccess), ComponentDBException.displayName(newAccess), derived.getName());
    }

    static ComponentDBException blockAccessChangedBecameAccessible(CallScopeBlock block, Component component, AccessMode oldAccess, AccessMode newAccess, Component derived) {
        return ComponentDBException.newValidationError("cdb.BLOCK_ACCESS_CHANGED_BECAME_ACCESSIBLE", block.getElementDescription(), block.getName(), component.getName(), ComponentDBException.displayName(oldAccess), ComponentDBException.displayName(newAccess), derived.getName());
    }

    static ComponentDBException varAccessChanged(VarDecl var, Component component, AccessMode oldAccess, AccessMode newAccess) {
        return ComponentDBException.newValidationError("cdb.VAR_ACCESS_CHANGED", var.getName(), component.getName(), ComponentDBException.displayName(oldAccess), ComponentDBException.displayName(newAccess));
    }

    static ComponentDBException varAccessChangedBecameAccessible(VarDecl var, Component component, AccessMode oldAccess, AccessMode newAccess, Component derived) {
        return ComponentDBException.newValidationError("cdb.VAR_ACCESS_CHANGED_BECAME_ACCESSIBLE", var.getName(), component.getName(), ComponentDBException.displayName(oldAccess), ComponentDBException.displayName(newAccess), derived.getName());
    }

    static ComponentDBException varAccessChangedMoreAccessibleThanDerived(VarDecl var, Component component, AccessMode oldAccess, AccessMode newAccess, Component derived) {
        return ComponentDBException.newValidationError("cdb.VAR_ACCESS_CHANGED_MORE_ACCESSIBLE_THAN_DERIVED", var.getName(), component.getName(), ComponentDBException.displayName(oldAccess), ComponentDBException.displayName(newAccess), derived.getName());
    }

    static ComponentDBException variableOrderChanged(VarDecl var, Component component) {
        return ComponentDBException.newValidationError("cdb.VAR_ORDER_CHANGED", var.getName(), component.getName());
    }

    static ComponentDBException oldExtendsTypeMissing(ElementDescriptor extendingElement, ComponentType oldExtendsType) {
        return ComponentDBException.newValidationError("cdb.OLD_EXTENDS_TYPE_MISSING", extendingElement.getElementDescription(), extendingElement.getName(), ComponentDBException.displayName(oldExtendsType));
    }

    static ComponentDBException newExtendsTypeMissing(ElementDescriptor extendingElement, ComponentType newExtendsType) {
        return ComponentDBException.newValidationError("cdb.NEW_EXTENDS_TYPE_MISSING", extendingElement.getElementDescription(), extendingElement.getName(), ComponentDBException.displayName(newExtendsType));
    }

    static ComponentDBException newExtendsTypeNotInstanceOfOld(ComponentType newType, ElementDescriptor element, ComponentType oldType) {
        return ComponentDBException.newValidationError("cdb.NEW_EXTENDS_TYPE_NOT_INSTANCE_OF_OLD", ComponentDBException.displayName(newType), element.getElementDescription(), element.getName(), ComponentDBException.displayName(oldType));
    }

    static ComponentDBException newPlatformMoreSpecificThanOld(String newPlatform, Component component, String oldPlatform) {
        return ComponentDBException.newValidationError("cdb.NEW_PLATFORM_MORE_SPECIFIC_THAN_OLD", ComponentDBException.displayName(newPlatform), ComponentDBException.displayName(component), ComponentDBException.displayName(oldPlatform));
    }

    static ComponentDBException newPlatformUnrelatedToOld(String newPlatform, Component component, String oldPlatform) {
        return ComponentDBException.newValidationError("cdb.NEW_PLATFORM_UNRELATED_TO_OLD", ComponentDBException.displayName(newPlatform), ComponentDBException.displayName(component), ComponentDBException.displayName(oldPlatform));
    }

    static ComponentDBException nonPrivateBlockRemoved(ComponentMember removedBlock, Component component) {
        return ComponentDBException.newValidationError("cdb.NON_PRIVATE_BLOCK_REMOVED", ComponentDBException.displayName(removedBlock), ComponentDBException.displayName(component));
    }

    static ComponentDBException nonPrivateVariableRemoved(VarDecl removedVariable, Component component) {
        return ComponentDBException.newValidationError("cdb.NON_PRIVATE_VARIABLE_REMOVED", ComponentDBException.displayName(removedVariable), ComponentDBException.displayName(component));
    }

    static ComponentDBException requiredParameterAdded(PromptParam addedParameter, CallScopeBlock block, Component base, Component derived) {
        if (derived != null) {
            return ComponentDBException.newValidationError("cdb.REQUIRED_PARAMETER_ADDED_DERIVED", ComponentDBException.displayName(addedParameter), block.getElementDescription(), ComponentDBException.displayName(block), ComponentDBException.displayName(base), ComponentDBException.displayName(derived));
        }
        return ComponentDBException.newValidationError("cdb.REQUIRED_PARAMETER_ADDED", ComponentDBException.displayName(addedParameter), block.getElementDescription(), ComponentDBException.displayName(block), ComponentDBException.displayName(base));
    }

    static ComponentDBException parameterChangedFromOptionalToRequired(PromptParam oldParam, CallScopeBlock block, Component base, Component derived) {
        if (derived != null) {
            return ComponentDBException.newValidationError("cdb.PARAMETER_CHANGED_FROM_OPTIONAL_TO_REQUIRED_DERIVED", ComponentDBException.displayName(oldParam), block.getElementDescription(), ComponentDBException.displayName(block), ComponentDBException.displayName(base), ComponentDBException.displayName(derived));
        }
        return ComponentDBException.newValidationError("cdb.PARAMETER_CHANGED_FROM_OPTIONAL_TO_REQUIRED", ComponentDBException.displayName(oldParam), block.getElementDescription(), ComponentDBException.displayName(block), ComponentDBException.displayName(base));
    }

    static ComponentDBException pathChanged(Component oldComponent, FolderID oldPath, FolderID newPath) {
        return ComponentDBException.newValidationError("cdb.PATH_CHANGED", ComponentDBException.displayName(oldComponent), ComponentDBException.displayName(oldPath), ComponentDBException.displayName(newPath));
    }

    static ComponentDBException resourceAdded(ResourceDefinition addedResourceDefinition, Component component) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_ADDED", ComponentDBException.displayName(addedResourceDefinition), ComponentDBException.displayName(component));
    }

    static ComponentDBException resourceInstallGroupChanged(Component component, String oldInstallGroup, String newInstallGroup) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_INSTALL_GROUP_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldInstallGroup), ComponentDBException.displayName(newInstallGroup));
    }

    static ComponentDBException resourceInstallNameChanged(Component component, String oldInstallName, String newInstallName) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_INSTALL_NAME_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldInstallName), ComponentDBException.displayName(newInstallName));
    }

    static ComponentDBException resourceInstallPathChanged(Component component, String oldInstallPath, String newInstallPath) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_INSTALL_PATH_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldInstallPath), ComponentDBException.displayName(newInstallPath));
    }

    static ComponentDBException resourceInstallUserChanged(Component component, String oldInstallUser, String newInstallUser) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_INSTALL_USER_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldInstallUser), ComponentDBException.displayName(newInstallUser));
    }

    static ComponentDBException resourceNameChanged(Component component, String oldResourceName, String newResourceName) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_NAME_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldResourceName), ComponentDBException.displayName(newResourceName));
    }

    static ComponentDBException resourceRemoved(ResourceDefinition removedResourceDefinition, Component component) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_REMOVED", ComponentDBException.displayName(removedResourceDefinition), ComponentDBException.displayName(component));
    }

    static ComponentDBException resourceVersionChanged(Component component, VersionNumber oldResourceVersion, VersionNumber newResourceVersion) {
        return ComponentDBException.newValidationError("cdb.RESOURCE_VERSION_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldResourceVersion), ComponentDBException.displayName(newResourceVersion));
    }

    static ComponentDBException variableAdded(VarDecl addedVariable, Component component, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.VARIABLE_ADDED", ComponentDBException.displayName(component), ComponentDBException.displayName(addedVariable), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException abstractVariableAdded(VarDecl addedVariable, Component component, Component derivedComponent) {
        return ComponentDBException.newValidationError("cdb.ABSTRACT_VARIABLE_ADDED", ComponentDBException.displayName(component), ComponentDBException.displayName(addedVariable), ComponentDBException.displayName(derivedComponent));
    }

    static ComponentDBException softwareVendorChanged(Component component, String oldSoftwareVendor, String newSoftwareVendor) {
        return ComponentDBException.newValidationError("cdb.SOFTWARE_VENDOR_CHANGED", ComponentDBException.displayName(component), ComponentDBException.displayName(oldSoftwareVendor), ComponentDBException.displayName(newSoftwareVendor));
    }

    static ComponentDBException argumentAdded(String argName, ComponentRefDecl componentRef, Component component) {
        return ComponentDBException.newValidationError("cdb.ARGUMENT_ADDED", ComponentDBException.displayName(argName), ComponentDBException.displayName(componentRef), ComponentDBException.displayName(component));
    }

    static ComponentDBException argumentRemoved(String argName, ComponentRefDecl componentRef, Component component) {
        return ComponentDBException.newValidationError("cdb.ARGUMENT_REMOVED", ComponentDBException.displayName(argName), ComponentDBException.displayName(componentRef), ComponentDBException.displayName(component));
    }

    static ComponentDBException argumentChanged(String argName, ComponentRefDecl componentRef, Component component, String oldValue, String newValue) {
        return ComponentDBException.newValidationError("cdb.ARGUMENT_CHANGED", ComponentDBException.displayName(argName), ComponentDBException.displayName(componentRef), ComponentDBException.displayName(component), ComponentDBException.displayName(oldValue), ComponentDBException.displayName(newValue));
    }

    static ComponentDBException componentChangedFromSimpleToNonSimple(Component component) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_CHANGED_FROM_SIMPLE_TO_NON_SIMPLE", ComponentDBException.displayName(component));
    }

    static ComponentDBException componentChangedFromNonSimpleToSimple(Component component) {
        return ComponentDBException.newValidationError("cdb.COMPONENT_CHANGED_FROM_NON_SIMPLE_TO_SIMPLE", ComponentDBException.displayName(component));
    }

    static ComponentDBException nestedComponentChanged(ComponentRefDecl compRefDecl, Component component, Component oldNestedComponent, Component newNestedComponent) {
        return ComponentDBException.newValidationError("cdb.NESTED_COMPONENT_CHANGED", ComponentDBException.displayName(compRefDecl), ComponentDBException.displayName(component), ComponentDBException.displayName(oldNestedComponent), ComponentDBException.displayName(newNestedComponent));
    }

    static ComponentDBException targetRefRemoved(Component component) {
        return ComponentDBException.newValidationError("cdb.TARGET_REF_REMOVED", ComponentDBException.displayName(component));
    }

    static ComponentDBException targetRefAdded(Component component) {
        return ComponentDBException.newValidationError("cdb.TARGET_REF_ADDED", ComponentDBException.displayName(component));
    }

    static ComponentDBException targetRefTypeChanged(Component component, String oldType, String newType) {
        return ComponentDBException.newValidationError("cdb.TARGET_REF_TYPE_CHANGED", ComponentDBException.displayName(component), oldType, newType);
    }

    static ComponentDBException targetRefAgentRemoved(Component component) {
        return ComponentDBException.newValidationError("cdb.TARGET_REF_AGENT_REMOVED", ComponentDBException.displayName(component));
    }

    static ComponentDBException targetRefAgentAdded(Component component) {
        return ComponentDBException.newValidationError("cdb.TARGET_REF_AGENT_ADDED", ComponentDBException.displayName(component));
    }

    static ComponentDBException newError(String code, ComponentMemberBase member) {
        return ComponentDBException.newValidationError(code, member.getName(), member.getElementDescription());
    }

    static ComponentDBException newError(String code, String arg3, ComponentMemberBase member) {
        return ComponentDBException.newValidationError(code, member.getName(), member.getElementDescription(), arg3);
    }

    static ComponentDBException newError(String code, String arg3, String arg4, ComponentMemberBase member) {
        return ComponentDBException.newValidationError(code, member.getName(), member.getElementDescription(), arg3, arg4);
    }

    static ComponentDBException newValidationError(String code) {
        return ComponentDBException.newValidationError(code, new String[0]);
    }

    static ComponentDBException newValidationError(String code, String arg) {
        return ComponentDBException.newValidationError(code, new String[]{arg});
    }

    static ComponentDBException newValidationError(String code, String arg1, String arg2) {
        return ComponentDBException.newValidationError(code, new String[]{arg1, arg2});
    }

    static ComponentDBException newValidationError(String code, String arg1, String arg2, String arg3) {
        return ComponentDBException.newValidationError(code, new String[]{arg1, arg2, arg3});
    }

    static ComponentDBException newValidationError(String code, String arg1, String arg2, String arg3, String arg4) {
        return ComponentDBException.newValidationError(code, new String[]{arg1, arg2, arg3, arg4});
    }

    static ComponentDBException newValidationError(String code, String arg1, String arg2, String arg3, String arg4, String arg5) {
        return ComponentDBException.newValidationError(code, new String[]{arg1, arg2, arg3, arg4, arg5});
    }

    static ComponentDBException newValidationError(String code, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
        return ComponentDBException.newValidationError(code, new String[]{arg1, arg2, arg3, arg4, arg5, arg6});
    }

    static ComponentDBException newValidationError(String code, String[] args) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new ComponentDBException(msg);
    }

    static ComponentDBException newValidationError(String code, String arg, Throwable t) {
        return ComponentDBException.newValidationError(code, new String[]{arg}, t);
    }

    static ComponentDBException newValidationError(String code, Throwable t) {
        return ComponentDBException.newValidationError(code, new String[0], t);
    }

    static ComponentDBException newValidationError(String code, String[] args, Throwable t) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new ComponentDBException(msg, t);
    }
}

