/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.Messages;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentVariableSettingsQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.VariableSettingsSelector;
import java.util.Hashtable;
import java.util.Vector;

class ComponentCache
implements Messages {
    private Hashtable mCompVersions = new Hashtable();
    private Hashtable mVars = new Hashtable();
    private static final ComponentVariableSettings[] EMPTY_VARS = new ComponentVariableSettings[0];

    ComponentCache() {
    }

    private void add(SummaryComponent comp) {
        this.getCompVersions(this.toNoVersionRef(comp)).add(comp);
    }

    private Vector getCompVersions(ComponentRef compRef) {
        Vector results = (Vector)this.mCompVersions.get(compRef);
        if (results == null) {
            results = new Vector();
            this.mCompVersions.put(compRef, results);
        }
        return results;
    }

    private void add(ComponentVariableSettings vs) {
        ComponentID compID = vs.getComponent().getID();
        this.getVars(compID).add(vs);
    }

    private Vector getVars(ComponentID compID) {
        Vector vars = (Vector)this.mVars.get(compID);
        if (vars == null) {
            vars = new Vector();
            this.mVars.put(compID, vars);
        }
        return vars;
    }

    public ComponentVariableSettings[] getVarSettings(SummaryComponent comp) {
        Vector vars = this.getVars(comp.getID());
        return vars.toArray(EMPTY_VARS);
    }

    public VariableSettingsSelector newVarSelector(SummaryComponent comp) {
        return new VariableSettingsSelector(comp, this.getVarSettings(comp));
    }

    public void load(ComponentRef compRef) throws PersistenceManagerException, RPCException {
        this.load(new ComponentRef[]{compRef});
    }

    public void load(ComponentRef[] compRefs) throws PersistenceManagerException, RPCException {
        Vector<ComponentRef> refs = new Vector<ComponentRef>();
        for (int i = 0; i < compRefs.length; ++i) {
            ComponentRef ref = this.toNoVersionRef(compRefs[i]);
            if (this.mCompVersions.containsKey(ref)) continue;
            refs.add(ref);
        }
        this.loadComps(refs.toArray(new ComponentRef[0]));
    }

    private ComponentRef toNoVersionRef(ComponentRef ref) {
        return new ComponentRef(ref.getPath(), ref.getComponentName(), null);
    }

    private ComponentRef toNoVersionRef(SummaryComponent comp) {
        return new ComponentRef(comp.getPath(), comp.getName(), null);
    }

    private void loadComps(ComponentRef[] refs) throws PersistenceManagerException, RPCException {
        if (refs.length == 0) {
            return;
        }
        SummaryComponent[] comps = MultiComponentQuery.byRefs(refs).selectSummaryView();
        this.addComponents(comps);
        ComponentIDSet compIDs = new ComponentIDSet();
        for (int i = 0; i < comps.length; ++i) {
            compIDs.add(comps[i].getID());
        }
        MultiComponentVariableSettingsQuery vsq = MultiComponentVariableSettingsQuery.byComps(compIDs);
        this.addVars(vsq.select());
    }

    private void addComponents(SummaryComponent[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            this.add(arr[i]);
        }
    }

    private void addVars(ComponentVariableSettings[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            this.add(arr[i]);
        }
    }

    public ComponentSelector newComponentSelector(ComponentRef compRef) {
        ComponentRef noVersionRef = this.toNoVersionRef(compRef);
        return new ComponentSelector(compRef, this.getVarSelectors(noVersionRef));
    }

    public ComponentSelector[] newComponentSelectors(ComponentRef[] compRefs) {
        ComponentSelector[] result = new ComponentSelector[compRefs.length];
        for (int i = 0; i < compRefs.length; ++i) {
            result[i] = this.newComponentSelector(compRefs[i]);
        }
        return result;
    }

    private VariableSettingsSelector[] getVarSelectors(ComponentRef compRef) {
        Vector compVersions = this.getCompVersions(compRef);
        int len = compVersions.size();
        VariableSettingsSelector[] result = new VariableSettingsSelector[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.newVarSelector((SummaryComponent)compVersions.elementAt(i));
        }
        return result;
    }
}

