/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessResolver;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberList;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentReferrer;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsSQLOps;
import com.raplix.rolloutexpress.systemmodel.componentdb.ControlBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.SnapshotBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.UninstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.BlockCallerStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.util.ObjectUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;

public class Component
extends SummaryComponent
implements Cloneable,
ComponentReferrer {
    private boolean mComponentIsCopy;
    private boolean mIsReadOnly = false;

    public Component() {
        super(ComponentImpl.create());
        this.setIsReadOnly(false);
        this.mComponentIsCopy = true;
    }

    public Component(PluginID plugin) {
        super(ComponentImpl.create(plugin));
        this.setIsReadOnly(false);
        this.mComponentIsCopy = true;
    }

    Component(ComponentImpl component, boolean isReadOnly) {
        super(component);
        this.setIsReadOnly(isReadOnly);
        this.mComponentIsCopy = false;
    }

    ComponentImpl getMutableComponent() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("read only");
        }
        if (!this.mComponentIsCopy) {
            this.setComponent((ComponentImpl)this.getComponent().clone());
            this.mComponentIsCopy = true;
        }
        return this.getComponent();
    }

    public void setVisibility(Visibility visibility) {
        this.getMutableComponent().setVisibility(visibility);
    }

    public void setAccessMode(AccessMode accessMode) {
        this.getMutableComponent().setAccessMode(accessMode);
    }

    public void setModifier(Modifier modifier) {
        this.getMutableComponent().setModifier(modifier);
    }

    public boolean isAccessible(CallSpec caller) {
        if (caller == null) {
            throw new NullPointerException();
        }
        AccessResolver accessResolver = new AccessResolver(this, caller);
        return accessResolver.currentComponentIsAccessible();
    }

    public void setName(String name) {
        this.getMutableComponent().setName(name);
    }

    public void setPath(FolderID path) {
        this.getMutableComponent().setPathID(path);
    }

    public String getSchemaVersion() {
        return this.getComponent().getSchemaVersion();
    }

    public void setSchemaVersion(String version) {
        this.getMutableComponent().setSchemaVersion(version);
    }

    public void setDescription(String description) {
        this.getMutableComponent().setDescription(description);
    }

    public void setLabel(String label) {
        this.getMutableComponent().setLabel(label);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableComponent().setUpdateCount(updateCount);
    }

    public void setPlatform(String platform) {
        this.getMutableComponent().setPlatform(platform);
    }

    public String getLimitToHostSet() {
        String result = this.getLocalLimitToHostSet();
        if (result != null) {
            return result;
        }
        return this.isDerivedComponent() ? this.getBaseComponent().getLimitToHostSet() : null;
    }

    public void setLocalLimitToHostSet(String hostSetName) {
        this.getMutableComponent().setLocalLimitToHostSet(hostSetName);
    }

    public void setExtendsType(ComponentType baseType) {
        this.getMutableComponent().setExtendsType(baseType);
    }

    public ComponentType getExtendsType() {
        return this.getComponent().getExtendsType();
    }

    public Component getAncestorByExtendsTypeName(String extendsTypeName) {
        for (Component current = this; current != null; current = current.getBaseComponent()) {
            String currentExtendsTypeName = current.getExtendsTypeName();
            if (!ObjectUtil.equals(extendsTypeName, currentExtendsTypeName)) continue;
            return current;
        }
        return null;
    }

    public Component getAncestorByID(ComponentID compID) {
        if (compID == null) {
            return this;
        }
        for (Component current = this; current != null; current = current.getBaseComponent()) {
            if (!compID.equals(current.getID())) continue;
            return current;
        }
        return null;
    }

    Component getBaseComponent() {
        return this.getComponent().getBaseComponent();
    }

    public boolean isInstanceOf(ComponentID otherCompID) {
        if (otherCompID == null) {
            return false;
        }
        return otherCompID.equals(this.getID()) || this.getExtendsType().isInstanceOf(otherCompID);
    }

    public boolean isInstanceOf(ComponentType otherType) {
        return this.getExtendsType().isInstanceOf(otherType);
    }

    public void setSoftwareVendor(String vendor) {
        this.getMutableComponent().setSoftwareVendor(vendor);
    }

    public void setAuthor(String author) {
        this.getMutableComponent().setAuthor(author);
    }

    public void setLocalInstallPath(String path) {
        this.getMutableComponent().setLocalInstallPath(path);
    }

    public String getInstallPath(ComponentConfigManager configMgr) throws ConfigGenException {
        String result;
        if (this.isDerivedComponent()) {
            result = this.getBaseComponent().getInstallPath(configMgr);
        } else {
            result = this.getLocalInstallPath();
            if (configMgr != null) {
                Caller caller = new Caller(null, this);
                result = configMgr.newCallerScope(caller).generate(result);
            }
        }
        return result;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.getMutableComponent().setSourceInfo(sourceInfo);
    }

    public VarDecl[] getLocalVarList() {
        return (VarDecl[])this.getComponent().getLocalVarList().toArray(this);
    }

    public void setLocalVarList(VarDecl[] vars) {
        this.getMutableComponent().getLocalVarList().resetFromArray(vars);
    }

    public boolean addLocalVar(VarDecl var) {
        return this.getMutableComponent().getLocalVarList().add(var);
    }

    public void removeLocalVar(String varName) {
        this.getMutableComponent().getLocalVarList().remove(varName);
    }

    public VarDecl resolveVar(String name, CallSpec caller) {
        return (VarDecl)this.getComponent().getLocalVarList().get(this, name, caller);
    }

    public VarDecl[] getVarList(CallSpec caller) {
        return (VarDecl[])this.getComponent().getLocalVarList().toArray(this, caller);
    }

    public Modifier getLocalResourceModifier() {
        return this.getComponent().getLocalResourceModifier();
    }

    public void setLocalResourceModifier(Modifier mod) {
        this.getMutableComponent().setLocalResourceModifier(mod);
    }

    public Modifier getResourceModifier() {
        if (!this.isSimpleComponent()) {
            return null;
        }
        Modifier mod = this.getLocalResourceModifier();
        if (mod != null) {
            return mod;
        }
        if (this.isDerivedComponent() && this.getLocalResource() == null) {
            return this.getBaseComponent().getResourceModifier();
        }
        return ComponentImpl.RSRC_REF_MOD_DEFAULT;
    }

    public ResourceDefinition getLocalResourceInstallSpec() {
        return this.getComponent().getLocalResourceInstallSpec(this);
    }

    public void setLocalResourceInstallSpec(ResourceDefinition spec) {
        this.getMutableComponent().setLocalResourceInstallSpec(spec);
    }

    public ResourceDefinition getResourceInstallSpec() {
        if (!this.isSimpleComponent()) {
            return null;
        }
        return this.isDerivedComponent() ? this.getBaseComponent().getResourceInstallSpec() : this.getLocalResourceInstallSpec();
    }

    public RsrcInfo getLocalResource() {
        return this.getComponent().getLocalResource();
    }

    public void setLocalResource(RsrcInfo rsrc) {
        this.getMutableComponent().setLocalResource(rsrc);
    }

    public RsrcInfo getResource() {
        if (!this.isSimpleComponent()) {
            return null;
        }
        RsrcInfo result = this.getLocalResource();
        if (result != null) {
            return result;
        }
        if (this.isDerivedComponent() && this.getLocalResourceModifier() == null) {
            return this.getBaseComponent().getResource();
        }
        return null;
    }

    public TargetRef getTargetRef() {
        TargetRef tgtRef = this.getLocalTargetRef();
        if (tgtRef != null) {
            return tgtRef;
        }
        if (this.isDerivedComponent()) {
            return this.getBaseComponent().getLocalTargetRef();
        }
        return null;
    }

    public TargetRef getLocalTargetRef() {
        return this.getComponent().getLocalTargetRef(this);
    }

    public void setLocalTargetRef(TargetRef tr) {
        this.getMutableComponent().setLocalTargetRef(tr);
    }

    public CallSpec getThisCallSpec() {
        return new CallSpec(this, false);
    }

    public CallSpec getSuperCallSpec() {
        return new CallSpec(this, true);
    }

    public Modifier getLocalCompRefListModifier() {
        return this.getComponent().getLocalCompRefListModifier();
    }

    public void setLocalCompRefListModifier(Modifier mod) {
        this.getMutableComponent().setLocalCompRefListModifier(mod);
    }

    public Modifier getCompRefListModifier() {
        if (this.isSimpleComponent()) {
            return null;
        }
        Modifier result = this.getLocalCompRefListModifier();
        if (result != null) {
            return result;
        }
        return this.isDerivedComponent() ? this.getBaseComponent().getCompRefListModifier() : ComponentImpl.COMP_REF_LIST_MOD_DEFAULT;
    }

    public ComponentType getLocalCompRefListType() {
        return this.getComponent().getLocalCompRefListType();
    }

    public void setLocalCompRefListType(ComponentType type) {
        this.getMutableComponent().setLocalCompRefListType(type);
    }

    public ComponentType getCompRefListType() {
        if (this.isSimpleComponent()) {
            return null;
        }
        ComponentType result = this.getLocalCompRefListType();
        if (result != null) {
            return result;
        }
        return this.isDerivedComponent() ? this.getBaseComponent().getCompRefListType() : ComponentType.ROOT;
    }

    public ComponentRefDecl[] getLocalCompRefList() {
        return (ComponentRefDecl[])this.getComponent().getLocalCompRefList().toArray(this);
    }

    public void setLocalCompRefList(ComponentRefDecl[] compRefs) {
        this.getMutableComponent().getLocalCompRefList().resetFromArray(compRefs);
    }

    public boolean addLocalCompRef(ComponentRefDecl compRef) {
        return this.getMutableComponent().getLocalCompRefList().add(compRef);
    }

    public void removeLocalCompRef(String compRefName) {
        this.getMutableComponent().getLocalCompRefList().remove(compRefName);
    }

    public ComponentRefDecl resolveCompRef(String name, CallSpec caller) {
        return (ComponentRefDecl)this.getComponent().getLocalCompRefList().get(this, name, caller);
    }

    public ComponentRefDecl[] getCompRefList(CallSpec caller) {
        if (this.isSimpleComponent()) {
            return null;
        }
        return (ComponentRefDecl[])this.getComponent().getLocalCompRefList().toArray(this, caller);
    }

    ComponentMemberList getMemberList(String listName) {
        return this.getComponent().getMemberList(listName);
    }

    public InstallBlock[] getLocalInstallList() {
        return (InstallBlock[])this.getComponent().getLocalInstallBlockList().toArray(this);
    }

    public void setLocalInstallList(InstallBlock[] blocks) {
        this.getMutableComponent().getLocalInstallBlockList().resetFromArray(blocks);
    }

    public boolean addLocalInstallBlock(InstallBlock installBlock) {
        return this.getMutableComponent().getLocalInstallBlockList().add(installBlock);
    }

    public void removeLocalInstallBlock(String blockName) {
        this.getMutableComponent().getLocalInstallBlockList().remove(blockName);
    }

    public InstallBlock[] getInstallList(CallSpec caller) {
        return (InstallBlock[])this.getComponent().getLocalInstallBlockList().toArray(this, caller);
    }

    public InstallBlock resolveInstallBlock(String name, CallSpec caller) {
        return (InstallBlock)this.getComponent().getLocalInstallBlockList().get(this, name, caller);
    }

    public UninstallBlock[] getLocalUninstallList() {
        return (UninstallBlock[])this.getComponent().getLocalUninstallBlockList().toArray(this);
    }

    public void setLocalUninstallList(UninstallBlock[] blocks) {
        this.getMutableComponent().getLocalUninstallBlockList().resetFromArray(blocks);
    }

    public boolean addLocalUninstallBlock(UninstallBlock uninstallBlock) {
        return this.getMutableComponent().getLocalUninstallBlockList().add(uninstallBlock);
    }

    public void removeLocalUninstallBlock(String blockName) {
        this.getMutableComponent().getLocalUninstallBlockList().remove(blockName);
    }

    public UninstallBlock[] getUninstallList(CallSpec caller) {
        return (UninstallBlock[])this.getComponent().getLocalUninstallBlockList().toArray(this, caller);
    }

    public UninstallBlock resolveUninstallBlock(String name, CallSpec caller) {
        return (UninstallBlock)this.getComponent().getLocalUninstallBlockList().get(this, name, caller);
    }

    public SnapshotBlock[] getLocalSnapshotList() {
        return (SnapshotBlock[])this.getComponent().getLocalSnapshotBlockList().toArray(this);
    }

    public void setLocalSnapshotList(SnapshotBlock[] blocks) {
        this.getMutableComponent().getLocalSnapshotBlockList().resetFromArray(blocks);
    }

    public boolean addLocalSnapshotBlock(SnapshotBlock snapshotBlock) {
        return this.getMutableComponent().getLocalSnapshotBlockList().add(snapshotBlock);
    }

    public void removeLocalSnapshotBlock(String blockName) {
        this.getMutableComponent().getLocalSnapshotBlockList().remove(blockName);
    }

    public SnapshotBlock[] getSnapshotList(CallSpec caller) {
        return (SnapshotBlock[])this.getComponent().getLocalSnapshotBlockList().toArray(this, caller);
    }

    public SnapshotBlock resolveSnapshotBlock(String name, CallSpec caller) {
        return (SnapshotBlock)this.getComponent().getLocalSnapshotBlockList().get(this, name, caller);
    }

    public ControlBlock[] getLocalControlList() {
        return (ControlBlock[])this.getComponent().getLocalControlBlockList().toArray(this);
    }

    public void setLocalControlList(ControlBlock[] blocks) {
        this.getMutableComponent().getLocalControlBlockList().resetFromArray(blocks);
    }

    public boolean addLocalControlBlock(ControlBlock controlBlock) {
        return this.getMutableComponent().getLocalControlBlockList().add(controlBlock);
    }

    public void removeLocalControlBlock(String blockName) {
        this.getMutableComponent().getLocalControlBlockList().remove(blockName);
    }

    public ControlBlock[] getControlList(CallSpec caller) {
        return (ControlBlock[])this.getComponent().getLocalControlBlockList().toArray(this, caller);
    }

    public ControlBlock resolveControlBlock(String name, CallSpec caller) {
        return (ControlBlock)this.getComponent().getLocalControlBlockList().get(this, name, caller);
    }

    public NamedBlock resolveBlock(String blockName, NamedBlockType blockType, CallSpec caller) {
        if (NamedBlockType.INSTALL.equals(blockType)) {
            return this.resolveInstallBlock(blockName, caller);
        }
        if (NamedBlockType.UNINSTALL.equals(blockType)) {
            return this.resolveUninstallBlock(blockName, caller);
        }
        if (NamedBlockType.CONTROL.equals(blockType)) {
            return this.resolveControlBlock(blockName, caller);
        }
        return null;
    }

    public NamedBlock resolveBlock(BlockCallerStep callingStep, CallSpec callSpec) {
        return this.resolveBlock(callingStep.getBlockName(), callingStep.getBlockType(), callSpec);
    }

    public void setLocalIgnorePaths(String[] paths) {
        this.getMutableComponent().setIgnorePaths(paths);
    }

    public String[] getIgnorePaths(ComponentConfigManager configMgr) throws ConfigGenException {
        ArrayList result = new ArrayList();
        this.loadIgnorePaths(result, configMgr);
        return result.toArray(new String[result.size()]);
    }

    private void loadIgnorePaths(ArrayList result, ComponentConfigManager configMgr) throws ConfigGenException {
        if (this.isDerivedComponent()) {
            this.getBaseComponent().loadIgnorePaths(result, configMgr);
        }
        ConfigGenerator generator = null;
        if (configMgr != null) {
            Caller caller = new Caller(null, this);
            generator = configMgr.newCallerScope(caller);
        }
        String[] locals = this.getLocalIgnorePaths();
        for (int i = 0; i < locals.length; ++i) {
            String ignore = locals[i];
            if (generator != null) {
                ignore = generator.generate(ignore);
            }
            result.add(ignore);
        }
    }

    public CategoryIDSet getCategories() {
        return this.getComponent().getCategories();
    }

    public void setCategories(CategoryIDSet cats) {
        this.getMutableComponent().setCategories(cats);
    }

    public void readFromXML(String comp) throws PersistenceManagerException, RPCException {
        this.getMutableComponent().readFromXML(comp);
    }

    public void readFromXML(InputStream comp) throws PersistenceManagerException, RPCException {
        this.getMutableComponent().readFromXML(comp, false);
    }

    void readFromXML(InputStream comp, boolean createFolder) throws PersistenceManagerException, RPCException {
        this.getMutableComponent().readFromXML(comp, createFolder);
    }

    public String writeToXML() {
        return this.getComponent().writeToXML();
    }

    public void writeToXML(OutputStream out) {
        this.getComponent().writeToXML(out);
    }

    public Component getDataClone() {
        return new Component((ComponentImpl)this.getComponent().getObjectDataClone(), false);
    }

    public Object clone() {
        return this.clone(false);
    }

    private Component clone(boolean readOnly) {
        if (this.mComponentIsCopy) {
            return new Component((ComponentImpl)this.getComponent().clone(), readOnly);
        }
        return new Component(this.getComponent(), readOnly);
    }

    public void save(ComponentSaveContext ctx) throws PersistenceManagerException, RPCException {
        this.getMutableComponent().save(ctx);
    }

    void saveSameVersionMS() throws PersistenceManagerException {
        this.getMutableComponent().saveSameVersionMS();
    }

    public void validate() throws PersistenceManagerException, RPCException {
        this.getComponent().validate();
    }

    public static void validateName(String name) throws SystemModelParseException, ComponentDBException {
        if (name == null) {
            throw ComponentDBException.invalidComponentName(name);
        }
        try {
            XMLUtil.validateEntityName(name);
        }
        catch (InvalidDatatypeValueException e) {
            throw ComponentDBException.invalidComponentName(name);
        }
    }

    public boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    private void setIsReadOnly(boolean isReadOnly) {
        this.mIsReadOnly = isReadOnly;
    }

    public Component toReadOnlyView() {
        if (this.isReadOnly()) {
            return this;
        }
        return this.clone(true);
    }

    public void enableHierarchyWrites() {
        if (this.isDerivedComponent()) {
            this.getMutableComponent();
            this.setExtendsType((ComponentType)this.getExtendsType().clone());
            this.getBaseComponent().enableHierarchyWrites();
        }
    }

    String[] importVariableSettingsMS(ComponentID fromCompID) throws PersistenceManagerException {
        ComponentVariableSettings[] srcVars = null;
        try {
            srcVars = fromCompID.getVariableSettingsQuery().select();
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
        return this.doImportVariableSettingsMS(srcVars);
    }

    String[] importVariableSettingsMS(Hashtable inVarSetHash) throws PersistenceManagerException {
        ComponentVariableSettings[] srcVars = null;
        try {
            srcVars = this.translateCompVarSettings(inVarSetHash);
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
        return this.doImportVariableSettingsMS(srcVars);
    }

    private String[] doImportVariableSettingsMS(ComponentVariableSettings[] inSrcVars) throws PersistenceManagerException {
        String[] newVarSetNames = null;
        try {
            ComponentVariableSettings[] newVars = new ComponentVariableSettings[inSrcVars.length];
            if (inSrcVars.length > 0) {
                newVarSetNames = new String[inSrcVars.length];
            }
            for (int i = 0; i < inSrcVars.length; ++i) {
                newVars[i] = new ComponentVariableSettings(this, inSrcVars[i]);
            }
            HashSet names = ComponentVariableSettingsSQLOps.DEFAULT.getNamesByComp(this.getID());
            for (int i = 0; i < newVars.length; ++i) {
                newVarSetNames[i] = this.saveAsUniqueNameMS(newVars[i], names);
                names.add(newVarSetNames[i]);
            }
        }
        catch (RPCException e) {
            throw ComponentDBException.unexpectedRPCError(e);
        }
        return newVarSetNames;
    }

    private String saveAsUniqueNameMS(ComponentVariableSettings vars, HashSet existingNames) throws PersistenceManagerException, RPCException {
        String origName;
        String name = origName = vars.getName();
        int j = 2;
        while (existingNames.contains(name)) {
            name = origName + "(" + j + ")";
            ++j;
        }
        vars.setName(name);
        vars.saveMS();
        return name;
    }

    public void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        this.getComponent().addComponentRefsMS(set);
    }

    private ComponentVariableSettings[] translateCompVarSettings(Hashtable inHash) throws PersistenceManagerException, RPCException {
        if (inHash == null) {
            throw ComponentDBException.invalidHashForVarSetImport();
        }
        ComponentVariableSettings[] newVarSets = new ComponentVariableSettings[inHash.size()];
        Iterator outerEntries = inHash.entrySet().iterator();
        int i = 0;
        while (outerEntries.hasNext()) {
            Map.Entry outerEntry = outerEntries.next();
            Object inVarSetHash = outerEntry.getValue();
            if (!(inVarSetHash instanceof Hashtable)) {
                throw ComponentDBException.invalidHashForVarSetImport();
            }
            ComponentVariableSettings newVarSet = new ComponentVariableSettings(this.getID());
            newVarSet.setName((String)outerEntry.getKey());
            Iterator hEntries = ((Hashtable)inVarSetHash).entrySet().iterator();
            while (hEntries.hasNext()) {
                Map.Entry innerEntry = hEntries.next();
                newVarSet.setOverrideVarValue((String)innerEntry.getKey(), (String)innerEntry.getValue());
            }
            newVarSets[i] = newVarSet;
            ++i;
        }
        return newVarSets;
    }
}

