/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallScopeBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMember;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberList;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ElementDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CompatibilityValidator {
    static final int COMPATIBILITY_TYPE_CALL = 0;
    static final int COMPATIBILITY_TYPE_INSTALL = 1;
    private HashMap mDerivedComponentMap = new HashMap();
    private final boolean mCheckInstall;

    private boolean checkInstall() {
        return this.mCheckInstall;
    }

    CompatibilityValidator(int compatibilityType) {
        if (compatibilityType == 1) {
            this.mCheckInstall = true;
        } else if (compatibilityType == 0) {
            this.mCheckInstall = false;
        } else {
            throw new IllegalArgumentException("Type must be either CALL or INSTALL");
        }
    }

    private void validateExtendsTypeChanges(ElementDescriptor extendingElement, ComponentType oldExtendsType, ComponentType newExtendsType) throws ComponentDBException, RPCException, PersistenceManagerException {
        if (oldExtendsType == newExtendsType) {
            return;
        }
        if (oldExtendsType == null) {
            throw ComponentDBException.oldExtendsTypeMissing(extendingElement, newExtendsType);
        }
        if (newExtendsType == null) {
            throw ComponentDBException.newExtendsTypeMissing(extendingElement, oldExtendsType);
        }
        if (ObjectUtil.equals(oldExtendsType.getTypeName(), newExtendsType.getTypeName())) {
            return;
        }
        if (this.checkInstall()) {
            throw ComponentDBException.extendsTypeChanged(extendingElement, oldExtendsType, newExtendsType);
        }
        if (!newExtendsType.isInstanceOf(oldExtendsType)) {
            throw ComponentDBException.newExtendsTypeNotInstanceOfOld(newExtendsType, extendingElement, oldExtendsType);
        }
        Component oldBackingComponent = oldExtendsType.getComponent();
        Component newBackingComponent = newExtendsType.getComponent();
        if (oldBackingComponent != null) {
            this.validate(oldBackingComponent, newBackingComponent, true, null);
        }
    }

    void validateExtendsChanges(Component oldComponent, Component newComponent) throws ComponentDBException, RPCException, PersistenceManagerException {
        ComponentType oldComponentExtendsType = oldComponent.getExtendsType();
        ComponentType newComponentExtendsType = newComponent.getExtendsType();
        this.validateExtendsTypeChanges(oldComponent, oldComponentExtendsType, newComponentExtendsType);
    }

    private boolean modifierChangeValid(Modifier oldModifier, Modifier newModifier) {
        if (this.checkInstall() && !ObjectUtil.equals(oldModifier, newModifier) && newModifier != null) {
            if (newModifier.equals(Modifier.FINAL)) {
                return false;
            }
            if (newModifier.equals(Modifier.ABSTRACT)) {
                return false;
            }
        }
        return true;
    }

    private boolean accessChangeValid(AccessMode oldAccess, AccessMode newAccess, ElementDescriptor element) {
        return !newAccess.isMoreRestrictiveThan(oldAccess);
    }

    private void validateComponentAttributeChanges(Component oldComponent, Component newComponent) throws ComponentDBException {
        AccessMode newAccess;
        Modifier newModifier;
        Modifier oldModifier = oldComponent.getModifier();
        if (!this.modifierChangeValid(oldModifier, newModifier = newComponent.getModifier())) {
            throw ComponentDBException.componentModifierChanged(oldComponent, oldModifier, newModifier);
        }
        AccessMode oldAccess = oldComponent.getAccessMode();
        if (!this.accessChangeValid(oldAccess, newAccess = newComponent.getAccessMode(), oldComponent)) {
            throw ComponentDBException.componentAccessChanged(oldComponent, oldAccess, newAccess);
        }
        this.validateIsSimpleChanges(oldComponent, newComponent);
        if (this.checkInstall()) {
            String newAuthor;
            String newSoftwareVendor;
            String newLabel;
            String newDescription;
            FolderID newPath;
            String newName;
            String oldName = oldComponent.getName();
            if (!ObjectUtil.equals(oldName, newName = newComponent.getName())) {
                throw ComponentDBException.componentNameChanged(oldComponent, newComponent);
            }
            FolderID oldPath = oldComponent.getPath();
            if (!ObjectUtil.equals(oldPath, newPath = newComponent.getPath())) {
                throw ComponentDBException.pathChanged(oldComponent, oldPath, newPath);
            }
            String oldDescription = oldComponent.getDescription();
            if (!ObjectUtil.equals(oldDescription, newDescription = newComponent.getDescription())) {
                throw ComponentDBException.descriptionChanged(oldComponent, oldDescription, newDescription);
            }
            String oldLabel = oldComponent.getLabel();
            if (!ObjectUtil.equals(oldLabel, newLabel = newComponent.getLabel())) {
                throw ComponentDBException.labelChanged(oldComponent, oldLabel, newLabel);
            }
            String oldSoftwareVendor = oldComponent.getSoftwareVendor();
            if (!ObjectUtil.equals(oldSoftwareVendor, newSoftwareVendor = newComponent.getSoftwareVendor())) {
                throw ComponentDBException.softwareVendorChanged(oldComponent, oldSoftwareVendor, newSoftwareVendor);
            }
            String oldAuthor = oldComponent.getAuthor();
            if (!ObjectUtil.equals(oldAuthor, newAuthor = newComponent.getAuthor())) {
                throw ComponentDBException.authorChanged(oldComponent, oldAuthor, newAuthor);
            }
        }
    }

    void validateIsSimpleChanges(Component oldComponent, Component newComponent) throws ComponentDBException {
        boolean newIsSimple;
        boolean oldIsSimple = oldComponent.isSimpleComponent();
        if (oldIsSimple != (newIsSimple = newComponent.isSimpleComponent())) {
            if (oldIsSimple) {
                throw ComponentDBException.componentChangedFromSimpleToNonSimple(oldComponent);
            }
            throw ComponentDBException.componentChangedFromNonSimpleToSimple(oldComponent);
        }
    }

    private void validatePlatformChanges(Component oldComponent, Component newComponent) throws ComponentDBException, RPCException, PersistenceManagerException {
        if (this.checkInstall()) {
            String oldPlatform = oldComponent.getPlatform();
            String newPlatform = newComponent.getPlatform();
            String allPlatformsName = SystemPluginConstants.ALL_PLATFORMS_NAME;
            HostSetID oldHostSetID = ComponentImpl.getHostSetIDByName(oldPlatform, allPlatformsName);
            HostSetID newHostSetID = ComponentImpl.getHostSetIDByName(newPlatform, allPlatformsName);
            if (newHostSetID.isDescendant(oldHostSetID)) {
                return;
            }
            if (oldHostSetID.isDescendant(newHostSetID)) {
                throw ComponentDBException.newPlatformMoreSpecificThanOld(newPlatform, oldComponent, oldPlatform);
            }
            throw ComponentDBException.newPlatformUnrelatedToOld(newPlatform, oldComponent, oldPlatform);
        }
    }

    private boolean returnsAttribValid(NamedBlock oldBlock, NamedBlock newBlock) throws ComponentDBException {
        boolean oldReturns = oldBlock.getReturns();
        boolean newReturns = newBlock.getReturns();
        return !this.checkInstall() && oldBlock instanceof InstallBlock || oldReturns == newReturns;
    }

    private void validateLimitToHostSetChanges(Component oldComponent, Component newComponent) throws ComponentDBException {
        String newLimitToHostSet;
        String oldLimitToHostSet;
        if (this.checkInstall() && !ObjectUtil.equals(oldLimitToHostSet = oldComponent.getLimitToHostSet(), newLimitToHostSet = newComponent.getLimitToHostSet())) {
            throw ComponentDBException.hostSetChanged(oldComponent, oldLimitToHostSet, newLimitToHostSet);
        }
    }

    private Map buildComponentMemberMap(ComponentMember[] members) {
        HashMap<String, ComponentMember> map = new HashMap<String, ComponentMember>();
        if (members == null || members.length == 0) {
            return map;
        }
        int n = members.length;
        for (int i = 0; i < n; ++i) {
            map.put(members[i].getName(), members[i]);
        }
        return map;
    }

    private void getMemberListChanges(Map oldMemberMap, Map newMemberMap, List addedMembers, List removedMembers, List namesOfCommonMembers) {
        ComponentMember member;
        String memberName;
        Iterator iter = newMemberMap.keySet().iterator();
        while (iter.hasNext()) {
            memberName = (String)iter.next();
            member = (ComponentMember)newMemberMap.get(memberName);
            if (oldMemberMap.get(memberName) != null) continue;
            addedMembers.add(member);
        }
        iter = oldMemberMap.keySet().iterator();
        while (iter.hasNext()) {
            memberName = (String)iter.next();
            member = (ComponentMember)oldMemberMap.get(memberName);
            if (newMemberMap.get(memberName) == null) {
                removedMembers.add(member);
                continue;
            }
            namesOfCommonMembers.add(memberName);
        }
    }

    private boolean validateVariableListChanges(Component oldComponent, Component newComponent, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        int i;
        ComponentMember[] oldVars = oldComponent.getVarList(null);
        ComponentMember[] newVars = newComponent.getVarList(null);
        ArrayList addedVariables = new ArrayList();
        ArrayList removedVariables = new ArrayList();
        ArrayList namesOfCommonVariables = new ArrayList();
        Map oldVarMap = this.buildComponentMemberMap(oldVars);
        Map newVarMap = this.buildComponentMemberMap(newVars);
        this.getMemberListChanges(oldVarMap, newVarMap, addedVariables, removedVariables, namesOfCommonVariables);
        boolean updateInstalledCompsFlag = false;
        if (this.checkInstall() && addedVariables.size() > 0) {
            List compList = this.getAllDerivedComponents(typeName);
            for (i = 0; i < compList.size(); ++i) {
                updateInstalledCompsFlag = true;
                Component derivedComp = (Component)compList.get(i);
                derivedComp.enableHierarchyWrites();
                Component ancestorComp = derivedComp.getAncestorByID(oldComponent.getID());
                for (int j = 0; j < addedVariables.size(); ++j) {
                    VarDecl addedVariable = (VarDecl)addedVariables.get(j);
                    if (addedVariable.getModifier().equals(Modifier.ABSTRACT) && !derivedComp.getComponent().getModifier().equals(Modifier.ABSTRACT)) {
                        throw ComponentDBException.abstractVariableAdded(addedVariable, oldComponent, derivedComp);
                    }
                    if (AccessMode.PRIVATE.equals(addedVariable.getAccessMode()) || !derivedComp.getComponent().getLocalVarList().contains(addedVariable.getName())) continue;
                    VarDecl sentinelVar = new VarDecl(addedVariable.getAccessMode(), addedVariable.getModifier(), "1sentinel", null, null);
                    ancestorComp.addLocalVar(sentinelVar);
                    VarDecl resolvedVar = derivedComp.resolveVar(sentinelVar.getName(), null);
                    if (resolvedVar == null) continue;
                    throw ComponentDBException.variableAdded(addedVariable, oldComponent, derivedComp);
                }
            }
        }
        Iterator iter = removedVariables.iterator();
        while (iter.hasNext()) {
            VarDecl removedVariable = (VarDecl)iter.next();
            if (AccessMode.PRIVATE.equals(removedVariable.getAccessMode())) continue;
            throw ComponentDBException.nonPrivateVariableRemoved(removedVariable, oldComponent);
        }
        iter = namesOfCommonVariables.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            VarDecl oldVariable = (VarDecl)oldVarMap.get(name);
            VarDecl newVariable = (VarDecl)newVarMap.get(name);
            this.validateVariableChanges(oldComponent, oldVariable, newVariable, typeName);
        }
        int lastIndex = -1;
        if (this.checkInstall() && this.varOverriddenByDerived(typeName, oldComponent)) {
            for (i = 0; i < oldVars.length; ++i) {
                if (((ComponentMemberBase)oldVars[i]).getOverriddenMember() != null || ((ComponentMemberBase)oldVars[i]).getDeclaringComponent() != oldComponent) continue;
                int foundAt = -1;
                for (int j = 0; j < newVars.length; ++j) {
                    if (!((ComponentMemberBase)newVars[j]).getName().equals(((ComponentMemberBase)oldVars[i]).getName())) continue;
                    foundAt = j;
                    break;
                }
                if (foundAt == -1) continue;
                if (foundAt <= lastIndex) {
                    throw ComponentDBException.variableOrderChanged((VarDecl)oldVars[i], oldComponent);
                }
                lastIndex = foundAt;
            }
        }
        return updateInstalledCompsFlag;
    }

    private boolean varOverriddenByDerived(String typeName, Component oldComp) throws RPCException, PersistenceManagerException {
        List compList = this.getAllDerivedComponents(typeName);
        VarDecl[] oldVars = oldComp.getVarList(null);
        for (int k = 0; k < oldVars.length; ++k) {
            if (oldVars[k].getOverriddenMember() != null || oldVars[k].getDeclaringComponent() != oldComp) continue;
            for (int i = 0; i < compList.size(); ++i) {
                Component derived = (Component)compList.get(i);
                ComponentMemberBase derivedLocalVar = derived.getComponent().getLocalVarList().getLocal(oldVars[k].getName());
                if (derivedLocalVar == null || derivedLocalVar.getOverriddenMember(derived) == null || !derivedLocalVar.getOverriddenMember(derived).getDeclaringComponent().getID().equals(oldComp.getID())) continue;
                return true;
            }
        }
        return false;
    }

    private void validateVariableChanges(Component component, VarDecl oldVar, VarDecl newVar, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        AccessMode newAccess;
        String newDefault;
        String oldDefault;
        Modifier oldModifier = oldVar.getModifier();
        Modifier newModifier = newVar.getModifier();
        if (this.checkInstall() && newModifier.equals(Modifier.FINAL) && !(oldDefault = oldVar.getDefaultValue()).equals(newDefault = newVar.getDefaultValue())) {
            throw ComponentDBException.finalDefaultValueChanged(oldVar, component, oldDefault, newDefault);
        }
        if (!this.modifierChangeValid(oldModifier, newModifier)) {
            throw ComponentDBException.varModifierChanged(oldVar, component, oldModifier, newModifier);
        }
        AccessMode oldAccess = oldVar.getAccessMode();
        if (!this.accessChangeValid(oldAccess, newAccess = newVar.getAccessMode(), oldVar)) {
            throw ComponentDBException.varAccessChanged(oldVar, component, oldAccess, newAccess);
        }
        if (this.checkInstall()) {
            List compList = this.getAllDerivedComponents(typeName);
            for (int i = 0; i < compList.size(); ++i) {
                ComponentMemberBase resolvedVarDerived;
                Component derivedComp = (Component)compList.get(i);
                derivedComp.enableHierarchyWrites();
                Component ancestorComp = derivedComp.getAncestorByID(component.getID());
                if (!derivedComp.getComponent().getLocalVarList().contains(newVar.getName())) continue;
                VarDecl sentinelVarOld = new VarDecl(oldVar.getAccessMode(), oldVar.getModifier(), "2sentinel", null, null);
                ancestorComp.addLocalVar(sentinelVarOld);
                VarDecl resolvedVarOld = derivedComp.resolveVar(sentinelVarOld.getName(), null);
                VarDecl sentinelVarNew = new VarDecl(newVar.getAccessMode(), newVar.getModifier(), "1sentinel", null, null);
                ancestorComp.addLocalVar(sentinelVarNew);
                VarDecl resolvedVarNew = derivedComp.resolveVar(sentinelVarNew.getName(), null);
                if (resolvedVarOld == null) {
                    if (resolvedVarNew == null) continue;
                    throw ComponentDBException.varAccessChangedBecameAccessible(oldVar, component, oldAccess, newAccess, derivedComp);
                }
                if (resolvedVarNew == null || !(resolvedVarDerived = derivedComp.getComponent().getLocalVarList().getLocal(newVar.getName())).getAccessMode().isMoreRestrictiveThan(newAccess)) continue;
                throw ComponentDBException.varAccessChangedMoreAccessibleThanDerived(oldVar, component, oldAccess, newAccess, derivedComp);
            }
        }
    }

    private Map getOverrideArgsMap(ComponentRefDecl componentRef) {
        HashMap<String, String> map = new HashMap<String, String>();
        VariableSettingsSource overrideArgs = componentRef.getOverrideArgs();
        String[] varNames = overrideArgs.getVarNames();
        int n = varNames.length;
        for (int i = 0; i < n; ++i) {
            map.put(varNames[i], overrideArgs.getVarValue(varNames[i]));
        }
        return map;
    }

    private void validateComponentRefChanges(Component component, ComponentRefDecl oldComponentRef, ComponentRefDecl newComponentRef) throws ComponentDBException, RPCException, PersistenceManagerException {
        InstallMode newInstallMode;
        Modifier newComponentRefModifier;
        Modifier oldComponentRefModifier = oldComponentRef.getModifier();
        if (!this.modifierChangeValid(oldComponentRefModifier, newComponentRefModifier = newComponentRef.getModifier())) {
            throw ComponentDBException.componentRefModifierChanged(oldComponentRef, oldComponentRefModifier, newComponentRefModifier);
        }
        InstallMode oldInstallMode = oldComponentRef.getInstallMode();
        if (!oldInstallMode.equals(newInstallMode = newComponentRef.getInstallMode())) {
            throw ComponentDBException.installModeChanged(oldComponentRef, component, oldInstallMode, newInstallMode);
        }
        ComponentType oldType = oldComponentRef.getType();
        ComponentType newType = newComponentRef.getType();
        this.validateExtendsTypeChanges(oldComponentRef, oldType, newType);
        if (oldInstallMode.equals(InstallMode.NESTED)) {
            if (this.checkInstall()) {
                String argName;
                Map oldArgs = this.getOverrideArgsMap(oldComponentRef);
                Map newArgs = this.getOverrideArgsMap(newComponentRef);
                Iterator iter = newArgs.keySet().iterator();
                while (iter.hasNext()) {
                    String newValue;
                    argName = (String)iter.next();
                    if (!oldArgs.containsKey(argName)) {
                        throw ComponentDBException.argumentAdded(argName, oldComponentRef, component);
                    }
                    String oldValue = (String)oldArgs.get(argName);
                    if (ObjectUtil.equals(oldValue, newValue = (String)newArgs.get(argName))) continue;
                    throw ComponentDBException.argumentChanged(argName, oldComponentRef, component, oldValue, newValue);
                }
                iter = oldArgs.keySet().iterator();
                while (iter.hasNext()) {
                    argName = (String)iter.next();
                    if (newArgs.containsKey(argName)) continue;
                    throw ComponentDBException.argumentRemoved(argName, oldComponentRef, component);
                }
            }
            if (oldComponentRef.getComponent() == null || newComponentRef.getComponent() == null) {
                return;
            }
            ComponentID oldNestedComponentID = oldComponentRef.getComponent().getID();
            ComponentID newNestedComponentID = newComponentRef.getComponent().getID();
            if (oldNestedComponentID == null || newNestedComponentID == null) {
                return;
            }
            Component oldNestedComponent = oldNestedComponentID.getByIDQuery().select();
            Component newNestedComponent = newNestedComponentID.getByIDQuery().select();
            if (oldNestedComponent == null || newNestedComponent == null) {
                return;
            }
            this.validate(oldNestedComponent, newNestedComponent, null);
        }
    }

    private void validateComponentRefListChanges(Component oldComponent, Component newComponent, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        Modifier newComponentRefListModifier;
        Modifier oldComponentRefListModifier = oldComponent.getCompRefListModifier();
        if (!this.modifierChangeValid(oldComponentRefListModifier, newComponentRefListModifier = newComponent.getCompRefListModifier())) {
            throw ComponentDBException.componentRefListModifierChanged(oldComponent, oldComponentRefListModifier, newComponentRefListModifier);
        }
        ComponentType oldComponentRefListType = oldComponent.getCompRefListType();
        ComponentType newComponentRefListType = newComponent.getCompRefListType();
        this.validateExtendsTypeChanges(oldComponent, oldComponentRefListType, newComponentRefListType);
        ComponentMember[] oldComponentRefList = oldComponent.getCompRefList(null);
        ComponentMember[] newComponentRefList = newComponent.getCompRefList(null);
        ArrayList addedComponentRefs = new ArrayList();
        ArrayList removedComponentRefs = new ArrayList();
        ArrayList namesOfCommonComponentRefs = new ArrayList();
        Map oldComponentRefMap = this.buildComponentMemberMap(oldComponentRefList);
        Map newComponentRefMap = this.buildComponentMemberMap(newComponentRefList);
        this.getMemberListChanges(oldComponentRefMap, newComponentRefMap, addedComponentRefs, removedComponentRefs, namesOfCommonComponentRefs);
        if (this.checkInstall() && addedComponentRefs.size() > 0) {
            List compList = this.getAllDerivedComponents(typeName);
            for (int i = 0; i < compList.size(); ++i) {
                Component comp = (Component)compList.get(i);
                for (int j = 0; j < addedComponentRefs.size(); ++j) {
                    ComponentRefDecl addedComponentRef = (ComponentRefDecl)addedComponentRefs.get(j);
                    if (addedComponentRef.getModifier().equals(Modifier.ABSTRACT) && !comp.getComponent().getModifier().equals(Modifier.ABSTRACT)) {
                        throw ComponentDBException.abstractComponentRefAdded(oldComponent, addedComponentRef, comp);
                    }
                    if (!comp.getComponent().getLocalCompRefList().contains(addedComponentRef.getName())) continue;
                    throw ComponentDBException.componentReferenceAdded(oldComponent, addedComponentRef, comp);
                }
            }
        }
        if (removedComponentRefs.size() > 0) {
            ComponentRefDecl removedComponentRef = (ComponentRefDecl)removedComponentRefs.get(0);
            throw ComponentDBException.componentReferenceRemovedOrRenamed(oldComponent, removedComponentRef);
        }
        Iterator iter = namesOfCommonComponentRefs.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ComponentRefDecl oldComponentRef = (ComponentRefDecl)oldComponentRefMap.get(name);
            ComponentRefDecl newComponentRef = (ComponentRefDecl)newComponentRefMap.get(name);
            this.validateComponentRefChanges(oldComponent, oldComponentRef, newComponentRef);
        }
    }

    private void validateResourceChanges(Component oldComponent, Component newComponent) throws ComponentDBException {
        Modifier newResourceModifier;
        Modifier oldResourceModifier = oldComponent.getResourceModifier();
        if (!this.modifierChangeValid(oldResourceModifier, newResourceModifier = newComponent.getResourceModifier())) {
            throw ComponentDBException.resourceModifierChanged(oldComponent, oldResourceModifier, newResourceModifier);
        }
        if (this.checkInstall()) {
            RsrcInfo newResourceInfo;
            RsrcInfo oldResourceInfo;
            ResourceDefinition newResourceDefinition;
            ResourceDefinition oldResourceDefinition = oldComponent.getResourceInstallSpec();
            if (oldResourceDefinition != (newResourceDefinition = newComponent.getResourceInstallSpec())) {
                String newInstallUser;
                String newInstallGroup;
                String newInstallName;
                String newInstallPath;
                if (oldResourceDefinition == null) {
                    throw ComponentDBException.resourceAdded(newResourceDefinition, oldComponent);
                }
                if (newResourceDefinition == null) {
                    throw ComponentDBException.resourceRemoved(oldResourceDefinition, oldComponent);
                }
                String oldInstallPath = oldResourceDefinition.getInstallPath();
                if (!ObjectUtil.equals(oldInstallPath, newInstallPath = newResourceDefinition.getInstallPath())) {
                    throw ComponentDBException.resourceInstallPathChanged(oldComponent, oldInstallPath, newInstallPath);
                }
                String oldInstallName = oldResourceDefinition.getInstallName();
                if (!ObjectUtil.equals(oldInstallName, newInstallName = newResourceDefinition.getInstallName())) {
                    throw ComponentDBException.resourceInstallNameChanged(oldComponent, oldInstallName, newInstallName);
                }
                String oldInstallGroup = oldResourceDefinition.getInstallGroup();
                if (!ObjectUtil.equals(oldInstallGroup, newInstallGroup = newResourceDefinition.getInstallGroup())) {
                    throw ComponentDBException.resourceInstallGroupChanged(oldComponent, oldInstallGroup, newInstallGroup);
                }
                String oldInstallUser = oldResourceDefinition.getInstallUser();
                if (!ObjectUtil.equals(oldInstallUser, newInstallUser = newResourceDefinition.getInstallUser())) {
                    throw ComponentDBException.resourceInstallUserChanged(oldComponent, oldInstallUser, newInstallUser);
                }
            }
            if ((oldResourceInfo = oldComponent.getResource()) != (newResourceInfo = newComponent.getResource())) {
                VersionNumber newResourceVersion;
                String newResourceName;
                if (oldResourceInfo == null || newResourceInfo == null) {
                    return;
                }
                String oldResourceName = oldResourceInfo.getName();
                if (!ObjectUtil.equals(oldResourceName, newResourceName = newResourceInfo.getName())) {
                    throw ComponentDBException.resourceNameChanged(oldComponent, oldResourceName, newResourceName);
                }
                VersionNumber oldResourceVersion = oldResourceInfo.getVersionNumber();
                if (!ObjectUtil.equals(oldResourceVersion, newResourceVersion = newResourceInfo.getVersionNumber())) {
                    throw ComponentDBException.resourceVersionChanged(oldComponent, oldResourceVersion, newResourceVersion);
                }
            }
        }
    }

    private void validateParamChanges(Component baseComp, Component derivedComp, CallScopeBlock block, PromptParam oldParam, PromptParam newParam) throws ComponentDBException {
        if (!oldParam.isRequired() && newParam.isRequired()) {
            throw ComponentDBException.parameterChangedFromOptionalToRequired(oldParam, block, baseComp, derivedComp);
        }
    }

    private void getParamListChanges(PromptParamList oldParamList, PromptParamList newParamList, List addedParams, List removedParams, List namesOfCommonParams) {
        PromptParam param;
        int i;
        String[] oldParamNames = oldParamList.getVarNames();
        String[] newParamNames = newParamList.getVarNames();
        int n = newParamNames.length;
        for (i = 0; i < n; ++i) {
            String name = newParamNames[i];
            param = newParamList.getParam(name);
            if (oldParamList.getParam(name) != null) continue;
            addedParams.add(param);
        }
        n = oldParamNames.length;
        for (i = 0; i < n; ++i) {
            String paramName = oldParamNames[i];
            param = oldParamList.getParam(paramName);
            if (newParamList.getParam(paramName) == null) {
                removedParams.add(param);
                continue;
            }
            namesOfCommonParams.add(paramName);
        }
    }

    private void validateBlockChanges(Component component, CallScopeBlock oldBlock, CallScopeBlock newBlock, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        AccessMode newAccess;
        Modifier newBlockModifier;
        Modifier oldBlockModifier = oldBlock.getModifier();
        if (!this.modifierChangeValid(oldBlockModifier, newBlockModifier = newBlock.getModifier())) {
            throw ComponentDBException.blockModifierChanged(oldBlock, component, oldBlockModifier, newBlockModifier);
        }
        AccessMode oldAccess = oldBlock.getAccessMode();
        if (!this.accessChangeValid(oldAccess, newAccess = newBlock.getAccessMode(), oldBlock)) {
            throw ComponentDBException.blockAccessChanged(oldBlock, component, oldAccess, newAccess);
        }
        if (oldBlock instanceof NamedBlock && newBlock instanceof NamedBlock && !this.returnsAttribValid((NamedBlock)oldBlock, (NamedBlock)newBlock)) {
            throw ComponentDBException.returnsChanged(component, (NamedBlock)oldBlock, ((NamedBlock)oldBlock).getReturns(), ((NamedBlock)newBlock).getReturns());
        }
        if (this.checkInstall()) {
            List compList = this.getAllDerivedComponents(typeName);
            for (int i = 0; i < compList.size(); ++i) {
                ComponentMemberBase resolvedBlockDerived;
                Component derivedComp = (Component)compList.get(i);
                derivedComp.enableHierarchyWrites();
                Component ancestorComp = derivedComp.getAncestorByID(component.getID());
                ComponentMemberList memberList = derivedComp.getMemberList(((ComponentMemberBase)((Object)oldBlock)).getListElementName());
                if (memberList == null || !memberList.contains(newBlock.getName())) continue;
                InstallBlock sentinelBlockOld = new InstallBlock(oldBlock.getAccessMode(), oldBlock.getModifier(), "2sentinel", "A sentinel block", null, null);
                ancestorComp.addLocalInstallBlock(sentinelBlockOld);
                InstallBlock resolvedBlockOld = derivedComp.resolveInstallBlock(sentinelBlockOld.getName(), null);
                InstallBlock sentinelBlockNew = new InstallBlock(newBlock.getAccessMode(), newBlock.getModifier(), "1sentinel", "A sentinel block", null, null);
                ancestorComp.addLocalInstallBlock(sentinelBlockNew);
                InstallBlock resolvedBlockNew = derivedComp.resolveInstallBlock(sentinelBlockNew.getName(), null);
                if (resolvedBlockOld == null) {
                    if (resolvedBlockNew == null) continue;
                    throw ComponentDBException.blockAccessChangedBecameAccessible(oldBlock, component, oldAccess, newAccess, derivedComp);
                }
                if (resolvedBlockNew == null || !(resolvedBlockDerived = memberList.getLocal(newBlock.getName())).getAccessMode().isMoreRestrictiveThan(newAccess)) continue;
                throw ComponentDBException.blockAccessChangedMoreAccessibleThanDerived(oldBlock, component, oldAccess, newAccess, derivedComp);
            }
        }
        if (!newAccess.equals(AccessMode.PRIVATE)) {
            this.validateParamListChanges(oldBlock, newBlock, component, null);
        }
    }

    private void validateParamListChanges(CallScopeBlock oldBlock, CallScopeBlock newBlock, Component baseComponent, Component derivedComponent) throws ComponentDBException {
        PromptParamList oldParamList = oldBlock.getParams();
        PromptParamList newParamList = newBlock.getParams();
        ArrayList addedParams = new ArrayList();
        ArrayList removedParams = new ArrayList();
        ArrayList namesOfCommonParams = new ArrayList();
        this.getParamListChanges(oldParamList, newParamList, addedParams, removedParams, namesOfCommonParams);
        Iterator iter = addedParams.iterator();
        while (iter.hasNext()) {
            PromptParam addedParam = (PromptParam)iter.next();
            if (!addedParam.isRequired()) continue;
            throw ComponentDBException.requiredParameterAdded(addedParam, newBlock, baseComponent, derivedComponent);
        }
        iter = namesOfCommonParams.iterator();
        while (iter.hasNext()) {
            String paramName = (String)iter.next();
            PromptParam oldParam = oldParamList.getParam(paramName);
            PromptParam newParam = newParamList.getParam(paramName);
            this.validateParamChanges(baseComponent, derivedComponent, oldBlock, oldParam, newParam);
        }
    }

    private List getAllDerivedComponents(String typeName) throws RPCException, PersistenceManagerException {
        if (typeName != null) {
            ArrayList<Component> compList = (ArrayList<Component>)this.mDerivedComponentMap.get(typeName);
            if (compList == null) {
                compList = new ArrayList<Component>();
                MultiComponentQuery mcompQuery = MultiComponentQuery.all();
                mcompQuery.setInstanceOfTypeFilter(typeName);
                Component[] comps = mcompQuery.select();
                for (int j = 0; j < comps.length; ++j) {
                    compList.add(comps[j]);
                }
                this.mDerivedComponentMap.put(typeName, compList);
            }
            return compList;
        }
        return new ArrayList();
    }

    private void validateBlockListChanges(Component component, Map oldBlockMap, Map newBlockMap, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        ArrayList addedBlocks = new ArrayList();
        ArrayList removedBlocks = new ArrayList();
        ArrayList namesOfCommonBlocks = new ArrayList();
        this.getMemberListChanges(oldBlockMap, newBlockMap, addedBlocks, removedBlocks, namesOfCommonBlocks);
        if (this.checkInstall() && addedBlocks.size() > 0) {
            List compList = this.getAllDerivedComponents(typeName);
            for (int i = 0; i < compList.size(); ++i) {
                Component derivedComp = (Component)compList.get(i);
                derivedComp.enableHierarchyWrites();
                Component ancestorComp = derivedComp.getAncestorByID(component.getID());
                for (int j = 0; j < addedBlocks.size(); ++j) {
                    NamedBlock addedBlock = (NamedBlock)addedBlocks.get(j);
                    if (addedBlock.getModifier().equals(Modifier.ABSTRACT) && !derivedComp.getComponent().getModifier().equals(Modifier.ABSTRACT)) {
                        throw ComponentDBException.abstractBlockAdded(addedBlock, component, derivedComp);
                    }
                    if (AccessMode.PRIVATE.equals(addedBlock.getAccessMode())) continue;
                    InstallBlock resolvedBlock = null;
                    ComponentMemberList memberList = derivedComp.getMemberList(addedBlock.getListElementName());
                    NamedBlock derivedBlock = null;
                    if (memberList != null) {
                        derivedBlock = (NamedBlock)memberList.getLocal(addedBlock.getName());
                    }
                    if (derivedBlock != null) {
                        InstallBlock sentinelBlock = new InstallBlock(addedBlock.getAccessMode(), addedBlock.getModifier(), "1sentinel", "A sentinel block", null, null);
                        ancestorComp.addLocalInstallBlock(sentinelBlock);
                        resolvedBlock = derivedComp.resolveInstallBlock(sentinelBlock.getName(), null);
                    }
                    if (resolvedBlock == null) continue;
                    this.validateAddedBlock(addedBlock, derivedBlock, component, derivedComp);
                }
            }
        }
        Iterator iter = removedBlocks.iterator();
        while (iter.hasNext()) {
            ComponentMember member = (ComponentMember)iter.next();
            if (AccessMode.PRIVATE.equals(member.getAccessMode())) continue;
            throw ComponentDBException.nonPrivateBlockRemoved(member, component);
        }
        iter = namesOfCommonBlocks.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            CallScopeBlock oldBlock = (CallScopeBlock)oldBlockMap.get(name);
            CallScopeBlock newBlock = (CallScopeBlock)newBlockMap.get(name);
            this.validateBlockChanges(component, oldBlock, newBlock, typeName);
        }
    }

    private void validateAddedBlock(NamedBlock addedBlock, NamedBlock derivedBlock, Component baseComponent, Component derivedComponent) throws ComponentDBException {
        if (addedBlock.getModifier().equals(Modifier.FINAL)) {
            throw ComponentDBException.finalBlockAdded(addedBlock, baseComponent, derivedComponent);
        }
        if (derivedBlock.getAccessMode().isMoreRestrictiveThan(addedBlock.getAccessMode())) {
            throw ComponentDBException.blockAddedWithInvalidAccess(addedBlock, baseComponent, derivedComponent);
        }
        this.validateParamListChanges(addedBlock, derivedBlock, baseComponent, derivedComponent);
        if (Logger.isWarnEnabled(this)) {
            ComponentDBException err = ComponentDBException.nonPrivateBlockAdded(addedBlock, baseComponent, derivedComponent);
            Logger.warn(err.getMessage(), this);
        }
    }

    private void validateAllBlockListChanges(Component oldComponent, Component newComponent, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        Map oldBlockMap = this.buildComponentMemberMap(oldComponent.getInstallList(null));
        Map newBlockMap = this.buildComponentMemberMap(newComponent.getInstallList(null));
        this.validateBlockListChanges(oldComponent, oldBlockMap, newBlockMap, typeName);
        oldBlockMap = this.buildComponentMemberMap(oldComponent.getUninstallList(null));
        newBlockMap = this.buildComponentMemberMap(newComponent.getUninstallList(null));
        this.validateBlockListChanges(oldComponent, oldBlockMap, newBlockMap, typeName);
        oldBlockMap = this.buildComponentMemberMap(oldComponent.getControlList(null));
        newBlockMap = this.buildComponentMemberMap(newComponent.getControlList(null));
        this.validateBlockListChanges(oldComponent, oldBlockMap, newBlockMap, typeName);
        oldBlockMap = this.buildComponentMemberMap(oldComponent.getSnapshotList(null));
        newBlockMap = this.buildComponentMemberMap(newComponent.getSnapshotList(null));
        this.validateBlockListChanges(oldComponent, oldBlockMap, newBlockMap, typeName);
    }

    private void validateTargetRefChanges(Component oldComponent, Component newComponent) throws ComponentDBException {
        TargetRef oldTR = oldComponent.getLocalTargetRef();
        TargetRef newTR = newComponent.getLocalTargetRef();
        if (oldTR == null && newTR == null) {
            return;
        }
        if (oldTR != null && newTR == null) {
            throw ComponentDBException.targetRefRemoved(oldComponent);
        }
        if (oldTR == null && newTR != null) {
            if (this.checkInstall()) {
                throw ComponentDBException.targetRefAdded(oldComponent);
            }
            return;
        }
        if (!oldTR.getTypeName().equals(newTR.getTypeName())) {
            throw ComponentDBException.targetRefTypeChanged(oldComponent, oldTR.getTypeName(), newTR.getTypeName());
        }
        if (!oldTR.isVirtual() && newTR.isVirtual()) {
            throw ComponentDBException.targetRefAgentRemoved(oldComponent);
        }
        if (oldTR.isVirtual() && !newTR.isVirtual()) {
            throw ComponentDBException.targetRefAgentAdded(oldComponent);
        }
    }

    boolean validate(Component oldComponent, Component newComponent) throws ComponentDBException, RPCException, PersistenceManagerException {
        return this.validate(oldComponent, newComponent, false, null);
    }

    boolean validate(Component oldComponent, Component newComponent, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        return this.validate(oldComponent, newComponent, false, typeName);
    }

    private boolean validate(Component oldComponent, Component newComponent, boolean recursive, String typeName) throws ComponentDBException, RPCException, PersistenceManagerException {
        if (oldComponent == newComponent) {
            return false;
        }
        if (recursive && oldComponent.getID().equals(newComponent.getID())) {
            return false;
        }
        boolean updateCompVarsFlag = false;
        this.validateComponentAttributeChanges(oldComponent, newComponent);
        this.validatePlatformChanges(oldComponent, newComponent);
        this.validateLimitToHostSetChanges(oldComponent, newComponent);
        this.validateExtendsChanges(oldComponent, newComponent);
        updateCompVarsFlag = this.validateVariableListChanges(oldComponent, newComponent, typeName);
        this.validateComponentRefListChanges(oldComponent, newComponent, typeName);
        this.validateResourceChanges(oldComponent, newComponent);
        this.validateAllBlockListChanges(oldComponent, newComponent, typeName);
        this.validateTargetRefChanges(oldComponent, newComponent);
        return updateCompVarsFlag;
    }
}

