/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.TokenVisitor;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.ObjectVisitorImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.StepValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.ValidationState;

class CompVarNStepValidator
extends CompDBVisitor {
    private boolean mIsReturnValue = false;
    private ValidationState mCrt = null;

    CompVarNStepValidator(Caller caller) {
        super(new ObjectVisitorImpl());
        new StepValidator(this.getVisitor());
        new TokenVisitor(this.getVisitor(), true, caller);
        this.mCrt = ((StepValidator)this.getPlanDBVisitor()).getValidationState();
    }

    PersistenceManagerException mapException(Exception e) {
        if (e instanceof PersistenceManagerException) {
            return (PersistenceManagerException)e;
        }
        if (e instanceof ConfigGenException) {
            return ComponentDBException.configValidationError((ConfigGenException)e);
        }
        throw new RuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(ComponentMemberBase m) throws Exception {
        if (m instanceof NamedBlock) {
            this.mIsReturnValue = ((NamedBlock)m).getReturns();
            ((StepValidator)this.getPlanDBVisitor()).setIsReturnValue(this.mIsReturnValue);
            this.mCrt.initiateCallStack();
        }
        try {
            m.accept(this);
            if (m instanceof NamedBlock && this.mIsReturnValue && !this.mCrt.getCurrenState().isFoundReturnStep() && !this.mCrt.getCurrenState().isFoundRaiseStep()) {
                throw ComponentDBException.requiredStepsForReturnsAttr(m.getName(), m.getElementName());
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (m instanceof NamedBlock) {
                this.mCrt.popCallStack();
                this.mIsReturnValue = false;
            }
            throw throwable;
        }
        if (m instanceof NamedBlock) {
            this.mCrt.popCallStack();
            this.mIsReturnValue = false;
        }
    }

    public void visit(ExecStep[] s) throws Exception {
        this.getPlanDBVisitor().visit(s);
    }
}

