/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.config.TokenPluginNSValidator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.ObjectVisitorImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMemberBase;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;

public class CompDBPluginNSValidator
extends CompDBVisitor {
    Plugin mPlugin;
    Caller mCaller;
    VersionedSaveContext mCxt = null;
    private static final String HOST_TYPE_NAME = "host type";
    private static final String HOST_SET_NAME = "host set";
    private static final String COMP_TYPE_NAME = "component type";

    CompDBPluginNSValidator(Plugin plugin, Caller caller, VersionedSaveContext cxt) {
        super(new ObjectVisitorImpl());
        this.setPlugin(plugin);
        this.setCaller(caller);
        this.setContext(cxt);
        new PlanDBPluginNSValidator(this.getVisitor(), plugin, caller);
        new TokenPluginNSValidator(this.getVisitor(), plugin);
    }

    public CompDBPluginNSValidator(ObjectVisitorImpl ovi, Plugin plugin, Caller caller) {
        super(ovi);
        this.setPlugin(plugin);
        this.setCaller(caller);
    }

    public void visit(ComponentRef r) throws Exception {
        r.validateNamespace(this);
    }

    void visit(ComponentMemberBase m) throws Exception {
        m.validateNamespace(this);
    }

    void visit(TargetRef r) throws Exception {
        r.validateNamespace(this);
    }

    void visitHostType(String s) throws PersistenceManagerException, RPCException {
        if (s == null) {
            return;
        }
        SummaryHostType h = SingleHostTypeQuery.byName(s).selectSummaryView();
        this.getPlugin().validateNamespace(h.getPluginID(), h.getName(), HOST_TYPE_NAME);
    }

    public void visitHostSet(String s) throws PersistenceManagerException, RPCException {
        if (s == null) {
            return;
        }
        SummaryHostSet h = SingleHostSetQuery.byName(s).selectSummaryView();
        this.getPlugin().validateNamespace(h.getPluginID(), h.getName(), HOST_SET_NAME);
    }

    void visit(ComponentType c) throws PersistenceManagerException {
        if (c == null) {
            return;
        }
        ComponentTypeRef ctr = c.getComponentTypeRef();
        if (ctr == null) {
            return;
        }
        this.getPlugin().validateNamespace(ctr.getPluginID(), ctr.getName(), COMP_TYPE_NAME);
    }

    public Plugin getPlugin() {
        return this.mPlugin;
    }

    private void setPlugin(Plugin plugin) {
        this.mPlugin = plugin;
    }

    public Caller getCaller() {
        return this.mCaller;
    }

    private void setCaller(Caller caller) {
        this.mCaller = caller;
    }

    VersionedSaveContext getContext() {
        return this.mCxt;
    }

    private void setContext(VersionedSaveContext cxt) {
        this.mCxt = cxt;
    }

    PersistenceManagerException mapException(Exception e) {
        if (e instanceof PersistenceManagerException) {
            return (PersistenceManagerException)e;
        }
        if (e instanceof RPCException) {
            return ComponentDBException.unexpectedRPCError((RPCException)e);
        }
        throw new RuntimeException(e);
    }
}

