/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;

public class CallSpec {
    public static CallSpec PUBLIC = new CallSpec();
    private Component mCallerComponent;
    private FolderID mCallerPath;
    private ComponentID mCalleeType;
    private boolean mIsInternalCall;
    private boolean mAllowOverrides;

    public CallSpec(Caller caller, ComponentID calleeType) {
        if (caller != null) {
            this.setCallerComponent(caller.getDeclaredComponent());
            this.setCallerPath(caller.getDeclaredPath());
        }
        this.setCalleeType(calleeType);
        this.setIsInternalCall(false);
        this.setAllowOverrides(true);
    }

    CallSpec(Component caller, boolean isSuper) {
        this.setCallerComponent(caller);
        this.setCallerPath(caller.getPath());
        ComponentID calleeType = isSuper ? caller.getBaseComponent().getID() : caller.getID();
        this.setCalleeType(calleeType);
        this.setIsInternalCall(true);
        this.setAllowOverrides(!isSuper);
    }

    private CallSpec() {
    }

    public Component getCallerComponent() {
        return this.mCallerComponent;
    }

    private void setCallerComponent(Component comp) {
        this.mCallerComponent = comp;
    }

    public FolderID getCallerPath() {
        return this.mCallerPath;
    }

    private void setCallerPath(FolderID path) {
        this.mCallerPath = path;
    }

    public ComponentID getCalleeType() {
        return this.mCalleeType;
    }

    private void setCalleeType(ComponentID compID) {
        this.mCalleeType = compID;
    }

    public boolean isInternalCall() {
        return this.mIsInternalCall;
    }

    private void setIsInternalCall(boolean isInternal) {
        this.mIsInternalCall = isInternal;
    }

    boolean allowOverrides() {
        return this.mAllowOverrides;
    }

    private void setAllowOverrides(boolean allowOverrides) {
        this.mAllowOverrides = allowOverrides;
    }
}

