/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.componentdb;

import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;

class AccessResolver
implements Cloneable {
    private static final int NUM_MODES = AccessMode.FACTORY.getAll().length;
    private Component[] mDeclarerForAccess = new Component[NUM_MODES];
    private Component mCurrentComponent;
    private Component mCallerComponent;
    private FolderID mCallerPath;
    private boolean mProtectedPermitted;

    public AccessResolver(Component actualCallee, CallSpec cs) {
        boolean samePath;
        if (cs == null) {
            cs = actualCallee.getThisCallSpec();
        }
        Component declaredCallee = this.getDeclaredCallee(cs, actualCallee);
        Component caller = this.getCaller(cs, declaredCallee, actualCallee);
        this.mCallerPath = cs.getCallerPath();
        Component component = this.mDeclarerForAccess[AccessMode.PUBLIC.toInt()] = cs.allowOverrides() ? actualCallee : declaredCallee;
        if (this.isSame(declaredCallee, caller)) {
            this.mDeclarerForAccess[AccessMode.PRIVATE.toInt()] = declaredCallee;
        }
        if (samePath = declaredCallee.getPath().equals(this.mCallerPath)) {
            Component pathCallee;
            this.mDeclarerForAccess[AccessMode.PATH.toInt()] = pathCallee = cs.allowOverrides() ? this.getPathCallee(declaredCallee, actualCallee) : declaredCallee;
        }
        this.mProtectedPermitted = cs.isInternalCall() || this.isInstanceOf(declaredCallee, caller);
        this.mCurrentComponent = declaredCallee;
        this.mCallerComponent = caller;
        this.updateProtected(samePath);
    }

    private boolean isInstanceOf(Component c1, Component c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.isInstanceOf(c2.getID());
    }

    private boolean isSame(Component c1, Component c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ComponentID c1ID = c1.getID();
        return c1ID != null && c1ID.equals(c2.getID());
    }

    private Component getCaller(CallSpec cs, Component declaredCallee, Component actualCallee) {
        Component caller = cs.getCallerComponent();
        if (cs.isInternalCall()) {
            if (!this.isInstanceOf(caller, declaredCallee)) {
                String msg = "internal caller not instanceof declared callee";
                throw new IllegalArgumentException(msg);
            }
            if (!this.isInstanceOf(actualCallee, caller)) {
                String msg = "actual callee not instanceof internal caller";
                throw new IllegalArgumentException(msg);
            }
        }
        return caller;
    }

    private Component getDeclaredCallee(CallSpec cs, Component actualCallee) {
        Component declaredCallee = actualCallee.getAncestorByID(cs.getCalleeType());
        if (declaredCallee == null) {
            String msg = "actual callee not instanceof declared callee";
            throw new IllegalArgumentException(msg);
        }
        return declaredCallee;
    }

    private Component getPathCallee(Component declaredCallee, Component actualCallee) {
        FolderID declaredPath = declaredCallee.getPath();
        Component pathCallee = null;
        while (actualCallee != declaredCallee) {
            if (actualCallee.getPath().equals(declaredPath)) {
                if (pathCallee == null) {
                    pathCallee = actualCallee;
                }
            } else {
                pathCallee = null;
            }
            actualCallee = actualCallee.getBaseComponent();
        }
        if (pathCallee == null) {
            pathCallee = declaredCallee;
        }
        return pathCallee;
    }

    private void updateProtected(boolean samePath) {
        Component protectedDeclarer = null;
        if (samePath || this.mProtectedPermitted && this.isInstanceOf(this.mCallerComponent, this.mCurrentComponent)) {
            protectedDeclarer = this.mDeclarerForAccess[AccessMode.PUBLIC.toInt()];
        }
        this.mDeclarerForAccess[AccessMode.PROTECTED.toInt()] = protectedDeclarer;
    }

    public Component getCurrentComponent() {
        return this.mCurrentComponent;
    }

    public boolean currentComponentIsAccessible() {
        AccessMode currentAccessMode = this.getCurrentComponent().getAccessMode();
        return this.getAccessibleDeclarer(currentAccessMode) != null;
    }

    public Component getAccessibleDeclarer(AccessMode accessMode) {
        return this.mDeclarerForAccess[accessMode.toInt()];
    }

    public AccessResolver getBaseComponentAccessResolver() {
        Component base = this.mCurrentComponent.getBaseComponent();
        if (base == null) {
            return null;
        }
        AccessResolver result = (AccessResolver)this.clone();
        result.mDeclarerForAccess[AccessMode.PRIVATE.toInt()] = null;
        boolean samePath = base.getPath().equals(this.mCallerPath);
        if (!samePath) {
            result.mDeclarerForAccess[AccessMode.PATH.toInt()] = null;
        }
        result.mCurrentComponent = base;
        result.updateProtected(samePath);
        return result;
    }

    protected Object clone() {
        try {
            AccessResolver result = (AccessResolver)super.clone();
            result.mDeclarerForAccess = (Component[])result.mDeclarerForAccess.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

