/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.catdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryOrder;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryProcessor;
import com.raplix.rolloutexpress.systemmodel.catdb.CategorySQLOps;
import com.raplix.util.regex.GlobPattern;

public class MultiCategoryQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final CategorySQLOps TABLE = new CategorySQLOps("catT");
    private GlobPattern mNameFilter;
    private GlobPattern mDescriptionFilter;
    private CategoryID[] mNotCategoriesFilter;

    public static MultiCategoryQuery all() {
        MultiCategoryQuery result = new MultiCategoryQuery((ConditionalExpression)null);
        result.setObjectOrder(CategoryOrder.BY_NAME_ASC);
        return result;
    }

    static MultiCategoryQuery byIDs(CategoryID[] IDs) {
        return new MultiCategoryQuery(IDs);
    }

    private MultiCategoryQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, CategoryOrder.FACTORY);
    }

    private MultiCategoryQuery(CategoryID[] IDs) {
        super((Table)TABLE, IDs, CategoryOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((CategoryOrder)order);
    }

    public GlobPattern getNameFilter() {
        return this.mNameFilter;
    }

    public void setNameFilter(GlobPattern nameFilter) {
        this.mNameFilter = nameFilter;
    }

    public GlobPattern getDescriptionFilter() {
        return this.mDescriptionFilter;
    }

    public void setDescriptionFilter(GlobPattern descriptionFilter) {
        this.mDescriptionFilter = descriptionFilter;
    }

    public CategoryID[] getNotCategoriesFilter() {
        return this.mNotCategoriesFilter;
    }

    public void setNotCategoriesFilter(CategoryID[] notCategoriesFilter) {
        this.mNotCategoriesFilter = notCategoriesFilter;
    }

    public Category[] select() throws RPCException, PersistenceManagerException {
        return (Category[])this.select(new CategoryProcessor(this.getTable(), false), Category.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        CategorySQLOps t = (CategorySQLOps)this.getTable();
        if (this.getNameFilter() != null) {
            ctx.addAndWhereCondition(t.likeName(this.getNameFilter()));
        }
        if (this.getDescriptionFilter() != null) {
            ctx.addAndWhereCondition(t.likeDescription(this.getDescriptionFilter()));
        }
        if (this.getNotCategoriesFilter() != null) {
            ctx.addAndWhereCondition(CategorySQLOps.not(t.inIDs(this.getNotCategoriesFilter())));
        }
    }
}

