/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.catdb;

import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryImplTable;
import com.raplix.util.regex.GlobPattern;

class CategorySQLOps
extends CategoryImplTable {
    public static final CategorySQLOps DEFAULT = new CategorySQLOps();

    public CategorySQLOps(String alias) {
        super(alias);
    }

    private CategorySQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new CategorySQLOps(alias);
    }

    public ConditionalExpression isName(String name) {
        return CategorySQLOps.equals(this.Name, name);
    }

    public ConditionalExpression inIDs(CategoryID[] IDs) {
        return CategorySQLOps.emptyIn(this.ID, CategorySQLOps.rList(IDs));
    }

    public ConditionalExpression likeName(GlobPattern name) {
        return CategorySQLOps.likeLower(this.Name, name);
    }

    public ConditionalExpression likeDescription(GlobPattern desc) {
        return CategorySQLOps.likeLower(this.Description, desc);
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        return CategorySQLOps.dictOrderAsc(this.Name);
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        return CategorySQLOps.dictOrderDesc(this.Name);
    }
}

