/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.catdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.QueryImplBase;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.VersionedTable;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.persist.util.LinkTable;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategorySQLOps;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class CategoryLinkTable
extends LinkTable {
    private static final Map sChildTableMap = new HashMap();
    private static final List sLinkTables = new ArrayList();

    protected CategoryLinkTable() {
    }

    protected CategoryLinkTable(String alias) {
        super(alias);
    }

    public CategoryIDSet getCategories(final ObjectID id) throws PersistenceManagerException, RPCException {
        if (id == null) {
            return new CategoryIDSet();
        }
        return new CatIDSetTransaction(){

            public CategoryIDSet myExecuteMS() throws PersistenceManagerException {
                return CategoryLinkTable.this.getCategoriesMS(id);
            }
        }.transact();
    }

    private CategoryIDSet getCategoriesMS(ObjectID id) throws PersistenceManagerException {
        CategoryIDSet result = new CategoryIDSet();
        Link[] links = this.getByChildID(id);
        Link.addParentIDs(result, Arrays.asList(links));
        return result;
    }

    public CategoryIDSet getSharedCategories(final Select childIDs) throws PersistenceManagerException, RPCException {
        return new CatIDSetTransaction(){

            public CategoryIDSet myExecuteMS() throws PersistenceManagerException {
                return CategoryLinkTable.this.getSharedCategoriesMS(childIDs);
            }
        }.transact();
    }

    private CategoryIDSet getSharedCategoriesMS(Select childIDs) throws PersistenceManagerException {
        VersionedTable ct = (VersionedTable)this.getChildTable().instance(this.getAlias() + "ict");
        CategorySQLOps pt = CategorySQLOps.DEFAULT;
        CategorySQLOps ipt = new CategorySQLOps("ipt");
        Select catsForChild = this.select(CategoryLinkTable.sList(this.cParentID()), CategoryLinkTable.where(CategoryLinkTable.and(CategoryLinkTable.equals((ColumnNode)this.cParentID(), ipt.ID), CategoryLinkTable.equals((ColumnNode)this.cChildID(), ct.ID))));
        Select unsharedCats = CategoryLinkTable.select(CategoryLinkTable.sList(ipt.ID), CategoryLinkTable.tList(ipt, (TableClause)ct), CategoryLinkTable.where(CategoryLinkTable.and(CategoryLinkTable.in((ColumnNode)ct.ID, childIDs), CategoryLinkTable.not(CategoryLinkTable.exists(catsForChild)))));
        CategoryIDProcessor processor = new CategoryIDProcessor();
        CategoryLinkTable.execute(pt.select(CategoryLinkTable.sList(pt.ID), CategoryLinkTable.where(CategoryLinkTable.not(CategoryLinkTable.in((ColumnNode)pt.ID, unsharedCats)))), processor);
        return processor.getResults();
    }

    public int updateCategories(final VersionedObjectID childID, final CategoryUpdateContext catCtx) throws PersistenceManagerException, RPCException {
        return new IntTransaction(){

            public int myExecuteMS() throws PersistenceManagerException {
                return CategoryLinkTable.this.updateCategoriesMS(childID, catCtx, false);
            }
        }.transact();
    }

    public int updateCategoriesMS(VersionedObjectID childID, CategoryUpdateContext catCtx, boolean isNewVersionTree) throws PersistenceManagerException {
        VersionedTable ct = this.getChildTable();
        Select objectsToUpdate = null;
        objectsToUpdate = catCtx.getAllVersions() ? ct.select(CategoryLinkTable.sList(ct.ID), CategoryLinkTable.where(ct.isVersionOf(childID))) : CategoryLinkTable.anonSelect(CategoryLinkTable.sList(CategoryLinkTable.v(childID)));
        return this.updateCategoriesMS(catCtx, ct, objectsToUpdate, isNewVersionTree);
    }

    private int updateCategoriesMS(CategoryUpdateContext catCtx, VersionedTable ct, Select objectsToUpdate, boolean isNewVersionTree) throws PersistenceManagerException {
        ct.checkFolderPerm(objectsToUpdate);
        CategoryIDSet catSet = catCtx.getCategories();
        ct.lockRoots(objectsToUpdate);
        int updateCount = CategoryLinkTable.execute(ct.incrUpdateCountByID(objectsToUpdate));
        ct.notifyDependenciesOfUpdate(objectsToUpdate);
        if (catCtx.getReplaceExisting()) {
            CategoryLinkTable.execute(this.delete(CategoryLinkTable.where(CategoryLinkTable.in((ColumnNode)this.cChildID(), objectsToUpdate))));
        }
        Select newLinks = null;
        Iterator cats = catSet.iterator();
        while (cats.hasNext()) {
            CategoryID cat = (CategoryID)cats.next();
            Select existingLinks = this.selectChildIDs(cat);
            newLinks = ct.select(CategoryLinkTable.sList(CategoryLinkTable.v(cat), (ScalarExp)ct.ID), CategoryLinkTable.where(CategoryLinkTable.and(CategoryLinkTable.in((ColumnNode)ct.ID, objectsToUpdate), CategoryLinkTable.not(CategoryLinkTable.in((ColumnNode)ct.ID, existingLinks)))), newLinks);
        }
        if (newLinks != null) {
            this.addLinks(newLinks);
        }
        return updateCount;
    }

    public int updateCategories(final Select childIDs, final CategoryUpdateContext catCtx) throws PersistenceManagerException, RPCException {
        return new IntTransaction(){

            public int myExecuteMS() throws PersistenceManagerException {
                return CategoryLinkTable.this.updateCategoriesMS(childIDs, catCtx);
            }
        }.transact();
    }

    private int updateCategoriesMS(Select childIDs, CategoryUpdateContext catCtx) throws PersistenceManagerException {
        VersionedTable ct = this.getChildTable();
        Select objectsToUpdate = null;
        objectsToUpdate = catCtx.getAllVersions() ? ct.select(CategoryLinkTable.sList(ct.ID), CategoryLinkTable.where(ct.isVersionOfAny(childIDs))) : childIDs;
        return this.updateCategoriesMS(catCtx, ct, objectsToUpdate, false);
    }

    public ConditionalExpression matchesCategoryID(CategoryID catID, IDColumn idCol) {
        if (Category.NO_CATEGORY_ID.equals(catID)) {
            return CategoryLinkTable.not(CategoryLinkTable.in((ColumnNode)idCol, this.select(CategoryLinkTable.sList(this.cChildID()))));
        }
        if (Category.ANY_CATEGORY_ID.equals(catID)) {
            return CategoryLinkTable.all();
        }
        return CategoryLinkTable.in((ColumnNode)idCol, this.select(CategoryLinkTable.sList(this.cChildID()), CategoryLinkTable.where(CategoryLinkTable.equals(this.cParentID(), catID))));
    }

    public static void registerTable(CategoryLinkTable table, VersionedTable childTable) {
        sLinkTables.add(table);
        sChildTableMap.put(table.getClass(), childTable);
    }

    static void deleteAllLinksByID(final CategoryID catID) throws PersistenceManagerException {
        CategoryLinkTable.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws PersistenceManagerException {
                CategoryLinkTable.privDeleteAllLinksByID(catID);
                return null;
            }
        });
    }

    static void privDeleteAllLinksByID(CategoryID catID) throws PersistenceManagerException {
        Iterator tables = sLinkTables.iterator();
        while (tables.hasNext()) {
            CategoryLinkTable lt = (CategoryLinkTable)tables.next();
            lt.deleteLinksByID(catID);
        }
    }

    private void deleteLinksByID(CategoryID catID) throws PersistenceManagerException {
        Select childIDs = this.selectChildIDs(catID);
        VersionedTable ct = this.getChildTable();
        ct.lockRoots(childIDs);
        CategoryLinkTable.execute(ct.incrUpdateCountByID(childIDs));
        this.removeByParentID(catID);
    }

    private static Object doPrivileged(PrivilegedExceptionAction action) throws PersistenceManagerException {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof PersistenceManagerException) {
                throw (PersistenceManagerException)e;
            }
            throw new PersistenceManagerException(e);
        }
    }

    private VersionedTable getChildTable() {
        return (VersionedTable)sChildTableMap.get(this.getClass());
    }

    private PersistContext transactRPC(RPCTransaction tx) throws PersistenceManagerException, RPCException {
        return Transactor.myTransactRPC(tx);
    }

    private static class Transactor
    extends QueryImplBase {
        private Transactor() {
        }

        public static PersistContext myTransactRPC(RPCTransaction t) throws PersistenceManagerException, RPCException {
            return QueryImplBase.transactRPC(t);
        }
    }

    private abstract class IntTransaction
    extends RPCTransaction {
        private IntTransaction() {
        }

        public int transact() throws PersistenceManagerException, RPCException {
            return ((Result)((CategoryLinkTable)CategoryLinkTable.this).transactRPC((RPCTransaction)this)).mResult;
        }

        protected PersistContext executeMS() throws PersistenceManagerException {
            return new Result(this.myExecuteMS());
        }

        protected abstract int myExecuteMS() throws PersistenceManagerException;

        class Result
        extends PersistContext {
            int mResult;

            Result(int result) {
                this.mResult = result;
            }
        }
    }

    private static final class CategoryIDProcessor
    extends ResultSetProcessor {
        private CategoryIDSet mResult = new CategoryIDSet();

        private CategoryIDProcessor() {
        }

        public void processResultSet(ResultSet rs) throws PersistenceManagerException, SQLException {
            while (rs.next()) {
                this.mResult.add(new CategoryID(rs.getString(1)));
            }
        }

        public CategoryIDSet getResults() {
            return this.mResult;
        }
    }

    private abstract class CatIDSetTransaction
    extends RPCTransaction {
        private CatIDSetTransaction() {
        }

        public CategoryIDSet transact() throws PersistenceManagerException, RPCException {
            return ((Result)((CategoryLinkTable)CategoryLinkTable.this).transactRPC((RPCTransaction)this)).mResult;
        }

        protected PersistContext executeMS() throws PersistenceManagerException {
            return new Result(this.myExecuteMS());
        }

        protected abstract CategoryIDSet myExecuteMS() throws PersistenceManagerException;

        class Result
        extends PersistContext {
            CategoryIDSet mResult;

            Result(CategoryIDSet result) {
                this.mResult = result;
            }
        }
    }
}

