/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.catdb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.catdb.Messages;

public class CategoryDBException
extends PersistenceManagerException
implements Messages {
    protected CategoryDBException() {
    }

    protected CategoryDBException(ROXMessage msg) {
        super(msg);
    }

    protected CategoryDBException(Throwable t) {
        super(t);
    }

    protected CategoryDBException(ROXMessage msg, Throwable t) {
        super(msg, t, 1);
    }

    static CategoryDBException invalidCategoryName(String name) {
        return CategoryDBException.newValidationError("catdb.INVALID_CATEGORY_NAME", name);
    }

    static CategoryDBException invalidCategoryDescription(String desc) {
        return CategoryDBException.newValidationError("catdb.INVALID_CATEGORY_DESC", desc);
    }

    static CategoryDBException intermixedSystemCats() {
        return CategoryDBException.newValidationError("catdb.UPDATE_MIXED_SYSTEM_CAT");
    }

    static CategoryDBException rootMustBeSystem() {
        return CategoryDBException.newValidationError("catdb.UPDATE_SYSTEM_IN_NON_SYSTEM_TREE");
    }

    static CategoryDBException rootMustNotBeSystem() {
        return CategoryDBException.newValidationError("catdb.UPDATE_NON_SYSTEM_IN_SYSTEM_TREE");
    }

    private static CategoryDBException newValidationError(String code) {
        return CategoryDBException.newValidationError(code, new Object[0]);
    }

    private static CategoryDBException newSystemError(String code) {
        return CategoryDBException.newSystemError(code, new Object[0]);
    }

    private static CategoryDBException newValidationError(String code, Object arg) {
        return CategoryDBException.newValidationError(code, new Object[]{arg});
    }

    private static CategoryDBException newValidationError(String code, int arg) {
        return CategoryDBException.newValidationError(code, new Object[]{new Integer(arg)});
    }

    private static CategoryDBException newValidationError(String code, Object[] args) {
        ROXMessage msg = new ROXMessage(code, args, 2000);
        return new CategoryDBException(msg);
    }

    private static CategoryDBException newSystemError(String code, Object[] args) {
        ROXMessage msg = new ROXMessage(code, args, 3000);
        return new CategoryDBException(msg);
    }
}

