/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.catdb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryDBException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryImpl;
import com.raplix.util.Validate;

public class Category
implements RPCSerializable,
Cloneable,
HasObjectID {
    public static final CategoryID NO_CATEGORY_ID = new CategoryID("no categories");
    public static final CategoryID ANY_CATEGORY_ID = new CategoryID("any category");
    private boolean mCategoryIsCopy;
    private CategoryImpl mCategory;

    public Category() {
        this.setCategory(CategoryImpl.create());
        this.mCategoryIsCopy = true;
    }

    Category(CategoryImpl category) {
        this.setCategory(category);
        this.mCategoryIsCopy = false;
    }

    private CategoryImpl getCategory() {
        return this.mCategory;
    }

    private void setCategory(CategoryImpl category) {
        this.mCategory = category;
    }

    private CategoryImpl getMutableCategory() {
        if (!this.mCategoryIsCopy) {
            this.setCategory((CategoryImpl)this.getCategory().clone());
            this.mCategoryIsCopy = true;
        }
        return this.getCategory();
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public CategoryID getID() {
        return this.getCategory().getID();
    }

    public String getName() {
        return this.getCategory().getName();
    }

    public void setName(String name) {
        this.getMutableCategory().setName(name);
    }

    public String getDescription() {
        return this.getCategory().getDescription();
    }

    public void setDescription(String desc) {
        this.getMutableCategory().setDescription(desc);
    }

    public int getUpdateCount() {
        return this.getCategory().getUpdateCount();
    }

    public void setUpdateCount(int updateCount) {
        this.getMutableCategory().setUpdateCount(updateCount);
    }

    public Category getDataClone() {
        return new Category((CategoryImpl)this.getCategory().getObjectDataClone());
    }

    public Object clone() {
        if (this.mCategoryIsCopy) {
            return new Category((CategoryImpl)this.getCategory().clone());
        }
        return new Category(this.getCategory());
    }

    public void save() throws CategoryDBException, PersistenceManagerException, RPCException {
        this.getMutableCategory().save();
    }

    public void validate() throws CategoryDBException {
        this.getCategory().validate();
    }

    public static void validateName(String name) throws CategoryDBException {
        if (!Validate.isValidObjectName(name, 32)) {
            throw CategoryDBException.invalidCategoryName(name);
        }
    }

    public static void validateDescription(String desc) throws CategoryDBException {
        if (!Validate.isValidObjectDescription(desc)) {
            throw CategoryDBException.invalidCategoryDescription(desc);
        }
    }
}

