/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.Replace;
import com.sun.n1.util.enum.Enum;
import com.sun.n1.util.enum.EnumFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static final FolderID DEFAULT_PATH = FolderID.ROOT_FOLDER_ID;
    public static final String DEFAULT_PATH_STRING = "/";
    private static final String XML_HEADER_PI = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String[] XML_HEADER_LINES = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<!-- generated by N1 SPS -->"};
    public static final String ROX_NAMESPACE = "http://www.sun.com/schema/SPS";
    public static final String SCHEMA_INST_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static Hashtable mGrammarPoolMap = new Hashtable();
    private static Hashtable mGrammarMap = new Hashtable();
    private static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String SCHEMA_DIR = "xml_schema/";
    private static final JarEntityResolver ENTITY_RESOLVER = new JarEntityResolver();
    public static final char AMP = '&';
    public static final char LT = '<';
    public static final char QUOTE = '\"';
    public static final String AMP_ER = "&amp;";
    public static final String LT_ER = "&lt;";
    public static final String QUOTE_ER = "&quot;";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_END_SUBST = "]]&gt;";
    private static final String CDATA_START = "<![CDATA[";
    private static final String DEFAULT_CODE_PREFIX = "cdb.";
    private static final LocalErrorHandler DEFAULT_ERROR_HANDLER = new LocalErrorHandler("cdb.", null);
    private static final String SHARED_SCHEMA_NAME = "planCompShared.xsd";
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$XMLUtil;

    public static DOMParser obtainParser(boolean reportErrors, String schemaName, String codePrefix) throws SystemModelParseException {
        DOMParser parser = new DOMParser();
        if (reportErrors) {
            XMLUtil.installValidation(parser, schemaName, codePrefix);
        }
        return parser;
    }

    private static void installValidation(DOMParser parser, String schemaName, String codePrefix) throws SystemModelParseException {
        try {
            XMLErrorReporter errorReporter = (XMLErrorReporter)parser.getProperty(ERROR_REPORTER);
            String schemaDomain = "http://www.w3.org/TR/xml-schema-1";
            MessageFormatter formatter = errorReporter.getMessageFormatter(schemaDomain);
            LocalErrorHandler errorHandler = new LocalErrorHandler(codePrefix, formatter);
            parser.setErrorHandler((ErrorHandler)errorHandler);
            errorReporter.putMessageFormatter(schemaDomain, (MessageFormatter)errorHandler);
            parser.setProperty(GRAMMAR_POOL, (Object)XMLUtil.getGrammarPool(schemaName, errorHandler));
            parser.setFeature(VALIDATION_FEATURE_ID, true);
            parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
            parser.setFeature(LOAD_EXTERNAL_DTD_FEATURE_ID, true);
        }
        catch (IOException e) {
            throw new SystemModelParseException(e, codePrefix);
        }
        catch (SAXException e) {
            throw new SystemModelParseException(e, codePrefix);
        }
    }

    private static XMLGrammarPool getGrammarPool(String schemaName, XMLErrorHandler errorHandler) throws XNIException, IOException {
        XMLUtil.loadSchema(schemaName, errorHandler);
        return (XMLGrammarPool)mGrammarPoolMap.get(schemaName);
    }

    private static SchemaGrammar getGrammar(String schemaName, XMLErrorHandler errorHandler) throws XNIException, IOException {
        XMLUtil.loadSchema(schemaName, errorHandler);
        return (SchemaGrammar)mGrammarMap.get(schemaName);
    }

    private static void loadSchema(String schemaFilename, XMLErrorHandler errorHandler) throws XNIException, IOException {
        if (mGrammarPoolMap.containsKey(schemaFilename)) {
            return;
        }
        XMLGrammarPreparser preparser = new XMLGrammarPreparser();
        preparser.setErrorHandler(errorHandler);
        XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        preparser.setProperty(GRAMMAR_POOL, (Object)grammarPool);
        preparser.setFeature(VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        preparser.setEntityResolver((XMLEntityResolver)ENTITY_RESOLVER);
        XMLInputSource xis = XMLUtil.ENTITY_RESOLVER.resolveEntity(null, schemaFilename, null);
        Grammar g = preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", xis);
        mGrammarPoolMap.put(schemaFilename, grammarPool);
        mGrammarMap.put(schemaFilename, g);
    }

    public static String getXMLHeaderString() {
        StringWriter out = new StringWriter();
        XMLUtil.writeXMLHeader(new PrintWriter(out));
        return out.toString();
    }

    public static void writeXMLHeader(OutputStream os) {
        XMLUtil.writeXMLHeader(new PrintWriter(os));
    }

    private static void writeXMLHeader(PrintWriter pw) {
        for (int i = 0; i < XML_HEADER_LINES.length; ++i) {
            pw.println(XML_HEADER_LINES[i]);
        }
        pw.flush();
    }

    public static void addSchemaAttributes(XML element, String schemaName) {
        element.addXMLAttribute("xmlns", ROX_NAMESPACE);
        element.addXMLAttribute("xmlns:xsi", SCHEMA_INST_NAMESPACE);
        element.addXMLAttribute("xsi:schemaLocation", "http://www.sun.com/schema/SPS " + schemaName);
    }

    public static String getXMLForDB(XML element) {
        element.addXMLAttribute("xmlns", ROX_NAMESPACE);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + element.toString();
    }

    public static String getAttribute(Element elem, String name) {
        String value = elem.getAttribute(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public static String getAttributeEmptyAllowed(Element elem, String name) {
        if (!elem.hasAttribute(name)) {
            return null;
        }
        return elem.getAttribute(name);
    }

    public static Enum getEnumAttribute(Element elem, String name, EnumFactory factory) {
        return XMLUtil.getEnumAttribute(elem, name, factory, null);
    }

    public static Enum getEnumAttribute(Element elem, String name, EnumFactory factory, Enum defaultEnum) {
        String enumStr = XMLUtil.getAttribute(elem, name);
        return enumStr == null ? defaultEnum : factory.getEnum(enumStr);
    }

    public static FolderID getPathAttribute(Element elem, String attrName, String errorPrefix, boolean create) throws SystemModelParseException {
        String pathStr = XMLUtil.getAttribute(elem, attrName);
        if (pathStr == null) {
            return DEFAULT_PATH;
        }
        if (!pathStr.endsWith(DEFAULT_PATH_STRING)) {
            pathStr = pathStr + DEFAULT_PATH_STRING;
        }
        try {
            if (create) {
                FolderID newOrExistingID = Folder.createPath(pathStr);
                return newOrExistingID;
            }
            return SingleFolderQuery.byPath(pathStr).selectSummaryView().getID();
        }
        catch (PersistenceManagerException e) {
            throw new SystemModelParseException(e, errorPrefix);
        }
        catch (RPCException e) {
            throw new SystemModelParseException(e, errorPrefix);
        }
    }

    public static Boolean getBooleanAttribute(Element elem, String name) {
        return (name = XMLUtil.getAttribute(elem, name)) == null ? null : new Boolean(name);
    }

    public static boolean getBooleanAttribute(Element elem, String name, boolean defaultValue) {
        Boolean result = XMLUtil.getBooleanAttribute(elem, name);
        return result == null ? defaultValue : result;
    }

    public static Element[] getChildren(Element elem, String name) {
        Vector<Node> results = new Vector<Node>();
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(name)) continue;
            results.add(child);
        }
        return results.toArray(new Element[results.size()]);
    }

    public static Element[] getChildren(Element elem) {
        Vector<Node> results = new Vector<Node>();
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            results.add(child);
        }
        return results.toArray(new Element[results.size()]);
    }

    public static Element getFirstChild(Element elem) {
        Node child;
        for (child = elem.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static String getTextContent(Node node) {
        NodeList children = node.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    sb.append(((CharacterData)child).getData());
                }
            }
        }
        return sb.toString();
    }

    public static void addAttributeIfNotNull(XML element, String name, String value) {
        if (value != null) {
            element.addAttribute(name, XMLUtil.substituteEntityRef(value));
        }
    }

    public static void addAttribute(XML element, String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            element.addAttribute(name, XMLUtil.substituteEntityRef(String.valueOf(value)));
        }
    }

    public static void addAttribute(XML element, String name, Enum value, Enum defaultValue) {
        if (!ObjectUtil.equals(defaultValue, value)) {
            element.addAttribute(name, XMLUtil.substituteEntityRef(value.toString()));
        }
    }

    public static void addPathAttribute(XML element, String name, FolderID path) {
        if (!DEFAULT_PATH.equals(path)) {
            String pathStr = XMLUtil.toXMLPathString(path);
            XMLUtil.addAttributeIfNotNull(element, name, pathStr);
        }
    }

    public static String toXMLPathString(FolderID path) {
        String pathStr = path.getFullPathString();
        if (!FolderID.ROOT_FOLDER_ID.equals(path)) {
            pathStr = pathStr.substring(0, pathStr.length() - 1);
        }
        return pathStr;
    }

    public static String substituteEntityRef(String str) {
        if (str.indexOf(38) < 0 && str.indexOf(60) < 0 && str.indexOf(34) < 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            switch (chr) {
                case '&': {
                    buf.append(AMP_ER);
                    continue block5;
                }
                case '<': {
                    buf.append(LT_ER);
                    continue block5;
                }
                case '\"': {
                    buf.append(QUOTE_ER);
                    continue block5;
                }
                default: {
                    buf.append(chr);
                }
            }
        }
        return buf.toString();
    }

    public static String encloseInCDATA(String str) {
        if (str.indexOf(CDATA_END) < 0) {
            return CDATA_START + str + CDATA_END;
        }
        int idx = 0;
        StringBuffer sink = new StringBuffer();
        do {
            idx = XMLUtil.consumeCDATADelimiters(sink, str, idx);
        } while ((idx = XMLUtil.consumeCDATAText(sink, str, idx)) < str.length());
        return sink.toString();
    }

    private static int consumeCDATADelimiters(StringBuffer sink, String source, int idx) {
        int endIdx;
        while ((endIdx = source.indexOf(CDATA_END, idx)) == idx) {
            sink.append(CDATA_END_SUBST);
            idx += CDATA_END.length();
        }
        return idx;
    }

    private static int consumeCDATAText(StringBuffer sink, String source, int idx) {
        int endIdx = source.indexOf(CDATA_END, idx);
        int n = endIdx = endIdx < 0 ? source.length() : endIdx;
        if (endIdx > idx) {
            sink.append(CDATA_START).append(source.substring(idx, endIdx)).append(CDATA_END);
        }
        return endIdx;
    }

    public static String toString(Element elem, String errorPrefix) throws SystemModelParseException {
        try {
            StringWriter out = new StringWriter();
            OutputFormat format = new OutputFormat("xml", null, false);
            format.setOmitXMLDeclaration(true);
            format.setPreserveSpace(true);
            DOMSerializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)out, format).asDOMSerializer();
            serializer.serialize(elem);
            out.close();
            return out.toString();
        }
        catch (IOException e) {
            throw new SystemModelParseException(e, errorPrefix);
        }
    }

    private static void validateAgainstType(String value, String typeName) throws SystemModelParseException, InvalidDatatypeValueException {
        try {
            SchemaGrammar sg = XMLUtil.getGrammar(SHARED_SCHEMA_NAME, DEFAULT_ERROR_HANDLER);
            XSSimpleType idType = (XSSimpleType)sg.getGlobalTypeDecl(typeName);
            idType.validate(value, null, null);
        }
        catch (XNIException e) {
            throw new SystemModelParseException((Exception)((Object)e), DEFAULT_CODE_PREFIX);
        }
        catch (IOException e) {
            throw new SystemModelParseException(e, DEFAULT_CODE_PREFIX);
        }
    }

    public static void validateIdentifier(String value) throws SystemModelParseException, InvalidDatatypeValueException {
        XMLUtil.validateAgainstType(value, "identifierType");
    }

    public static void validateEntityName(String value) throws SystemModelParseException, InvalidDatatypeValueException {
        XMLUtil.validateAgainstType(value, "entityNameType");
    }

    public static void validatePathName(String value) throws SystemModelParseException, InvalidDatatypeValueException {
        XMLUtil.validateAgainstType(value, "pathNameType");
    }

    private static class JarEntityResolver
    implements XMLEntityResolver {
        private JarEntityResolver() {
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier resID) throws XNIException, IOException {
            return this.resolveEntity(resID.getPublicId(), resID.getLiteralSystemId(), resID.getBaseSystemId());
        }

        private XMLInputSource resolveEntity(String publicID, String systemID, String baseSystemID) {
            InputStream schemaStream = this.getClass().getResourceAsStream(XMLUtil.SCHEMA_DIR + systemID);
            return new XMLInputSource(publicID, systemID, baseSystemID, schemaStream, null);
        }
    }

    private static class LocalErrorHandler
    implements ErrorHandler,
    XMLErrorHandler,
    MessageFormatter {
        private String mCodePrefix;
        private MessageFormatter mDefaultFormatter;
        private static final String NAMESPACE_PREFIX = "\"http://www.sun.com/schema/SPS\":";

        LocalErrorHandler(String codePrefix, MessageFormatter formatter) {
            this.mCodePrefix = codePrefix;
            if (formatter == null) {
                formatter = new XSMessageFormatter();
            }
            this.mDefaultFormatter = formatter;
        }

        private String getMessage(Exception e) {
            return SystemModelParseException.getMessage(e, this.mCodePrefix).toString();
        }

        public void warning(SAXParseException e) {
            if (Logger.isWarnEnabled(class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil)) {
                Logger.warn(this.getMessage(e), class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil);
            }
        }

        public void error(SAXParseException e) throws SAXParseException {
            if (Logger.isErrorEnabled(class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil)) {
                Logger.error(this.getMessage(e), class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil);
            }
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXParseException {
            if (Logger.isErrorEnabled(class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil)) {
                Logger.error(this.getMessage(e), class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil);
            }
            throw e;
        }

        public void warning(String domain, String key, XMLParseException e) {
            if (Logger.isWarnEnabled(class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil)) {
                Logger.warn(this.getMessage((Exception)e), class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil);
            }
        }

        public void error(String domain, String key, XMLParseException e) throws XNIException {
            if (Logger.isErrorEnabled(class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil)) {
                Logger.error(this.getMessage((Exception)e), class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil);
            }
            throw e;
        }

        public void fatalError(String domain, String key, XMLParseException e) {
            if (Logger.isErrorEnabled(class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil)) {
                Logger.error(this.getMessage((Exception)e), class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil);
            }
            throw e;
        }

        public String formatMessage(Locale locale, String key, Object[] args) throws MissingResourceException {
            String result = this.mDefaultFormatter.formatMessage(locale, key, args);
            if (result.startsWith(key + ": ")) {
                if (Logger.isInfoEnabled(class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil)) {
                    Logger.info("XML parser message key: " + key, class$com$raplix$rolloutexpress$systemmodel$XMLUtil == null ? (class$com$raplix$rolloutexpress$systemmodel$XMLUtil = XMLUtil.class$("com.raplix.rolloutexpress.systemmodel.XMLUtil")) : class$com$raplix$rolloutexpress$systemmodel$XMLUtil);
                }
                result = result.substring(key.length() + 2);
            }
            return Replace.replace(result, NAMESPACE_PREFIX, "");
        }
    }
}

