/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import org.xml.sax.SAXParseException;

public class SystemModelParseException
extends PersistenceManagerException {
    private static final String MSG_PARSE_ERROR = "PARSE_ERROR";
    private static final String MSG_LOCATED_PARSE_ERROR = "LOCATED_PARSE_ERROR";

    public SystemModelParseException(ROXMessage message) {
        super(message);
    }

    public SystemModelParseException(ROXMessage message, Throwable nested) {
        super(message, nested);
    }

    public SystemModelParseException(Exception e, String codePrefix) {
        this(SystemModelParseException.getMessage(e, codePrefix));
    }

    public static ROXMessage getMessage(Exception cause, String codePrefix) {
        int type;
        Object[] args;
        String code;
        if (cause instanceof SAXParseException) {
            code = codePrefix + MSG_LOCATED_PARSE_ERROR;
            SAXParseException pe = (SAXParseException)cause;
            args = new Object[]{pe.getMessage(), new Integer(pe.getLineNumber()), new Integer(pe.getColumnNumber())};
            type = 2000;
        } else {
            code = codePrefix + MSG_PARSE_ERROR;
            args = new Object[]{cause};
            type = 3000;
        }
        return new ROXMessage(code, args, type);
    }
}

