/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel;

import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.systemmodel.ObjectVisitorImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBVisitor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;

public abstract class ObjectVisitor {
    private ObjectVisitorImpl mVisitor;

    protected ObjectVisitor(ObjectVisitorImpl ovi) {
        this.setVisitor(ovi);
    }

    protected ObjectVisitorImpl getVisitor() {
        return this.mVisitor;
    }

    private void setVisitor(ObjectVisitorImpl ovi) {
        this.mVisitor = ovi;
    }

    public CompDBVisitor getCompDBVisitor() {
        return this.getVisitor().getCompDBVisitor();
    }

    public PlanDBVisitor getPlanDBVisitor() {
        return this.getVisitor().getPlanDBVisitor();
    }

    public TokenCallContext getTokenCallContext() {
        return this.getVisitor().getTokenVisitor().getTokenCallContext();
    }

    public void visit(ComponentRef r) throws Exception {
        this.getVisitor().getCompDBVisitor().visit(r);
    }

    public void visit(ExecStep s) throws Exception {
        this.getVisitor().getPlanDBVisitor().visit(s);
    }

    public void visit(VariableSettingsHolder h) throws Exception {
        this.getVisitor().getTokenVisitor().visit(h);
    }

    public void visit(ConfigTemplate c) throws Exception {
        this.getVisitor().getTokenVisitor().visit(c);
    }

    public void visit(InstalledComponentTargeter t) throws Exception {
        this.getVisitor().getPlanDBVisitor().visit(t);
    }

    public void visit(RepoComponentTargeter t) throws Exception {
        this.getVisitor().getPlanDBVisitor().visit(t);
    }

    public void visit(PromptParamList p) throws Exception {
        this.getVisitor().getPlanDBVisitor().visit(p);
    }

    public void visit(BooleanOperator o) throws Exception {
        this.getVisitor().getPlanDBVisitor().visit(o);
    }

    public void visitToken(String s) throws Exception {
        this.getVisitor().getTokenVisitor().visitToken(s);
    }

    public void visit(ExecStep[] s) throws Exception {
        for (int i = 0; i < s.length; ++i) {
            this.visit(s[i]);
        }
    }

    public void visitMutableVar(String s) throws Exception {
        this.getVisitor().getTokenVisitor().visitMutableVar(s);
    }
}

