/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel;

import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.systemmodel.ObjectTransformerImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBTransformer;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;

public abstract class ObjectTransformer {
    private ObjectTransformerImpl mTransformer;

    protected ObjectTransformer(ObjectTransformerImpl oti) {
        this.setTransformer(oti);
    }

    protected ObjectTransformerImpl getTransformer() {
        return this.mTransformer;
    }

    private void setTransformer(ObjectTransformerImpl oti) {
        this.mTransformer = oti;
    }

    public CompDBTransformer getCompDBTransformer() {
        return this.getTransformer().getCompDBTransformer();
    }

    public PlanDBTransformer getPlanDBTransformer() {
        return this.getTransformer().getPlanDBTransformer();
    }

    public TokenCallContext getTokenCallContext() {
        return this.getTransformer().getTokenTransformer().getTokenCallContext();
    }

    public ComponentRef transform(ComponentRef r) throws Exception {
        return this.getTransformer().getCompDBTransformer().transform(r);
    }

    public ExecStep transform(ExecStep s) throws Exception {
        return this.getTransformer().getPlanDBTransformer().transform(s);
    }

    public VariableSettingsHolder transform(VariableSettingsHolder h) throws Exception {
        return this.getTransformer().getTokenTransformer().transform(h);
    }

    public ConfigTemplate transform(ConfigTemplate c) throws Exception {
        return this.getTransformer().getTokenTransformer().transform(c);
    }

    public InstalledComponentTargeter transform(InstalledComponentTargeter t) throws Exception {
        return this.getTransformer().getPlanDBTransformer().transform(t);
    }

    public RepoComponentTargeter transform(RepoComponentTargeter t) throws Exception {
        return this.getTransformer().getPlanDBTransformer().transform(t);
    }

    public PromptParamList transform(PromptParamList p) throws Exception {
        return this.getTransformer().getPlanDBTransformer().transform(p);
    }

    public BooleanOperator transform(BooleanOperator o) throws Exception {
        return this.getTransformer().getPlanDBTransformer().transform(o);
    }

    public String transformToken(String s) throws Exception {
        return this.getTransformer().getTokenTransformer().transformToken(s);
    }
}

