/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util.arbitration;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.util.arbitration.Executable;
import java.util.HashMap;

public class StringArbitrator {
    private HashMap mCountedSemaphoreMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String inArbitrationKey, Executable inExecutable) throws ResourceException {
        if (inArbitrationKey == null) {
            throw new NullPointerException();
        }
        Object theSemaphore = this.increment(inArbitrationKey);
        try {
            Object object = theSemaphore;
            synchronized (object) {
                Object object2 = inExecutable.execute();
                return object2;
            }
        }
        finally {
            this.decrement(inArbitrationKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object increment(String inArbitrationKey) {
        HashMap hashMap = this.mCountedSemaphoreMap;
        synchronized (hashMap) {
            CountedSemaphore theSemaphore = (CountedSemaphore)this.mCountedSemaphoreMap.get(inArbitrationKey);
            if (theSemaphore == null) {
                theSemaphore = new CountedSemaphore();
                this.mCountedSemaphoreMap.put(inArbitrationKey, theSemaphore);
            }
            theSemaphore.increment();
            return theSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(String inArbitrationKey) {
        HashMap hashMap = this.mCountedSemaphoreMap;
        synchronized (hashMap) {
            CountedSemaphore theSemaphore = (CountedSemaphore)this.mCountedSemaphoreMap.get(inArbitrationKey);
            if (theSemaphore.decrement() == 0) {
                this.mCountedSemaphoreMap.remove(inArbitrationKey);
            }
        }
    }

    public Object getSyncObject() {
        return this.mCountedSemaphoreMap;
    }

    public boolean isNonZeroCount(String inArbitrationKey) {
        return this.mCountedSemaphoreMap.get(inArbitrationKey) != null;
    }

    class CountedSemaphore {
        private int mCount = 0;

        CountedSemaphore() {
        }

        void increment() {
            ++this.mCount;
        }

        int decrement() {
            return --this.mCount;
        }
    }
}

