/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.util.logger.Logger;
import java.util.Iterator;
import java.util.Vector;

public abstract class Sequence {
    private Vector mActions = new Vector();
    private int mBehavior = 0;

    public abstract void populateActions() throws Exception;

    public void addAction(Action inAction) {
        this.mActions.add(inAction);
    }

    public Sequence(int inBehavior) {
        this.mBehavior = inBehavior;
    }

    public Sequence() {
        this(0);
    }

    public Sequence(boolean inNoUncaughtExceptions) {
        this(inNoUncaughtExceptions ? 0 : 1);
    }

    public void exec() throws ResourceException {
        try {
            this.populateActions();
        }
        catch (Throwable t) {
            MiscUtils.resourceThrow(t);
        }
        Throwable theRetainedThrowable = null;
        Iterator theIter = this.mActions.iterator();
        while (theIter.hasNext()) {
            Action theAction = (Action)theIter.next();
            try {
                theAction.exec();
            }
            catch (Throwable t) {
                if (this.mBehavior == 0 && theRetainedThrowable == null) {
                    theRetainedThrowable = t;
                    continue;
                }
                if (!Logger.isErrorEnabled(this)) continue;
                Logger.error(theAction.mLogMsg, t, this);
            }
        }
        if (this.mBehavior == 0 && theRetainedThrowable != null) {
            MiscUtils.resourceThrow(theRetainedThrowable);
        }
    }

    public void execSafe() {
        block2: {
            try {
                this.exec();
            }
            catch (Throwable t) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("Error caught in execSafe", t, this);
            }
        }
    }

    public static abstract class Action {
        String mLogMsg = "";

        public Action(String inLogMsg) {
            this.mLogMsg = inLogMsg;
        }

        public Action() {
        }

        public abstract void exec() throws Exception;
    }

    public static interface Behavior {
        public static final int THROW_FIRST_ERR_AT_END = 0;
        public static final int SUPRESS_ALL_ERRS = 1;
    }
}

