/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util;

import com.raplix.util.platform.common.PlatformUtil;
import java.io.File;

public class ResourceStringUtils {
    private static final char sNonNativeSeparator = (char)(File.separatorChar == '/' ? 92 : 47);
    private static final String sDoubleSeparator = "" + File.separatorChar + File.separatorChar;

    public static int dictionaryCompare(String inS1, String inS2) {
        int theResult = inS1.compareToIgnoreCase(inS2);
        if (theResult == 0) {
            theResult = inS1.compareTo(inS2);
        }
        return theResult;
    }

    public static int getSeparatorIdx(String inString, int inFromIdx) {
        int theFwdIdx = inString.indexOf(47, inFromIdx);
        int theBackIdx = inString.indexOf(92, inFromIdx);
        if (theFwdIdx == -1) {
            return theBackIdx;
        }
        if (theBackIdx == -1) {
            return theFwdIdx;
        }
        return theFwdIdx < theBackIdx ? theFwdIdx : theBackIdx;
    }

    public static boolean endsInSeparator(String inString) {
        int theLength = inString.length();
        if (theLength == 0) {
            return false;
        }
        char theLastChar = inString.charAt(theLength - 1);
        return theLastChar == '/' || theLastChar == '\\';
    }

    public static String getURLFileName(String inURL) {
        int theLastBakSlashIdx;
        int theLastFwdSlashIdx = inURL.lastIndexOf(47);
        int theLastSlashIdx = theLastFwdSlashIdx > (theLastBakSlashIdx = inURL.lastIndexOf(92)) ? theLastFwdSlashIdx : theLastBakSlashIdx;
        return inURL.substring(theLastSlashIdx + 1, inURL.length());
    }

    public static String coerceSeparators(String inPath, char inSeparator) {
        return inPath.replace(inSeparator == '/' ? (char)'\\' : '/', inSeparator);
    }

    public static String toNativePath(String inString) {
        int theFirstDoubleSepIdx = inString.indexOf(sDoubleSeparator);
        if (inString.indexOf(sNonNativeSeparator) == -1 && theFirstDoubleSepIdx == -1) {
            return inString;
        }
        StringBuffer theStringBuffer = new StringBuffer();
        int theLength = inString.length();
        boolean prevWasSeparator = false;
        for (int i = 0; i < theLength; ++i) {
            char theChar = inString.charAt(i);
            if (theChar == sNonNativeSeparator) {
                theChar = File.separatorChar;
            }
            if (theChar == File.separatorChar) {
                if (prevWasSeparator && (i != 1 || !PlatformUtil.isWin32())) continue;
                theStringBuffer.append(File.separatorChar);
                prevWasSeparator = true;
                continue;
            }
            theStringBuffer.append(theChar);
            prevWasSeparator = false;
        }
        return theStringBuffer.toString();
    }
}

