/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util;

import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.exception.ResourceIOException;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.util.memix.Host;
import com.raplix.util.memix.MemixIllegalArgumentException;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.SessionCommand;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileNode;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.groups.GroupTableEntry;
import com.raplix.util.memix.posix.PosixHost;
import com.raplix.util.memix.users.UserTableEntry;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class ResourceMemixUtils
implements Messages {
    public static final long CHMOD_PERMS_MASK = 511L;

    public static void chmod(SessionCommand inMemixSession, File inFile, long inPermBits) throws ResourceException {
        long thePermsSet = inPermBits & 0x1FFL;
        String theOctalPerms = Integer.toOctalString((int)thePermsSet);
        String theExecLine = "chmod " + theOctalPerms + " " + ResourceMemixUtils.formatPathForExec(inFile.getAbsolutePath());
        try {
            inMemixSession.exec(theExecLine);
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0356", new Object[]{"" + inPermBits, inFile, e.getMessage()});
        }
    }

    public static void chown(SessionCommand inMemixSession, File inFile, String inOwnerName) throws ResourceException {
        String theExecLine = "chown " + inOwnerName + " " + ResourceMemixUtils.formatPathForExec(inFile.getAbsolutePath());
        try {
            inMemixSession.exec(theExecLine);
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0357", new Object[]{inOwnerName, inFile, e.getMessage()});
        }
    }

    public static void chgrp(SessionCommand inMemixSession, File inFile, String inGroupName) throws ResourceException {
        String theExecLine = "chgrp " + inGroupName + " " + ResourceMemixUtils.formatPathForExec(inFile.getAbsolutePath());
        try {
            inMemixSession.exec(theExecLine);
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0358", new Object[]{inGroupName, inFile, e.getMessage()});
        }
    }

    public static void readPosixPerms(SessionCommand inMemixSession, File inFile, PosixNodePerms outPerms) throws ResourceException {
        Node theNode = null;
        Host theHost = null;
        try {
            theHost = inMemixSession.getHost();
            FileSystem theFileSys = theHost.getFileSystem();
            FID theID = new FID(ResourceMemixUtils.formatPath(inFile.getAbsolutePath()));
            NodePointer theNodePtr = theFileSys.split(inMemixSession, theID);
            boolean exists = theFileSys.exists(inMemixSession, theNodePtr);
            theNode = theFileSys.getNode((ProcessContext)inMemixSession, theNodePtr, true);
            outPerms.setPermBits(theNode.getMask().getMask());
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
        UserTableEntry theUserTableEntry = null;
        try {
            theUserTableEntry = theHost.getUsers().getEntry(theNode.getUserID());
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0359", new Object[]{inFile, e.getMessage()});
        }
        if (theUserTableEntry == null) {
            throw new ResourceException("rsrc.msg0360", new Object[]{inFile});
        }
        outPerms.setOwnerName(theUserTableEntry.getName());
        outPerms.setOwnerID(-1L);
        GroupTableEntry theGroupTableEntry = null;
        try {
            theGroupTableEntry = theHost.getGroups().getEntry(theNode.getGroupID());
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0361", new Object[]{inFile, e.getMessage()});
        }
        if (theGroupTableEntry == null) {
            throw new ResourceException("rsrc.msg0362", new Object[]{inFile});
        }
        outPerms.setGroupName(theGroupTableEntry.getName());
        outPerms.setGroupID(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public static void createFile(SessionCommand inMemixSession, File inFile, SubnodeType inSubnodeType, long inSize, long inTime) throws ResourceException {
        try {
            void var11_10;
            Node theNode;
            FileSystem theFileSys = inMemixSession.getHost().getFileSystem();
            FID theID = new FID(ResourceMemixUtils.formatPath(inFile.getAbsolutePath()));
            theFileSys.mkdirs(inMemixSession, theID);
            NodePointer theNodePtr = theFileSys.split(inMemixSession, theID);
            boolean exists = theFileSys.exists(inMemixSession, theNodePtr);
            if (inSubnodeType.equals(SubnodeType.DIRECTORY)) {
                theNode = exists ? theFileSys.getNode((ProcessContext)inMemixSession, theNodePtr, true) : theFileSys.mkdir(inMemixSession, theID);
            } else if (inSubnodeType.equals(SubnodeType.FILE)) {
                if (exists) {
                    theNodePtr.getParent().removeChild(inMemixSession, theNodePtr.getID());
                }
                theNode = theFileSys.creat(inMemixSession, theID);
                theNode.setSize(inMemixSession, inSize);
            } else if (inSubnodeType.equals(SubnodeType.SYMLINK)) {
                if (exists) {
                    theNodePtr.getParent().removeChild(inMemixSession, theNodePtr.getID());
                }
                theNode = theFileSys.creat(inMemixSession, theID);
            } else {
                throw new UnsupportedOperationException();
            }
            var11_10.setModified(inMemixSession, inTime);
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
    }

    public static String formatPath(String inString) {
        char theDriveChar;
        String theMemixPath = inString.replace('\\', '/');
        if (theMemixPath.length() >= 3 && theMemixPath.charAt(1) == ':' && ((theDriveChar = theMemixPath.charAt(0)) >= 'A' && theDriveChar <= 'Z' || theDriveChar >= 'a' && theDriveChar <= 'z') && theMemixPath.charAt(2) == '/' && theMemixPath.indexOf(58, 2) == -1) {
            theMemixPath = theMemixPath.substring(2, theMemixPath.length());
        }
        return theMemixPath;
    }

    public static String formatPathForExec(String inString) {
        String theMemixPath = ResourceMemixUtils.formatPath(inString);
        StringBuffer theSB = new StringBuffer();
        int theMemixPathLength = theMemixPath.length();
        for (int i = 0; i < theMemixPathLength; ++i) {
            char theChar = theMemixPath.charAt(i);
            if (theChar == ' ') {
                theSB.append("\\ ");
                continue;
            }
            theSB.append(theChar);
        }
        theMemixPath = theSB.toString();
        return theMemixPath;
    }

    public static void ensureDirExists(SessionCommand inMemixSession, File inDir) throws ResourceIOException {
        String theAbsDirString = inDir.getAbsolutePath();
        try {
            inMemixSession.exec("mkdir -p " + ResourceMemixUtils.formatPathForExec(theAbsDirString));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() == null || e.getMessage().indexOf("(025037)") == -1) {
                throw new ResourceIOException("rsrc.msg0209", (Throwable)e, new Object[]{theAbsDirString});
            }
        }
        catch (Exception ex) {
            throw new ResourceIOException("rsrc.msg0210", (Throwable)ex, new Object[]{theAbsDirString});
        }
    }

    public static void copyFile(SessionCommand inMemixSession, File inSrc, File inDst) throws Exception {
        ResourceMemixUtils.mirrorFile(inMemixSession, inSrc);
        inMemixSession.exec("cp " + ResourceMemixUtils.formatPathForExec(inSrc.getAbsolutePath()) + " " + ResourceMemixUtils.formatPath(inDst.getAbsolutePath()));
    }

    public static boolean isAccessibleDirectory(SessionCommand inMemixSession, File inPath) {
        try {
            inMemixSession.exec("cd " + ResourceMemixUtils.formatPathForExec(inPath.getAbsolutePath()));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isFile(SessionCommand inMemixSession, File inNode) {
        return ResourceMemixUtils.nodeExists(inMemixSession, inNode) && !ResourceMemixUtils.isAccessibleDirectory(inMemixSession, inNode);
    }

    public static String[] listFiles(SessionCommand inMemixSession, File inDir) throws ResourceException {
        try {
            Node theNode;
            Host theHost = inMemixSession.getHost();
            if (!(theHost instanceof PosixHost)) {
                throw new ResourceException("rsrc.msg0455");
            }
            PosixHost thePosixHost = (PosixHost)theHost;
            FileSystem theFileSys = theHost.getFileSystem();
            FID path = new FID(ResourceMemixUtils.formatPath(inDir.getAbsolutePath()));
            try {
                theNode = theFileSys.getNode((ProcessContext)inMemixSession, path, false);
            }
            catch (MemixIllegalArgumentException ex) {
                ResourceMemixUtils.assertDeadLinkPossible(ex);
                theNode = theFileSys.getNode((ProcessContext)inMemixSession, path, false);
            }
            if (!(theNode instanceof DirectoryNode)) {
                return null;
            }
            NodePointer pointer = new NodePointer((DirectoryNode)theNode, path);
            DirectoryNode theDirNode = pointer.getParent();
            FID[] theChildren = theDirNode.getChildren(inMemixSession);
            Vector<String> theFileNames = new Vector<String>();
            for (int i = 0; i < theChildren.length; ++i) {
                String theNodeName = thePosixHost.toName(theChildren[i]);
                if ((theNodeName = ResourceStringUtils.getURLFileName(theNodeName)).equals(".") || theNodeName.equals("..")) continue;
                theFileNames.add(theNodeName);
            }
            return theFileNames.toArray(new String[0]);
        }
        catch (ResourceException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ResourceException(e);
        }
    }

    private static void assertDeadLinkPossible(MemixIllegalArgumentException ex) throws ResourceException {
        String msg = ex.getMessage();
        if (msg != null && msg.indexOf("(025039)") != -1) {
            return;
        }
        throw new ResourceException(ex);
    }

    public static void removeDirOrFile(SessionCommand inMemixSession, File inDirOrFile) throws ResourceException {
        try {
            if (ResourceMemixUtils.nodeExists(inMemixSession, inDirOrFile)) {
                inMemixSession.exec("rm -R " + ResourceMemixUtils.formatPathForExec(inDirOrFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
    }

    public static boolean nodeExists(SessionCommand inMemixSession, File inFile) {
        try {
            FID theFID = new FID(ResourceMemixUtils.formatPath(inFile.getAbsolutePath()));
            NodePointer theNodePtr = inMemixSession.getHost().getFileSystem().split(inMemixSession, theFID);
            return inMemixSession.getHost().getFileSystem().exists(inMemixSession, theNodePtr);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void mirrorFile(SessionCommand inMemixSession, File inFile) throws ResourceException {
        if (!inFile.exists()) {
            throw new ResourceException("rsrc.msg0211", new Object[]{inFile});
        }
        try {
            FID theFID = new FID(ResourceMemixUtils.formatPath(inFile.getAbsolutePath()));
            try {
                inMemixSession.exec("touch -p " + theFID.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            FileNode theFileNode = inMemixSession.getHost().getFileSystem().getFileNode(inMemixSession, theFID);
            theFileNode.setCustom("data", inFile);
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
    }

    public static String getOutputString(SessionCommand inSession, String inCmdString) throws ResourceException {
        try {
            StringWriter sOut = new StringWriter();
            PrintWriter pOut = new PrintWriter(sOut);
            StringWriter sErr = new StringWriter();
            PrintWriter pErr = new PrintWriter(sErr);
            inSession.getProcessEntry().setStdout(inSession, pOut);
            inSession.getProcessEntry().setStderr(inSession, pErr);
            inSession.exec(inCmdString);
            pErr.close();
            pOut.close();
            return sOut.toString();
        }
        catch (Exception e) {
            throw new ResourceException(e);
        }
    }

    private static Node getMemixNode(SessionCommand inMemixSession, File inMemixFile) throws ResourceException {
        boolean nodeExists = false;
        FileSystem theFileSystem = null;
        FID theFID = null;
        try {
            theFileSystem = inMemixSession.getHost().getFileSystem();
            theFID = new FID(ResourceMemixUtils.formatPath(inMemixFile.getAbsolutePath()));
            NodePointer theNodePtr = theFileSystem.split(inMemixSession, theFID);
            nodeExists = theFileSystem.exists(inMemixSession, theNodePtr);
        }
        catch (Exception e) {
            nodeExists = false;
        }
        if (!nodeExists) {
            return null;
        }
        Node theMemixNode = theFileSystem.getNode((ProcessContext)inMemixSession, theFID, false);
        return theMemixNode;
    }

    public static SubnodeType getSubnodeType(SessionCommand inMemixSession, File inMemixFile) throws ResourceException {
        Node theNode = ResourceMemixUtils.getMemixNode(inMemixSession, inMemixFile);
        if (theNode == null) {
            return null;
        }
        if (theNode instanceof FileNode) {
            return SubnodeType.FILE;
        }
        if (theNode instanceof DirectoryNode) {
            return SubnodeType.DIRECTORY;
        }
        if (theNode instanceof LinkNode) {
            return SubnodeType.SYMLINK;
        }
        throw new ResourceException("rsrc.UNKNOWN_MEMIX_NODE_TYPE", new Object[]{inMemixFile.getAbsolutePath()});
    }

    public static long getNodeSize(SessionCommand inMemixSession, File inMemixFile) throws ResourceException {
        Node theNode = ResourceMemixUtils.getMemixNode(inMemixSession, inMemixFile);
        if (theNode == null) {
            return 0L;
        }
        if (theNode instanceof FileNode) {
            return theNode.getSize();
        }
        return 0L;
    }

    public static void removeNode(SessionCommand inMemixSession, File inMemixFile) throws ResourceException {
        Node theNode = ResourceMemixUtils.getMemixNode(inMemixSession, inMemixFile);
        if (theNode == null) {
            return;
        }
        try {
            if (theNode instanceof LinkNode) {
                theNode.getParent().removeChild(inMemixSession.getHost().getInitContext(), theNode.getFileID());
            } else {
                ResourceMemixUtils.removeDirOrFile(inMemixSession, inMemixFile);
            }
        }
        catch (Exception e) {
            throw new ResourceException("rsrc.msg0245", (Throwable)e, new Object[]{inMemixFile});
        }
    }
}

