/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.PlatformPermissionFactory;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.StreamClosure;
import com.raplix.util.Security;
import com.raplix.util.Util;
import com.raplix.util.file.FileUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.hpux.StatVFS;
import com.raplix.util.platform.posix.Link;
import com.raplix.util.platform.windows.WindowsServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceFileUtils
implements Messages {
    private static final boolean sIsPosix = PlatformUtil.isPOSIX();
    private static final Object sTmpCreateArbitrator = new Object();
    private static final int MAX_ATTEMPTS = 5;

    public static ObjectInputStream getObjectInputStreamFromZipEntry(ZipFile inZipFile, ZipEntry inZipEntry) throws ResourceException {
        long theSize = inZipEntry.getSize();
        if (theSize > Integer.MAX_VALUE) {
            throw new ResourceException("rsrc.msg0435");
        }
        InputStream theInputStream = null;
        try {
            theInputStream = inZipFile.getInputStream(inZipEntry);
        }
        catch (IOException e) {
            throw new ResourceException("rsrc.msg0436", (Throwable)e);
        }
        byte[] theBytes = new byte[(int)theSize];
        ResourceFileUtils.readStreamToBytes(theInputStream, theBytes);
        try {
            return new ObjectInputStream(new ByteArrayInputStream(theBytes));
        }
        catch (StreamCorruptedException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public static long getBytesFreeOnVolume(File inFile) throws ResourceException {
        if (PlatformUtil.isSolaris()) {
            com.raplix.util.platform.solaris.StatVFS theStatVFS;
            try {
                theStatVFS = new com.raplix.util.platform.solaris.StatVFS(inFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
            return (Security.isRootOrHasSetuidPrivileges() ? theStatVFS.getBFree() : theStatVFS.getBAvail()) * theStatVFS.getFrSize();
        }
        if (PlatformUtil.isAix()) {
            com.raplix.util.platform.aix.StatVFS theStatVFS;
            try {
                theStatVFS = new com.raplix.util.platform.aix.StatVFS(inFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
            return (Security.isRootOrHasSetuidPrivileges() ? theStatVFS.getBFree() : theStatVFS.getBAvail()) * theStatVFS.getFrSize();
        }
        if (PlatformUtil.isHpux()) {
            StatVFS theStatVFS;
            try {
                theStatVFS = new StatVFS(inFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new ResourceException(e);
            }
            return (Security.isRootOrHasSetuidPrivileges() ? theStatVFS.getBFree() : theStatVFS.getBAvail()) * theStatVFS.getFrSize();
        }
        if (PlatformUtil.isWin32()) {
            try {
                return WindowsServices.getInstance().getDriveFreeSpace(inFile);
            }
            catch (Exception e) {
                throw new ResourceException("rsrc.msg0440", (Throwable)e, new Object[]{inFile});
            }
        }
        if (Logger.isWarnEnabled(ResourceFileUtils.class.getName())) {
            Logger.warn(ROXMessageManager.messageAsString("rsrc.GETBYTESFREEONVOLUME_NA"), ResourceFileUtils.class.getName());
        }
        return 0x3FFFFFFFFFFFFFFFL;
    }

    public static long getBytesInDir(File inDir) {
        if (ResourceFileUtils.getLinkTarget(inDir) != null) {
            return 0L;
        }
        if (inDir.isFile()) {
            return inDir.length();
        }
        if (!inDir.isDirectory()) {
            return 0L;
        }
        File[] theSubs = inDir.listFiles();
        if (theSubs == null) {
            return 0L;
        }
        long theTotal = 0L;
        for (int i = 0; i < theSubs.length; ++i) {
            theTotal += ResourceFileUtils.getBytesInDir(theSubs[i]);
        }
        return theTotal;
    }

    public static void writeStreamToFile(final File inSubFile, long inTime, final InputStream inInputStream) throws ResourceException {
        new StreamClosure(){

            public Object innerExec() throws IOException {
                Util.copyStream(inInputStream, this.addOutput(inSubFile));
                return null;
            }
        }.exec();
        inSubFile.setLastModified(inTime);
    }

    public static void moveData(File inSrc, File inDst) throws ResourceException {
        try {
            inDst = inDst.getCanonicalFile();
            inSrc = inSrc.getCanonicalFile();
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        ResourceFileUtils.deleteDirectory(inDst);
        if (!inDst.getParentFile().mkdirs() && !inDst.getParentFile().isDirectory()) {
            throw new ResourceException("rsrc.UNABLE_TO_CREATE_DIR", new Object[]{inDst.getParentFile()});
        }
        if (inDst.exists()) {
            throw new ResourceException("rsrc.msg0130", new Object[]{inDst});
        }
        if (!inSrc.renameTo(inDst)) {
            if (Logger.isDebugEnabled(ResourceFileUtils.class.getName())) {
                Logger.debug(ROXMessageManager.messageAsString("rsrc.MANUAL_FILE_COPY", new Object[]{inSrc, inDst}), ResourceFileUtils.class.getName());
            }
            ResourceFileUtils.copyData(inSrc, inDst);
            ResourceFileUtils.deleteDirectory(inSrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyData(File inSrc, File inDst) throws ResourceException {
        File theCanonicalDst = null;
        boolean success = false;
        try {
            try {
                theCanonicalDst = inDst.getCanonicalFile();
                ResourceFileUtils.deleteDirectory(theCanonicalDst);
                ResourceFileUtils.copyDataSub(inSrc.getCanonicalFile(), theCanonicalDst);
                return;
            }
            catch (Throwable t) {
                MiscUtils.resourceThrow(t);
                Object var6_5 = null;
                if (success) return;
                if (theCanonicalDst == null) return;
                ResourceFileUtils.deleteDirectorySnuff(theCanonicalDst);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (success || theCanonicalDst == null) throw throwable;
            ResourceFileUtils.deleteDirectorySnuff(theCanonicalDst);
            throw throwable;
        }
    }

    private static void copyDataSub(final File inSrc, final File inDst) throws ResourceException {
        if (!inDst.getParentFile().mkdirs() && !inDst.getParentFile().isDirectory()) {
            throw new ResourceException("rsrc.UNABLE_TO_CREATE_DIR", new Object[]{inDst.getParentFile()});
        }
        String theLinkTarget = ResourceFileUtils.getLinkTarget(inSrc);
        if (theLinkTarget != null) {
            ResourceFileUtils.createLink(inDst, theLinkTarget);
            return;
        }
        if (!inSrc.exists()) {
            throw new ResourceException("rsrc.UNABLE_TO_FIND_SRC_DATA", new Object[]{inSrc});
        }
        if (inSrc.isFile()) {
            new StreamClosure(){

                public Object innerExec() throws ResourceException, FileNotFoundException {
                    ResourceFileUtils.writeStreamToFile(inDst, inSrc.lastModified(), this.addInput(inSrc));
                    return null;
                }
            }.exec();
            return;
        }
        if (!inSrc.isDirectory()) {
            throw new ResourceException("rsrc.UNEXPECTED_SRC_DATA_TYPE", new Object[]{inSrc});
        }
        if (!inDst.mkdirs()) {
            throw new ResourceException("rsrc.UNABLE_TO_CREATE_DIR", new Object[]{inDst});
        }
        File[] theSubfiles = inSrc.listFiles();
        for (int i = 0; i < theSubfiles.length; ++i) {
            File theSubfile = theSubfiles[i];
            ResourceFileUtils.copyDataSub(theSubfile, new File(inDst, theSubfile.getName()));
        }
    }

    public static void deleteDirectory(File inNode) throws ResourceException {
        try {
            FileUtil.ensureDeleted(inNode);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public static void readStreamToBytes(InputStream inStreamIn, byte[] outBytes) throws ResourceException {
        int theTotalBytesRead = 0;
        while (true) {
            int theBytesRead = 0;
            int theMaxToRead = outBytes.length - theTotalBytesRead;
            try {
                if (theMaxToRead == 0) {
                    byte[] theStraggler = new byte[1];
                    theBytesRead = inStreamIn.read(theStraggler, 0, 1);
                    if (theBytesRead != -1) {
                        if (theBytesRead == 0 && Logger.isErrorEnabled(ResourceFileUtils.class.getName())) {
                            Logger.error("Zero was returned by theInstream.read()", ResourceFileUtils.class.getName());
                        }
                        throw new ResourceException("rsrc.msg0353");
                    }
                } else {
                    theBytesRead = inStreamIn.read(outBytes, theTotalBytesRead, theMaxToRead);
                }
            }
            catch (IOException e) {
                throw new ResourceException("rsrc.msg0354", (Throwable)e);
            }
            if (theBytesRead == -1) {
                if (theTotalBytesRead != outBytes.length) {
                    throw new ResourceException("rsrc.msg0355");
                }
                return;
            }
            theTotalBytesRead += theBytesRead;
        }
    }

    public static String getLinkTarget(File inFile) {
        if (!sIsPosix) {
            return null;
        }
        try {
            return Link.read(inFile.getAbsolutePath());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SubnodeType getSubnodeType(File inNode) {
        if (ResourceFileUtils.getLinkTarget(inNode) != null) {
            return SubnodeType.SYMLINK;
        }
        if (!inNode.exists()) {
            return null;
        }
        return inNode.isDirectory() ? SubnodeType.DIRECTORY : SubnodeType.FILE;
    }

    public static void createLink(File inFile, String inLinkTarget, PosixNodePerms inPerms) throws ResourceException {
        if (!sIsPosix) {
            throw new ResourceException("rsrc.msg0459", new Object[]{inFile});
        }
        ResourceFileUtils.deleteDirectory(inFile);
        inFile.getAbsoluteFile().getParentFile().mkdirs();
        try {
            Link.creat(inLinkTarget, inFile.getAbsolutePath());
        }
        catch (RuntimeException e) {
            throw new ResourceException("rsrc.msg0460", (Throwable)e, new Object[]{inFile});
        }
        if (inPerms != null) {
            PlatformPermissionFactory.getInstance().applyPerms(inPerms, inFile);
        }
    }

    public static void createLink(File inFile, String inLinkTarget) throws ResourceException {
        ResourceFileUtils.createLink(inFile, inLinkTarget, null);
    }

    public static void deleteLink(File inFile) throws ResourceException {
        try {
            FileUtil.ensureDeleted(inFile);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public static InputStream toInputStream(Serializable inSerializable) throws ResourceException {
        ByteArrayOutputStream theByteOutStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream theObjectOutStream = new ObjectOutputStream(theByteOutStream);
            theObjectOutStream.writeObject(inSerializable);
            theObjectOutStream.close();
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        byte[] theManifestBytes = theByteOutStream.toByteArray();
        return new ByteArrayInputStream(theManifestBytes);
    }

    public static File createTempFolder(String inPartialName) throws ResourceException {
        File theFolder = null;
        int theNumAttempts = 0;
        Object object = sTmpCreateArbitrator;
        synchronized (object) {
            do {
                try {
                    theFolder = File.createTempFile(inPartialName, null);
                }
                catch (IOException e) {
                    throw new ResourceException(e);
                }
                theFolder.delete();
                if (!theFolder.mkdirs()) continue;
                return theFolder;
            } while (theNumAttempts++ <= 5);
            throw new ResourceException("rsrc.UNABLE_TO_CREATE_DIR", new Object[]{theFolder});
        }
    }

    public static File createTempFile(String inPartialName) throws ResourceException {
        Object object = sTmpCreateArbitrator;
        synchronized (object) {
            try {
                return File.createTempFile(inPartialName, null);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
    }

    public static void deleteDirectorySnuff(File inFile) {
        block2: {
            try {
                ResourceFileUtils.deleteDirectory(inFile);
            }
            catch (Throwable t) {
                if (!Logger.isErrorEnabled(ResourceFileUtils.class.getName())) break block2;
                Logger.error("Unable to delete: " + inFile, ResourceFileUtils.class.getName());
            }
        }
    }
}

