/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util;

import com.raplix.rolloutexpress.resource.Messages;
import com.raplix.rolloutexpress.resource.compression.SummedCompressionInputStream;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.StreamClosure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MiscUtils
implements Messages {
    public static void throwUPE(long inID) throws ResourceException {
        throw new ResourceException("rsrc.UNRECOVERABLE_PROGRAMMER_ERROR", new Object[]{"" + inID});
    }

    public static void resourceThrow(Throwable inError) throws ResourceException {
        throw MiscUtils.resourceWrap(inError);
    }

    public static byte[] compressAndGetMD5(final File inSrcToCompress, final File inDstCompressed) throws ResourceException {
        return (byte[])new StreamClosure(){

            public Object innerExec() throws ResourceException, IOException {
                SummedCompressionInputStream theCompressedStream = new SummedCompressionInputStream(this.addInput(inSrcToCompress));
                ResourceFileUtils.writeStreamToFile(inDstCompressed, inSrcToCompress.lastModified(), theCompressedStream);
                return theCompressedStream.getDigest();
            }
        }.exec();
    }

    public static byte[] compressAndGetMD5(final InputStream inSrcToCompress, final File inDstCompressed) throws ResourceException {
        return (byte[])new StreamClosure(){

            public Object innerExec() throws ResourceException, IOException {
                SummedCompressionInputStream theCompressedStream = new SummedCompressionInputStream(this.add(inSrcToCompress));
                ResourceFileUtils.writeStreamToFile(inDstCompressed, 0L, theCompressedStream);
                return theCompressedStream.getDigest();
            }
        }.exec();
    }

    public static void throwNPEIfNull(Object inObject) {
        if (inObject == null) {
            throw new NullPointerException();
        }
    }

    public static ResourceException resourceWrap(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ResourceException) {
            return (ResourceException)t;
        }
        return new ResourceException(t);
    }

    public static void resourceSleep(long inMillis) throws ResourceException {
        try {
            Thread.sleep(inMillis);
        }
        catch (InterruptedException e) {
            throw new ResourceException(e);
        }
    }
}

