/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util;

import com.raplix.rolloutexpress.resource.exception.ResourceException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Checksummer {
    private static final int BYTES_IN_LONG = 8;
    private MessageDigest mMD5;
    private byte[] mBytes = new byte[8];

    public Checksummer() throws ResourceException {
        try {
            this.mMD5 = MessageDigest.getInstance("MD5");
            if (this.mMD5 == null) {
                throw new ResourceException("rsrc.msg0394");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new ResourceException(e);
        }
    }

    public void update(long inLong) {
        for (int i = 0; i < 8; ++i) {
            this.mBytes[i] = (byte)(inLong >> i * 8);
        }
        this.mMD5.update(this.mBytes, 0, 8);
    }

    public boolean equals(Object inOther) {
        if (inOther == null || !(inOther instanceof Checksummer)) {
            return false;
        }
        Checksummer theOther = (Checksummer)inOther;
        try {
            return Arrays.equals(((MessageDigest)this.mMD5.clone()).digest(), ((MessageDigest)theOther.mMD5.clone()).digest());
        }
        catch (CloneNotSupportedException e) {
            IllegalStateException theEx = new IllegalStateException();
            theEx.initCause(e);
            throw theEx;
        }
    }
}

