/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.util;

import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.util.CallbackDispatcher;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.util.Semaphore;

public abstract class CallbackClosure {
    private Semaphore mSemaphore = new Semaphore();
    private Throwable mCBError = null;
    private CallbackDispatcher mCallbackDispatcherRef;
    private RoxAddress mOtherAddress;
    private RPCManager mRPCRef;

    public abstract String getKey();

    public abstract Object run() throws Exception;

    public abstract void callback(CBParm var1, RoxAddress var2) throws Exception;

    public CallbackClosure(CallbackDispatcher inCallbackDispatcher, RoxAddress inOtherAddress, RPCManager inRPCManager) {
        MiscUtils.throwNPEIfNull(inCallbackDispatcher);
        this.mCallbackDispatcherRef = inCallbackDispatcher;
        this.mOtherAddress = inOtherAddress;
        this.mRPCRef = inRPCManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start() throws ResourceException {
        Object theResult = null;
        this.mCallbackDispatcherRef.register(this);
        try {
            theResult = this.run();
        }
        catch (Exception e) {
            MiscUtils.resourceThrow(e);
        }
        finally {
            this.mCallbackDispatcherRef.unregister(this);
        }
        return theResult;
    }

    protected void waitForCallbacks() throws ResourceException {
        try {
            this.mSemaphore.P();
        }
        catch (InterruptedException e) {
            throw new ResourceException(e);
        }
        if (this.mCBError != null) {
            MiscUtils.resourceThrow(this.mCBError);
        }
    }

    protected void execCallback(CBParm inCBObj) {
        try {
            RoxAddress theInvokerAddress = this.mRPCRef.getInvokerAddress();
            if (theInvokerAddress == null || !theInvokerAddress.equals(this.mOtherAddress)) {
                MiscUtils.throwUPE(5072129L);
            }
            this.callback(inCBObj, theInvokerAddress);
        }
        catch (Throwable t) {
            this.mCBError = t;
            this.markAsDone();
        }
    }

    protected RoxAddress getOtherAddress() {
        return this.mOtherAddress;
    }

    protected void markAsDone() {
        this.mSemaphore.V();
    }

    public static interface CBParm
    extends RPCSerializable {
        public String getKey();
    }
}

