/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.repopaths;

import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.repopaths.ClassicPathLogic;
import com.raplix.rolloutexpress.resource.repopaths.FilenameEscape;
import com.raplix.rolloutexpress.resource.repopaths.PathLogicIdx;
import com.raplix.rolloutexpress.resource.repopaths.RedmondPathLogic;
import java.io.File;

public abstract class RepoPathLogic {
    public static final String UNICODE_STRING_PRFX = "_ucodestr_";
    private static RepoPathLogic[] sPathLogics = new RepoPathLogic[]{new ClassicPathLogic(), new RedmondPathLogic()};
    public static final String FWD_SLASH = "/";
    static final String sFileSeparator = "_FILENAME_/".toUpperCase();
    static final String sCustomSeparator = "_CUSTOM_".toUpperCase();

    private static RepoPathLogic getPathLogic(PathLogicIdx inIdx) {
        for (int i = 0; i < sPathLogics.length; ++i) {
            RepoPathLogic theLogic = sPathLogics[i];
            if (!theLogic.getIdx().equals(inIdx)) continue;
            return theLogic;
        }
        throw new IllegalStateException();
    }

    public static String getSpecRepoRelDir(PathLogicIdx inIdx, ResourceSpec inResourceSpec) {
        return RepoPathLogic.getPathLogic(inIdx).getSpecRepoRelDir(inResourceSpec);
    }

    public static File getPathLogicSubDir(PathLogicIdx inIdx, ResourceSubsysImpl inRsrcCtx) {
        return new File(inRsrcCtx.getAbsRepoRoot().toString(), RepoPathLogic.getPathLogic(inIdx).getSubDir());
    }

    protected abstract PathLogicIdx getIdx();

    protected abstract String getSubDir();

    protected abstract String getSpecRepoRelDir(ResourceSpec var1);

    public static File[] getNonVirtualRsrcDirs(ResourceSubsysImpl inRsrcCtx) {
        String theRepoRoot = inRsrcCtx.getAbsRepoRoot().toString();
        if (inRsrcCtx.isServer()) {
            return new File[]{new File(theRepoRoot, ClassicPathLogic.RSRC_SUB_DIR_NAME), new File(theRepoRoot, RedmondPathLogic.RSRC_SUB_DIR_NAME)};
        }
        return new File[]{new File(theRepoRoot, RedmondPathLogic.RSRC_SUB_DIR_NAME)};
    }

    protected String getSpecRepoRelDirCommon(ResourceSpec inResourceSpec) {
        String theResultString;
        String theEscapedString;
        StringBuffer theResult = new StringBuffer(this.getSubDir());
        String theResourceName = inResourceSpec.getName();
        int theLastSepIdx = theResourceName.lastIndexOf(FWD_SLASH);
        if (theLastSepIdx > 0) {
            theResult.append(theResourceName.substring(0, theLastSepIdx + 1));
        }
        theResult.append(sFileSeparator);
        theResult.append(theResourceName.substring(theLastSepIdx + 1, theResourceName.length()));
        theResult.append(FWD_SLASH);
        ResourceID theParentID = inResourceSpec.getCustomParentID();
        if (theParentID != null) {
            theResult.append(sCustomSeparator);
            theResult.append(theParentID.toString());
            theResult.append(FWD_SLASH);
        }
        if (!(theEscapedString = FilenameEscape.escapeUnicode(theResultString = theResult.toString())).equals(theResultString)) {
            theEscapedString = UNICODE_STRING_PRFX + theEscapedString;
        }
        return theEscapedString;
    }
}

