/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.repopaths;

import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.repopaths.PathLogicIdx;
import com.raplix.rolloutexpress.resource.repopaths.RepoPathLogic;
import java.io.File;

public class RedmondPathLogic
extends RepoPathLogic {
    public static final String RSRC_SUB_DIR_NAME = "_REDMOND_RESOURCES_/".toUpperCase();
    public static final String CASE_PREFIX = "0_";
    public static final char RUN_CONTINUE = '-';
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    protected PathLogicIdx getIdx() {
        return PathLogicIdx.REDMOND;
    }

    protected String getSubDir() {
        return RSRC_SUB_DIR_NAME;
    }

    protected String getSpecRepoRelDir(ResourceSpec inResourceSpec) {
        String theCaseSensitiveString = this.getSpecRepoRelDirCommon(inResourceSpec);
        return theCaseSensitiveString.toUpperCase() + RedmondPathLogic.encodeCase(inResourceSpec.getName()) + "/";
    }

    public static String encodeCase(String inString) {
        StringBuffer theResult = new StringBuffer();
        theResult.append(CASE_PREFIX);
        boolean isUpperState = false;
        int theRunLength = 0;
        for (int i = 0; i < inString.length(); ++i) {
            char theChar = inString.charAt(i);
            if (!Character.isLetter(theChar)) continue;
            boolean isUpperChar = Character.isUpperCase(theChar);
            if (isUpperChar == isUpperState) {
                if (++theRunLength != 16) continue;
                theResult.append('-');
                theRunLength = 0;
                continue;
            }
            theResult.append(HEX_CHARS[theRunLength]);
            isUpperState = isUpperChar;
            theRunLength = 1;
        }
        if (theRunLength > 0) {
            theResult.append(HEX_CHARS[theRunLength]);
        }
        return theResult.toString();
    }

    public static String decodeCase(String inString, String inEncodedCaseString) throws ResourceException {
        if (!inEncodedCaseString.startsWith(CASE_PREFIX)) {
            throw new ResourceException("rsrc.msg0491", new Object[]{inEncodedCaseString});
        }
        String theAllCapsString = inString.toUpperCase();
        boolean isUpperState = false;
        boolean theNumDecodedCases = false;
        StringBuffer theSB = new StringBuffer();
        int theCapsStringIdx = 0;
        for (int theCaseIdx = CASE_PREFIX.length(); theCaseIdx < inEncodedCaseString.length(); ++theCaseIdx) {
            char theChar;
            int theRunLength;
            char theCaseChar = inEncodedCaseString.charAt(theCaseIdx);
            if (theCaseChar == '-') {
                theRunLength = 16;
                while (theRunLength > 0) {
                    if (Character.isLetter(theChar = theAllCapsString.charAt(theCapsStringIdx++))) {
                        --theRunLength;
                        if (!isUpperState) {
                            theChar = Character.toLowerCase(theChar);
                        }
                    }
                    theSB.append(theChar);
                }
                continue;
            }
            theRunLength = '0' <= theCaseChar && theCaseChar <= '9' ? theCaseChar - 48 : 10 + theCaseChar - 65;
            while (theRunLength > 0) {
                if (Character.isLetter(theChar = theAllCapsString.charAt(theCapsStringIdx++))) {
                    --theRunLength;
                    if (!isUpperState) {
                        theChar = Character.toLowerCase(theChar);
                    }
                }
                theSB.append(theChar);
            }
            isUpperState = !isUpperState;
        }
        while (theCapsStringIdx < theAllCapsString.length()) {
            theSB.append(theAllCapsString.charAt(theCapsStringIdx++));
        }
        if (inString.length() != theCapsStringIdx) {
            throw new ResourceException("rsrc.msg0492", new Object[]{inString, inEncodedCaseString});
        }
        return theSB.toString();
    }

    public static ResourceSpec getResourceSpec(ResourceSubsysImpl inRsrcCtx, File inRepoFile) throws ResourceException {
        String theRepoPath = new File(inRsrcCtx.getAbsRepoRoot().toLocal()).toString().replace('\\', '/');
        String theFilePath = inRepoFile.getAbsolutePath().replace('\\', '/');
        int theSepOffset = theRepoPath.endsWith("/") ? 0 : 1;
        String theRelPath = theFilePath.substring(theRepoPath.length() + theSepOffset, theFilePath.length());
        if (!theFilePath.startsWith(theRepoPath)) {
            throw new ResourceException("rsrc.msg0493", new Object[]{theRelPath});
        }
        String theVarRelPath = theRelPath;
        if (!theVarRelPath.startsWith(RSRC_SUB_DIR_NAME)) {
            throw new ResourceException("rsrc.msg0494", new Object[]{theRelPath});
        }
        int theFileSepIdx = (theVarRelPath = theVarRelPath.substring(RSRC_SUB_DIR_NAME.length(), theVarRelPath.length())).indexOf(RepoPathLogic.sFileSeparator);
        if (theFileSepIdx == -1) {
            throw new ResourceException("rsrc.msg0495", new Object[]{theRelPath});
        }
        String theResourceName = theVarRelPath.substring(0, theFileSepIdx);
        theVarRelPath = theVarRelPath.substring(theFileSepIdx + RepoPathLogic.sFileSeparator.length(), theVarRelPath.length());
        int thePostNameSepIdx = theVarRelPath.indexOf(47);
        theResourceName = theResourceName + theVarRelPath.substring(0, thePostNameSepIdx);
        theVarRelPath = theVarRelPath.substring(thePostNameSepIdx + 1, theVarRelPath.length());
        ResourceID theCustomID = null;
        if (theVarRelPath.startsWith(RepoPathLogic.sCustomSeparator)) {
            theVarRelPath = theVarRelPath.substring(RepoPathLogic.sCustomSeparator.length(), theVarRelPath.length());
            int thePostIDSepIdx = theVarRelPath.indexOf(47);
            theCustomID = new ResourceID(theVarRelPath.substring(0, thePostIDSepIdx));
            theVarRelPath = theVarRelPath.substring(thePostIDSepIdx + 1, theVarRelPath.length());
        }
        int thePostEncodeSep = theVarRelPath.indexOf(47);
        String theCaseEncodeString = theVarRelPath.substring(0, thePostEncodeSep);
        theResourceName = RedmondPathLogic.decodeCase(theResourceName, theCaseEncodeString);
        return new ResourceSpec(theResourceName, theCustomID);
    }
}

