/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.resource.repopaths;

import com.raplix.rolloutexpress.resource.exception.ResourceException;

public class FilenameEscape {
    public static final int UNICODE_HEX_LENGTH = 4;
    private static final char UNICODE_CHAR_PRFX_0 = '_';
    public static final String UNICODE_CHAR_PRFX = "_";
    private static final int UNICODE_CHAR_PRFX_LENGTH = "_".length();

    public static boolean needsEscape(char inChar) {
        return inChar < '\u0000' || inChar > '\u007f' || Character.isISOControl(inChar);
    }

    public static String escapeUnicode(String inString) {
        int theIdx;
        int theLength = inString.length();
        char[] theChars = new char[theLength];
        inString.getChars(0, theLength, theChars, 0);
        for (theIdx = 0; theIdx < theLength && !FilenameEscape.needsEscape(theChars[theIdx]); ++theIdx) {
        }
        if (theIdx == theLength) {
            return inString;
        }
        StringBuffer theResult = new StringBuffer();
        theResult.ensureCapacity(theLength + 4);
        for (int i = 0; i < theLength; ++i) {
            char theChar = theChars[i];
            if (!FilenameEscape.needsEscape(theChar)) {
                if (theChar == '_') {
                    if (UNICODE_CHAR_PRFX_LENGTH != 1) {
                        throw new IllegalStateException("Code logic needs to change");
                    }
                    theResult.append(UNICODE_CHAR_PRFX);
                    theResult.append(UNICODE_CHAR_PRFX);
                    continue;
                }
                theResult.append(theChar);
                continue;
            }
            theResult.append(UNICODE_CHAR_PRFX);
            String theHex = Integer.toHexString(theChar);
            int theZeroPads = 4 - theHex.length();
            if (theZeroPads < 0) {
                throw new IllegalStateException("Unexpected length of hex integer representation");
            }
            for (int j = 0; j < theZeroPads; ++j) {
                theResult.append("0");
            }
            theResult.append(theHex);
        }
        return theResult.toString();
    }

    public static String unescapeUnicode(String inString) throws ResourceException {
        int theNextIdx = 0;
        StringBuffer theResult = new StringBuffer();
        while (true) {
            int theNextUniIdx;
            if ((theNextUniIdx = inString.indexOf(UNICODE_CHAR_PRFX, theNextIdx)) == -1) break;
            theResult.append(inString.substring(theNextIdx, theNextUniIdx));
            theNextIdx = theNextUniIdx + UNICODE_CHAR_PRFX_LENGTH;
            theNextUniIdx = inString.indexOf(UNICODE_CHAR_PRFX, theNextIdx);
            if (theNextUniIdx == theNextIdx) {
                theResult.append(UNICODE_CHAR_PRFX);
                theNextIdx += UNICODE_CHAR_PRFX_LENGTH;
                continue;
            }
            int theInt = 0;
            try {
                theInt = Integer.parseInt(inString.substring(theNextIdx, theNextIdx + 4), 16);
            }
            catch (NumberFormatException e) {
                throw new ResourceException(e);
            }
            theResult.append((char)theInt);
            theNextIdx += 4;
        }
        theResult.append(inString.substring(theNextIdx, inString.length()));
        return theResult.toString();
    }
}

